/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.cmd.stack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.progeeks.cmd.Command;
import org.progeeks.cmd.Result;
import org.progeeks.cmd.stack.CommandProcessorStack;
import org.progeeks.cmd.stack.StackEnvironment;
import org.progeeks.cmd.stack.StackableCommandProcessor;

public class QueuingStack
implements CommandProcessorStack,
StackEnvironment {
    private StackableCommandProcessor topCmdProc;
    private List<StackableCommandProcessor> cmdProcs = new LinkedList<StackableCommandProcessor>();
    private List<Command> commands = new ArrayList<Command>();

    public int getQueueSize() {
        return this.commands.size();
    }

    public Result execute(Command cmd) {
        if (this.topCmdProc == null || !this.topCmdProc.canExecute(cmd)) {
            this.commands.add(cmd);
            return null;
        }
        return this.topCmdProc.execute(cmd);
    }

    public void pushCommandProcessor(StackableCommandProcessor cmdProc) {
        this.cmdProcs.add(0, cmdProc);
        cmdProc.setStackEnvironment(this);
        this.topCmdProc = cmdProc;
        this.reprocessCommands();
    }

    public StackableCommandProcessor popCommandProcessor() {
        if (this.cmdProcs.size() == 0) {
            throw new RuntimeException("Command processor stack is empty.");
        }
        StackableCommandProcessor cmdProc = this.cmdProcs.remove(0);
        cmdProc.setStackEnvironment(null);
        this.topCmdProc = this.peekCommandProcessor();
        this.reprocessCommands();
        return cmdProc;
    }

    public StackableCommandProcessor peekCommandProcessor() {
        if (this.cmdProcs.size() == 0) {
            return null;
        }
        return this.cmdProcs.get(0);
    }

    public void clearQueue() {
        this.commands.clear();
    }

    private void reprocessCommands() {
        if (this.topCmdProc == null) {
            return;
        }
        Iterator<Command> i = this.commands.iterator();
        while (i.hasNext()) {
            Command cmd = i.next();
            if (!this.topCmdProc.canExecute(cmd)) continue;
            this.topCmdProc.execute(cmd);
            i.remove();
        }
    }
}

