
uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
//uniform vec4 m_Specular;
//uniform float m_Shininess;

uniform sampler2D m_NoiseMap;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec4 inTexCoord;

varying vec4 color;

#ifdef USE_TEXTURE
varying vec4 texCoord;
#endif

#ifdef POINT_SPRITE
uniform mat4 g_WorldViewProjectionMatrix;
uniform float g_Time;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;
uniform float m_Quadratic;
uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;

const float SIZE_MULTIPLIER = 4.0;
attribute float inSize;
#endif

uniform float m_Alpha;

void lightComputeDir(in vec3 worldPos, in vec4 color, in vec4 position, out vec4 lightDir){
    vec3 tempVec = position.xyz * -1.0;
    lightDir = vec4(normalize(tempVec), 1.0);
    /*
    float posLight = step(0.5, color.w);
    vec3 tempVec = position.xyz * sign(posLight - 0.5) - (worldPos * posLight);
     float dist = length(tempVec);
     lightDir.w = clamp(1.0 - position.w * dist * posLight, 0.0, 1.0);
     lightDir.xyz = tempVec / vec3(dist);*/
}

float lightComputeDiffuse(in vec3 norm, in vec3 lightdir){
    return max(0.0, dot(norm, lightdir));
}

/*
float lightComputeSpecular(in vec3 norm, in vec3 viewdir, in vec3 lightdir, in float shiny){
    vec3 H = (viewdir + lightdir) * vec3(0.5);
    return pow(max(dot(H, norm), 0.0), shiny);
}

vec2 computeLighting(in vec3 wvPos, in vec3 wvNorm, in vec3 wvViewDir, in vec4 wvLightPos){
    vec4 lightDir;
    lightComputeDir(wvPos, g_LightColor, wvLightPos, lightDir);

    float diffuseFactor = lightComputeDiffuse(wvNorm, lightDir.xyz);
    float specularFactor = lightComputeSpecular(wvNorm, wvViewDir, lightDir.xyz, 100.0); //m_Shininess);
    return vec2(diffuseFactor, specularFactor) * vec2(lightDir.w);
}*/

// The same wind noise that grass uses for now
// ... with some tweaks
/*float simpleNoise( float x, float y, float z )
{
    // We'll cheat and just adjust x by a little bit of
    // z and y by a lot bit of z and use them as a texture look-up.
    //x += z * 0.1;
    //y += z;
    //x = mod(x, 64.0) / 64.0;
    //y = mod(y, 64.0) / 64.0;
    //z = z / 64.0;
    x += z; // * 0.001;
    y += z * 0.1;
    x = mod(x * 0.05, 1.0);
    y = mod(y * 0.05, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x,y) ).r - 0.5;
}*/

// The version directly from grass.vert
float simpleNoise( float x, float y, float z )
{
    // We'll cheat and just adjust x by a little bit of
    // z and y by a lot bit of z and use them as a texture look-up.
    //x += z * 0.1;
    //y += z;
    //x = mod(x, 64.0) / 64.0;
    //y = mod(y, 64.0) / 64.0;
    //z = z / 64.0;
    x += z; // * 0.001;
    y += z * 0.1;
    x = mod(x / 16.0, 1.0);
    y = mod(y / 16.0, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x,y) ).r - 0.5;
}


float simpleNoise( float x, float y, float z, float time )
{
    // Move x,y to be in a nicer range
    x = x * 0.3;
    z = z * 0.3;
    
    x = mod(x, 1.0);
    z = mod(z, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x + time, z + y) ).r;
}

void main(){
    vec4 pos = vec4(inPosition, 1.0);

    gl_Position = g_WorldViewProjectionMatrix * pos;
    color = inColor;

    #ifdef USE_TEXTURE
        texCoord = inTexCoord;
    #endif
    
    // Calculate the view position and view dir
    vec3 wvPosition = (g_WorldViewMatrix * pos).xyz;
    vec3 viewDir = normalize(-wvPosition);
    vec3 wvNormal = vec3(0.0,0.0,1.0);

    vec4 lightColor = g_LightColor;
    
    // Color actually contains the amount of natural light and the
    // amount of local light.
    float sunFactor = inColor.a;
    float lightFactor = inColor.r;
 
    if( sunFactor > 0.0 )
        {
        // This way is it camera direction dependent but then things
        // unnervingly change light as you turn your head.
        //vec3 normal = normalize( vec3( g_CameraDirection.x, -1.0, g_CameraDirection.z ) );         
        //float l = max(0, dot( normal, g_LightPosition.xyz ));  
 
        // This was, the fake normal of the point surface is based on
        // camera -> object position.       
        vec4 worldPos = g_WorldMatrix * pos;        
        vec3 objCamDir = g_CameraPosition.xyz - worldPos.xyz;
        vec3 normal = normalize( objCamDir );
        float l = max(0.0, dot( normal, -g_LightPosition.xyz ));
        float lUp = max(0.0, dot( vec3(0.0,1.0,0.0), -g_LightPosition.xyz ));  
 
        l = l + lUp * 0.5;
        l = min( 0.9, l ); // reduce the max a little
        
        //float asun = max(0.3, min(1.0, sunFactor*2.0));
        float asun = clamp(sunFactor*2.0, 0.3, 1.0); 
 
        lightColor.w = 1.0;
        vec4 AmbientSum  = m_Ambient * lightColor;       
        color = AmbientSum * asun + lightColor * l * sunFactor; 
        color.a = 1.0;        
        }
    else
        {
        color = vec4(0.0);
        }

    if( lightFactor > 0.0 )
        {
        vec4 localLightDir = vec4(viewDir, 1.0);
        normalize(localLightDir);

        // Compute the lighting ourselves so we can do our own
        // attenuation using lightFactor as a 'distance' of sorts.
        float diffuseFactor = lightComputeDiffuse(wvNormal, localLightDir.xyz );
        //float specularFactor = 1.0;//lightComputeSpecular(wvNormal, viewDir.xyz, localLightDir.xyz, 1); //m_Shininess);

        float att = localLightDir.w;
        vec2 localLight = vec2(diffuseFactor, 0.0) * vec2(att);
        //vec2 localLight = vec2(diffuseFactor, specularFactor) * vec2(att);

        vec4 localColor = (m_Ambient + m_Diffuse * localLight.x);
        color += localColor * lightFactor;
        color.a = 1.0;        
        }

    #ifdef POINT_SPRITE
        vec4 worldPos = g_WorldMatrix * pos;

        float scale = length( g_WorldMatrix[0].xyz );         
        
        float y = pos.y - floor(pos.y);
        float yNorm = y - 0.1; //0.25;
        //gl_Position.x += y;

        // Calculate some wind offsets
        float windNoise = simpleNoise( pos.x, pos.z, g_Time * 0.5 );
        float windStrength = 1.0;
        vec2 windDirection = vec2(1.0, 0.0); 
 
        float xWind = (windStrength * windNoise * windDirection.x) * yNorm * 0.5;
        float zWind = (windStrength * windNoise * windDirection.y) * yNorm * 0.5;

        gl_Position.x += xWind * scale;
        gl_Position.z += zWind * scale;

        // Calculate the point size 
        float d = distance(g_CameraPosition.xyz, worldPos.xyz);
 
        gl_PointSize = max(1.0, ((inSize * SIZE_MULTIPLIER * m_Quadratic) / d) * scale );
        
        // Fade with distance
        color.a *= 1.0 - (max(d, 1.0) * 1.0 / 64.0); 
    #endif
}


