uniform mat4 g_WorldViewProjectionMatrix;
attribute vec3 inPosition;

#if defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPERATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

#ifdef NEED_TEXCOORD1
    attribute vec2 inTexCoord;
    varying vec2 texCoord1;
#endif

#ifdef SEPERATE_TEXCOORD
    attribute vec2 inTexCoord2;
    varying vec2 texCoord2;
#endif

#ifdef HAS_VERTEXCOLOR
    attribute vec4 inColor;
    varying vec4 vertColor;
#endif

uniform sampler2D m_ColorMap;

void main(){
    #ifdef NEED_TEXCOORD1
        texCoord1 = inTexCoord;
    #endif

    #ifdef SEPERATE_TEXCOORD
        texCoord2 = inTexCoord2;
    #endif

    #ifdef HAS_VERTEXCOLOR
        vertColor = inColor;
    #endif

    vec3 pos = inPosition;
    
    vec2 tc = pos.xz * 1.0 / 2048.0; //1024.0;
    texCoord1 = tc;

    vec4 color = texture2D(m_ColorMap, tc);    

    pos.y = color.a * 256.0;
    
    gl_Position = g_WorldViewProjectionMatrix * vec4(pos, 1.0);
}
