//#define ATTENUATION
//#define HQ_ATTENUATION

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat3 g_NormalMatrix;
uniform mat4 g_ViewMatrix;
uniform float g_Time;

uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
uniform vec4 m_Specular;
uniform float m_Shininess;

uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;

uniform sampler2D m_NoiseMap;

varying vec2 texCoord;

varying vec4 AmbientSum;
varying vec4 DiffuseSum;
//varying vec4 SpecularSum;

attribute vec3 inPosition;
attribute vec2 inTexCoord;
attribute vec3 inNormal;

/*#ifdef HQ_ATTENUATION
  varying vec3 lightVec;
#endif*/

/*#ifdef VERTEX_COLOR
//  attribute vec4 inColor;
#endif*/

#ifndef VERTEX_LIGHTING
  attribute vec4 inTangent;

  #ifndef NORMALMAP
    varying vec3 vNormal;
  #endif
  varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
#else   
  varying vec2 vLocalLight;  
  varying vec4 vFogColor;
  const float LOG2 = 1.442695;
#endif


// Added by me

attribute vec4 inColor;

varying float my_z;
#ifndef VERTEX_LIGHTING
    varying float sunFactor;
    varying float lightFactor;
#endif

uniform vec4 m_TimeParms;
uniform vec4 m_FogColor;

// Added by me


// JME3 lights in world space
void lightComputeDir(in vec3 worldPos, in vec4 color, in vec4 position, out vec4 lightDir){
    vec3 tempVec = position.xyz * -1.0;
    lightDir = vec4(normalize(tempVec), 1.0);
    /* 
    float posLight = step(0.5, color.w);
    vec3 tempVec = position.xyz * sign(posLight - 0.5) - (worldPos * posLight);
    #ifdef ATTENUATION
     float dist = length(tempVec);
     lightDir.w = clamp(1.0 - position.w * dist * posLight, 0.0, 1.0);
     lightDir.xyz = tempVec / vec3(dist);
     #ifdef HQ_ATTENUATION
       lightVec = tempVec;
     #endif
    #else
     lightDir = vec4(normalize(tempVec), 1.0);
    #endif*/
}

#ifdef VERTEX_LIGHTING
  float lightComputeDiffuse(in vec3 norm, in vec3 lightdir){
      return max(0.0, dot(norm, lightdir));
  }
/*
  float lightComputeSpecular(in vec3 norm, in vec3 viewdir, in vec3 lightdir, in float shiny){
      #ifndef LOW_QUALITY
        vec3 H = (viewdir + lightdir) * vec3(0.5);
        return pow(max(dot(H, norm), 0.0), shiny);
      #else
        return 0.0;
      #endif
  }

vec2 computeLighting(in vec3 wvPos, in vec3 wvNorm, in vec3 wvViewDir, in vec4 wvLightPos){
     vec4 lightDir;
     lightComputeDir(wvPos, g_LightColor, wvLightPos, lightDir);

     float diffuseFactor = lightComputeDiffuse(wvNorm, lightDir.xyz);
     float specularFactor = lightComputeSpecular(wvNorm, wvViewDir, lightDir.xyz, m_Shininess);
     //specularFactor *= step(0.01, diffuseFactor);
     return vec2(diffuseFactor, specularFactor) * vec2(lightDir.w);
  }*/
#endif

float simpleNoise( float x, float y, float z )
{
    // We'll cheat and just adjust x by a little bit of
    // z and y by a lot bit of z and use them as a texture look-up.
    //x += z * 0.1;
    //y += z;
    //x = mod(x, 64.0) / 64.0;
    //y = mod(y, 64.0) / 64.0;
    //z = z / 64.0;
    x += z; // * 0.001;
    y += z * 0.1;
    x = mod(x / 16.0, 1.0);
    y = mod(y / 16.0, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x,y) ).r - 0.5;
}

void main(){

   vec4 pos = vec4(inPosition, 1.0);

    // I think we should also be able to use our noise texture
    // to perturb our verts a little.
    /*float xShift = (texture2D( m_NoiseMap, vec2(pos.x,pos.z) ).r - 0.5) * 0.2;  
    pos.x += xShift;
    float zShift = (texture2D( m_NoiseMap, vec2(pos.z,pos.x) ).r - 0.5) * 0.2;  
    pos.z += zShift;*/           

 /*
    float height = pos.y - floor(pos.y);
    float timeScale = 0.6;
    float noise = simpleNoise( pos.x, pos.z, g_Time * timeScale );
 
    //float scale = 0.25;

    float windStrength = 0.5;
    vec3 windDirection = vec3(1.0, 0.75, 0.25); 
 
 
    float xWind = (windStrength * noise * windDirection.x) * height;
    float yWind = (windStrength * noise * windDirection.y) * height;
    float zWind = (windStrength * noise * windDirection.z) * height;

    pos.x += xWind;
    pos.y += yWind;
    pos.z += zWind;
*/
   //vec4 pos = vec4(inPosition, 1.0);
   gl_Position = g_WorldViewProjectionMatrix * pos;
   texCoord = inTexCoord;

    #ifndef VERTEX_LIGHTING
        // Added by me
        sunFactor = inColor.a;
        lightFactor = inColor.r;
    #else
        float sunFactor = inColor.a;
        float lightFactor = inColor.r;
    #endif
    my_z = gl_Position.z;

   vec3 wvPosition = (g_WorldViewMatrix * pos).xyz;
   //#ifndef LOW_QUALITY        
       vec3 wvNormal  = normalize(g_NormalMatrix * inNormal);
   //#else
   //    vec3 wvNormal  = g_NormalMatrix * inNormal;
   //#endif
   //vec3 wvNormal  = normalize(g_NormalMatrix * inNormal);
   vec3 viewDir = normalize(-wvPosition);

       //vec4 lightColor = g_LightColor[gl_InstanceID];
       //vec4 lightPos   = g_LightPosition[gl_InstanceID];
       //vec4 wvLightPos = (g_ViewMatrix * vec4(lightPos.xyz, lightColor.w));
       //wvLightPos.w = lightPos.w;

   vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz, g_LightColor.w));
   wvLightPos.w = g_LightPosition.w;
   vec4 lightColor = g_LightColor;

   #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
     vec3 wvTangent = normalize(g_NormalMatrix * inTangent.xyz);
     vec3 wvBinormal = cross(wvNormal, wvTangent);

     mat3 tbnMat = mat3(wvTangent, wvBinormal * -inTangent.w,wvNormal);

     vPosition = wvPosition * tbnMat;
     vViewDir  = viewDir * tbnMat;
     lightComputeDir(wvPosition, lightColor, wvLightPos, vLightDir);
     vLightDir.xyz = (vLightDir.xyz * tbnMat).xyz;
   #elif !defined(VERTEX_LIGHTING)
     vNormal = wvNormal;

     vPosition = wvPosition;
     vViewDir = viewDir;

     lightComputeDir(wvPosition, lightColor, wvLightPos, vLightDir);

     #ifdef V_TANGENT
        vNormal = normalize(g_NormalMatrix * inTangent.xyz);
        vNormal = -cross(cross(vLightDir.xyz, vNormal), vNormal);
     #endif
   #endif

   lightColor.w = 1.0;
   #ifdef MATERIAL_COLORS
      AmbientSum  = m_Ambient * lightColor; //  * g_AmbientLightColor;
      DiffuseSum  = m_Diffuse  * lightColor;
      //SpecularSum = m_Specular * lightColor;
    #else
      AmbientSum  = vec4(0.2, 0.2, 0.2, 1.0) * g_AmbientLightColor; // Default: ambient color is dark gray
      DiffuseSum  = lightColor;
      //SpecularSum = lightColor;
    #endif

    //#ifdef VERTEX_COLOR
    //  AmbientSum *= inColor;
    //  DiffuseSum *= inColor;
    //#endif

    #ifdef VERTEX_LIGHTING
        vec4 lightDir;
        lightComputeDir(wvPosition, g_LightColor, wvLightPos, lightDir);
        
        vec2 light;        
        if( sunFactor > 0.0 )
            {
            // Dir is already normalized coming out of lightComputeDir... or should be. 
            lightDir.xyz = lightDir.xyz * sunFactor; 

            float diffuseFactor = lightComputeDiffuse(wvNormal, lightDir.xyz);
            //float specularFactor = lightComputeSpecular(wvNormal, viewDir, lightDir.xyz, m_Shininess);
            ////specularFactor *= step(0.01, diffuseFactor);
            //light = vec2(diffuseFactor, specularFactor) * vec2(lightDir.w);
            light = vec2(diffuseFactor, 0.0) * vec2(lightDir.w);
       
            float asun = max(0.3, min(1.0, sunFactor*2.0));
            AmbientSum *= asun;
            }
        else
            {
            light.x = 0.0;
            light.y = 0.0;
            }

        AmbientSum.a  = light.x;
        //SpecularSum.a = light.y;
 
        if( lightFactor > 0.0 )
            {
            //float lightDot = dot(lightDir.xyz, wvNormal);
            //float overall = sunFactor * m_TimeParms.x * lightDot;

            float localLightScale = lightFactor;
            //if( overall > 0.0 )
            //    localLightScale = localLightScale * (1.0 - overall);
    
            if( localLightScale > 0.0 )
                {
                // Compute the lighting ourselves so we can do our own
                // attenuation using lightFactor as a 'distance' of sorts.
                float diffuseFactor = lightComputeDiffuse(wvNormal, viewDir.xyz );
                //float specularFactor = lightComputeSpecular(normal, viewDir.xyz, localLightDir.xyz, m_Shininess);
                //specularFactor *= step(1.0, m_Shininess);
                
                vLocalLight.x = diffuseFactor;
                vLocalLight.y = localLightScale;                   
                }
            }
        else
            {
            vLocalLight.x = 0.0;
            vLocalLight.y = 0.0;
            }
 
        float fogDensity = 1.2; 
        vec4 fogColor = m_FogColor;
        float fogDistance = fogColor.a;
    
        float depth = my_z / fogDistance; 
    
        float fogFactor = exp2( -fogDensity * fogDensity * depth *  depth * LOG2 );
        fogFactor = clamp(fogFactor, 0.0, 1.0);
        vFogColor = fogColor;
        vFogColor.a = fogFactor;
                  
    #endif

}
