//#define ATTENUATION
//#define HQ_ATTENUATION


uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
uniform vec4 m_Specular;

uniform vec4 m_FogColor;

varying vec2 texCoord;

#ifdef NOISEMAP
varying vec2 noiseTexCoord;
#endif             

varying vec4 AmbientSum;
varying vec4 DiffuseSum;
//varying vec4 SpecularSum;

#ifndef VERTEX_LIGHTING
  varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
#else
  varying vec2 vLocalLight;  
  varying vec4 vFogColor;
#endif

#ifdef DIFFUSEMAP
  uniform sampler2D m_DiffuseMap;
#endif

#ifdef NOISEMAP
  uniform sampler2D m_NoiseMap;
#endif

//#ifdef SPECULARMAP
  //uniform sampler2D m_SpecularMap;
//#endif

#ifdef PARALLAXMAP
  uniform sampler2D m_ParallaxMap;
#endif

#ifdef NORMALMAP
  uniform sampler2D m_NormalMap;
#else
  varying vec3 vNormal;
#endif

#ifdef ALPHAMAP
  uniform sampler2D m_AlphaMap;
#endif

#ifdef COLORRAMP
  uniform sampler2D m_ColorRamp;
#endif

// Added by me

uniform vec4 m_TimeParms;

// Added by me

uniform float m_AlphaDiscardThreshold;
#ifndef VERTEX_LIGHTING
    uniform float m_Shininess;


    // Added by me

    // These are only used here if vertex lighting is off.
    varying float my_z;
    varying float sunFactor;
    varying float lightFactor;
    
    // Added by me

/*#ifdef HQ_ATTENUATION
uniform vec4 g_LightPosition;
varying vec3 lightVec;
#endif*/

float tangDot(in vec3 v1, in vec3 v2){
    float d = dot(v1,v2);
    #ifdef V_TANGENT
        d = 1.0 - d*d;
        return step(0.0, d) * sqrt(d);
    #else
        return d;
    #endif
}

float lightComputeDiffuse(in vec3 norm, in vec3 lightdir, in vec3 viewdir){
    #ifdef MINNAERT
        float NdotL = max(0.0, dot(norm, lightdir));
        float NdotV = max(0.0, dot(norm, viewdir));
        return NdotL * pow(max(NdotL * NdotV, 0.1), -1.0) * 0.5;
    #else
        return max(0.0, dot(norm, lightdir));
    #endif
}

/*float lightComputeSpecular(in vec3 norm, in vec3 viewdir, in vec3 lightdir, in float shiny){
    #ifdef LOW_QUALITY
       // Blinn-Phong
       // Note: preferably, H should be computed in the vertex shader
       vec3 H = (viewdir + lightdir) * vec3(0.5);
       return pow(max(tangDot(H, norm), 0.0), shiny);
    #elif defined(WARDISO)
        // Isotropic Ward
        vec3 halfVec = normalize(viewdir + lightdir);
        float NdotH  = max(0.001, tangDot(norm, halfVec));
        float NdotV  = max(0.001, tangDot(norm, viewdir));
        float NdotL  = max(0.001, tangDot(norm, lightdir));
        float a      = tan(acos(NdotH));
        float p      = max(shiny/128.0, 0.001);
        return NdotL * (1.0 / (4.0*3.14159265*p*p)) * (exp(-(a*a)/(p*p)) / (sqrt(NdotV * NdotL)));
    #else
       // Standard Phong
       vec3 R = reflect(-lightdir, norm);
       return pow(max(tangDot(R, viewdir), 0.0), shiny);
    #endif
}*/

vec2 computeLighting(in vec3 wvPos, in vec3 wvNorm, in vec3 wvViewDir, in vec3 wvLightDir){
   float diffuseFactor = lightComputeDiffuse(wvNorm, wvLightDir, wvViewDir);
   //float specularFactor = lightComputeSpecular(wvNorm, wvViewDir, wvLightDir, m_Shininess);
   //specularFactor *= step(1.0, m_Shininess);

   //#ifdef HQ_ATTENUATION
   // float att = clamp(1.0 - g_LightPosition.w * length(lightVec), 0.0, 1.0);
   //#else
   // float att = vLightDir.w;
   //#endif

   return vec2(diffuseFactor, 0.0); // * vec2(att);
   //return vec2(diffuseFactor, specularFactor) * vec2(att);
}
#endif

const float LOG2 = 1.442695;

void main(){
    vec2 newTexCoord;

    #if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
//    #if defined(PARALLAXMAP) || defined(NORMALMAP_PARALLAX) && !defined(VERTEX_LIGHTING) 
       float h;
       float bumpDepth;
       #ifdef PARALLAXMAP
          bumpDepth = h = texture2D(m_ParallaxMap, texCoord).r;
       #else
          bumpDepth = h = texture2D(m_NormalMap, texCoord).a;
       #endif
       float heightScale = 0.05;
       float heightBias = heightScale * -0.5;
       vec3 normView = normalize(vViewDir);
       h = (h * heightScale + heightBias) * normView.z;
       normView.y = -normView.y;
       //newTexCoord = texCoord + (h * -normView.xy);
       newTexCoord = texCoord + (h * normView.xy);
    #else
       newTexCoord = texCoord;
    #endif

   #ifdef DIFFUSEMAP
      vec4 diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
#ifdef NOISEMAP      
//diffuseColor *= min(1.0, (texture2D(m_NoiseMap, noiseTexCoord) * 0.125) + vec4(0.875));
//diffuseColor *= min(1.0, (texture2D(m_NoiseMap, noiseTexCoord) * 0.2) + vec4(0.8));
//vec4 adjust = texture2D(m_NoiseMap, noiseTexCoord) * 0.1 - 0.05; 
//diffuseColor = clamp( diffuseColor + adjust, vec4(0.0), vec4(1.0) );
vec4 adjust = texture2D(m_NoiseMap, noiseTexCoord);
//adjust *= texture2D(m_NoiseMap, noiseTexCoord * 0.25);
//adjust = (adjust + texture2D(m_NoiseMap, noiseTexCoord * 0.25)) * 0.5;
adjust = (adjust + texture2D(m_NoiseMap, noiseTexCoord * 0.25));
adjust.a = 1.0;  
//diffuseColor = clamp( diffuseColor * ((adjust * 0.2) + vec4(0.9)), vec4(0.0), vec4(1.1) );
//diffuseColor = diffuseColor * ((adjust * 0.2) + vec4(0.95));
//diffuseColor = diffuseColor * ((adjust * 0.4) + vec4(0.8));
#if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
//diffuseColor = step( h, 0.1 ) * vec4(1.0,0.0,0.0,1.0);
//float heightFactor = 0.75;
float heightFactor = 0.25;
heightFactor = heightFactor * heightFactor;
//float noiseCurve = 0.95;
float noiseCurve = 0.8;
float noiseScale = 0.75; //0.5;
adjust.r = min(1.0, adjust.r); // * noiseFactor;

// Take the range 0 - 1 and move it so that noiseFactor is the middle.
// So, anything between 0 and noiseFactor gets multiplied by 0.5 / noiseFactor
// and anything between noiseFactor and 1 gets normalized to noiseFactor
// and multiplied by 0.5 / (1 - noiseFactor) before being readded to 0.5. 

float lowFactor = 0.5 / noiseCurve;
float hiFactor = 0.5 / (1.0 - noiseCurve);

// If noise is less than noiseFactor then we need a low part
float low = adjust.r * lowFactor * step( adjust.r, noiseCurve );
float hi = (0.5 + ((adjust.r - noiseCurve) * hiFactor)) * step( noiseCurve, adjust.r ); 
adjust.r = low + hi;

//float factor = (1.0 - bumpDepth) * heightFactor * adjust.r * adjust.r;
bumpDepth = max(0.0, heightFactor - (bumpDepth * bumpDepth));
//float factor = bumpDepth * bumpDepth * bumpDepth; // * heightFactor;
float factor = bumpDepth / heightFactor;
//factor = factor * adjust.r * adjust.r; // * adjust.r * adjust.r; // * noiseFactor;
factor = factor * adjust.r * adjust.r * adjust.r * noiseScale;
//vec4 dirt = vec4(1.0,0.0,0.0,1.0);
//vec4 dirt = vec4( 80.0/255.0, 56.0/255.0, 33.0/255.0, 1.0 );  
//vec4 dirt = vec4( 40.0/255.0, 28.0/255.0, 16.5/255.0, 1.0 );  
vec4 dirt = vec4( 40.0/255.0, 48.0/255.0, 16.5/255.0, 1.0 );  
//diffuseColor = mix( diffuseColor, dirt, factor * step(0.25, factor) );
diffuseColor = mix( diffuseColor, dirt, factor );//* step(bumpDepth, heightFactor) );
#else
//diffuseColor = diffuseColor * ((adjust * 0.4) + vec4(0.8));
//diffuseColor = ((adjust * 0.4) + vec4(0.8)) * vec4(0.0,1.0,0.0,1.0);
#endif
#endif      
    #else
      vec4 diffuseColor = vec4(1.0);
    #endif
    float alpha = DiffuseSum.a * diffuseColor.a;
    #ifdef ALPHAMAP
       alpha = alpha * texture2D(m_AlphaMap, newTexCoord).r;
    #endif

    #ifdef USE_ALPHA
        if(alpha < m_AlphaDiscardThreshold){
            discard;
        }
        if( diffuseColor.a == 0.0 )
        	discard;
    #endif


    // ***********************
    // Read from textures
    // ***********************
    #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING) 
      vec4 normalHeight = texture2D(m_NormalMap, newTexCoord);
      vec3 normal = (normalHeight.xyz * vec3(2.0) - vec3(1.0));
      #ifdef LATC
        normal.z = sqrt(1.0 - (normal.x * normal.x) - (normal.y * normal.y));
      #endif
      //normal.y = -normal.y;
    #elif !defined(VERTEX_LIGHTING)
      vec3 normal = vNormal;
      #if !defined(LOW_QUALITY) && !defined(V_TANGENT)
         normal = normalize(normal);
      #endif
    #endif

    /*#ifdef SPECULARMAP
      vec4 specularColor = texture2D(m_SpecularMap, newTexCoord);
    #else
      vec4 specularColor = vec4(1.0);
    #endif*/

    #ifdef VERTEX_LIGHTING
        vec2 light = vec2(AmbientSum.a, 0.0); //SpecularSum.a);
        #ifdef COLORRAMP
           light.x = texture2D(m_ColorRamp, vec2(light.x, 0.0)).r;
           light.y = texture2D(m_ColorRamp, vec2(light.y, 0.0)).r;
        #endif

        gl_FragColor =  (AmbientSum + DiffuseSum * light.x) * diffuseColor;
                     //+ (SpecularSum) * light.y * specularColor;
                     
        if( vLocalLight.y > 0.0 )
            {
            vec4 localColor = (m_Ambient + m_Diffuse * vLocalLight.x) * diffuseColor;
            gl_FragColor += localColor * vLocalLight.y;            
            }
 
        // Mix in the fog.
        gl_FragColor.xyz = mix(vFogColor.xyz, gl_FragColor.xyz, vFogColor.a);
                                 
    #else
        /*
        Original way...
       vec4 lightDir = vLightDir;
       lightDir.xyz = normalize(lightDir.xyz);

       vec2 light = computeLighting(vPosition, normal, vViewDir.xyz, lightDir.xyz);
       #ifdef COLORRAMP
           diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
           specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
       #endif
       gl_FragColor = (AmbientSum + DiffuseSum * light.x) * diffuseColor
                     + SpecularSum * light.y * specularColor;

                     Above is the same as:
                     AmbientSum * diffuseColor
                     + DiffuseSum * diffuseColor * light.x

        */


        /*
         From the 02-21-2011 build
       vec4 lightDir = vLightDir;
       lightDir.xyz = normalize(lightDir.xyz);

       vec2 light = computeLighting(vPosition, normal, vViewDir.xyz, lightDir.xyz);
       #ifdef COLORRAMP
           diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
           specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
       #endif
       gl_FragColor =  AmbientSum * diffuseColor +
                       DiffuseSum * diffuseColor  * light.x +
                       SpecularSum * specularColor * light.y;

          ...essentially identical.
        */

        // My way...
        if( sunFactor > 0.0 )
            {
            vec4 lightDir = vLightDir;
            lightDir.xyz = normalize(lightDir.xyz) * sunFactor;

            vec2 light = computeLighting(vPosition, normal, vViewDir.xyz, lightDir.xyz);
            #ifdef COLORRAMP
                diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
                //specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
            #endif
       //gl_FragColor = (AmbientSum + DiffuseSum * light.x * sunFactor) * diffuseColor
       //              + SpecularSum * light.y * specularColor * sunFactor;
       //gl_FragColor = (AmbientSum * sunFactor + DiffuseSum * light.x * sunFactor) * diffuseColor
       //              + SpecularSum * light.y  * sunFactor * specularColor;

            float asun = max(0.3, min(1.0, sunFactor*2.0));
       //float asun = max(max(lightFactor,0.1) * 3, min(1.0, sunFactor*2));
       //float asun = max(0.3, min(1.0, sunFactor));
       //gl_FragColor = (AmbientSum * asun + DiffuseSum * light.x * sunFactor) * diffuseColor
       //              + SpecularSum * light.y  * sunFactor * specularColor;
            gl_FragColor = (AmbientSum * asun + DiffuseSum * light.x ) * diffuseColor;
                            //+ SpecularSum * light.y * specularColor;
       //gl_FragColor = (AmbientSum * DiffuseSum * light.x ) * diffuseColor
       //              + SpecularSum * light.y * specularColor;
            //gl_FragColor.r = 1.0;
            }
        else
            {
            gl_FragColor = vec4(0.0);
            }

        // Try to scale the local light factor as appropriate for the
        // time of day.
        // Basically, if the sun is shining directly onto a surface then
        // we want to defer to the sunlight rather than the local light...
        // ie: instead of adding them both together.
        float lightDot = dot(vLightDir.xyz, normal);
        float overall = sunFactor * m_TimeParms.x * lightDot;

        float localLightScale = lightFactor;
        if( overall > 0.0 )
            localLightScale = localLightScale * (1.0 - overall);

//        if( lightFactor >= overall )
//        if( lightFactor > 0.0 )
        if( localLightScale > 0.0 )
            {
            // Trying some things
            // Use view dir for both light and view
            //vec3 localLightDir = vViewDir.xyz;
            //vec4 localLightDir = vec4(vViewDir, lightFactor);
            vec4 localLightDir = vec4(vViewDir, 1.0);
            //localLightDir.w = lightFactor;
            normalize(localLightDir);

            //vec2 localLight = computeLighting( vPosition, normal, vViewDir.xyz, localLightDir );
            ////////vec2 localLight = computeLighting( vPosition, normal, vViewDir.xyz, vViewDir.xyz) * lightFactor;

            // Compute the lighting ourselves so we can do our own
            // attenuation using lightFactor as a 'distance' of sorts.
            float diffuseFactor = lightComputeDiffuse(normal, vViewDir.xyz, localLightDir.xyz );
            //float specularFactor = lightComputeSpecular(normal, vViewDir.xyz, localLightDir.xyz, m_Shininess);
            //specularFactor *= step(1.0, m_Shininess);

            float att = localLightDir.w;
            vec2 localLight = vec2(diffuseFactor, 0.0) * vec2(att);
            //vec2 localLight = vec2(diffuseFactor, specularFactor) * vec2(att);

            vec4 localColor = (m_Ambient + m_Diffuse * localLight.x) * diffuseColor;
                                //+ m_Specular * localLight.y * specularColor;
            //gl_FragColor += localColor * lightFactor; //(lightFactor * lightFactor);
            //if( sunFactor < 0.5 )
            //    gl_FragColor += localColor * lightFactor * 2.0 * (1.0 - sunFactor);
            //else
            //gl_FragColor += localColor * lightFactor; // * 2.0 * (1.0 - length(gl_FragColor));
            //gl_FragColor += localColor * lightFactor; // * 2.0 * (1.0 - length(gl_FragColor));
            gl_FragColor += localColor * localLightScale; // * 2.0 * (1.0 - length(gl_FragColor));
            }

        //if( lightFactor > sunFactor )
        //    gl_FragColor *= lightFactor;
            //gl_FragColor += vec4(1) * lightFactor;

        //if( light.x < 0.5 )
        //    gl_FragColor.r = 1.0;
        //if( light.y < 0.5 )
        //    gl_FragColor.g = 1.0;
    #endif



    #ifndef VERTEX_LIGHTING
        float fogDensity = 1.2; //1.0; //2.0;
        //float fogVal = 1.0 / my_z;
        //vec4 fogColor = vec4(0.9);
        vec4 fogColor = m_FogColor;
        float fogDistance = fogColor.a;
        fogColor.a = 1.0;
    
        float depth = my_z / fogDistance; //FOG_DISTANCE;
    
        float fogFactor = exp2( -fogDensity * fogDensity * depth *  depth * LOG2 );
        fogFactor = clamp(fogFactor, 0.0, 1.0);
        gl_FragColor =mix(fogColor,gl_FragColor,fogFactor);
    #endif


    gl_FragColor.a = alpha;
}
