//#define ATTENUATION
//#define HQ_ATTENUATION

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat3 g_NormalMatrix;
uniform mat4 g_ViewMatrix;

uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
uniform vec4 m_Specular;
uniform float m_Shininess;

uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;

varying vec2 texCoord;

varying vec4 AmbientSum;
varying vec4 DiffuseSum;
//varying vec4 SpecularSum;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

#ifndef NORMAL_LOOKUP
  attribute vec3 inNormal;
#endif

#ifdef HQ_ATTENUATION
  varying vec3 lightVec;
#endif

#ifdef VERTEX_COLOR
//  attribute vec4 inColor;
#endif

#ifndef VERTEX_LIGHTING
  #ifndef NORMAL_LOOKUP
    attribute vec3 inTangent;
  #endif

  #ifndef NORMALMAP
    varying vec3 vNormal;
  #endif
  varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
#else
  varying vec2 vLocalLight;  
  varying vec4 vFogColor;
  const float LOG2 = 1.442695;
#endif


// Added by me

attribute vec4 inColor;

#ifndef VERTEX_LIGHTING
    varying float my_z;
    varying float sunFactor;
    varying float lightFactor;
#endif

uniform vec4 m_TimeParms;
uniform vec4 m_FogColor;

uniform float m_Thickness;

// Added by me


// JME3 lights in world space
void lightComputeDir(in vec3 worldPos, in vec4 color, in vec4 position, out vec4 lightDir){
    vec3 tempVec = position.xyz * -1.0;
    lightDir = vec4(normalize(tempVec), 1.0);
    /* 
    float posLight = step(0.5, color.w);
    vec3 tempVec = position.xyz * sign(posLight - 0.5) - (worldPos * posLight);
    #ifdef ATTENUATION
     float dist = length(tempVec);
     lightDir.w = clamp(1.0 - position.w * dist * posLight, 0.0, 1.0);
     lightDir.xyz = tempVec / vec3(dist);
     #ifdef HQ_ATTENUATION
       lightVec = tempVec;
     #endif
    #else
     lightDir = vec4(normalize(tempVec), 1.0);
    #endif*/
}

#ifdef VERTEX_LIGHTING
  float lightComputeDiffuse(in vec3 norm, in vec3 lightdir){
      return max(0.0, dot(norm, lightdir));
  }
/*
  float lightComputeSpecular(in vec3 norm, in vec3 viewdir, in vec3 lightdir, in float shiny){
      #ifndef LOW_QUALITY
        vec3 H = (viewdir + lightdir) * vec3(0.5);
        return pow(max(dot(H, norm), 0.0), shiny);
      #else
        return 0.0;
      #endif
  }

vec2 computeLighting(in vec3 wvPos, in vec3 wvNorm, in vec3 wvViewDir, in vec4 wvLightPos){
     vec4 lightDir;
     lightComputeDir(wvPos, g_LightColor, wvLightPos, lightDir);

     float diffuseFactor = lightComputeDiffuse(wvNorm, lightDir.xyz);
     float specularFactor = lightComputeSpecular(wvNorm, wvViewDir, lightDir.xyz, m_Shininess);
     //specularFactor *= step(0.01, diffuseFactor);
     return vec2(diffuseFactor, specularFactor) * vec2(lightDir.w);
  }*/
#endif


void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;
    texCoord = inTexCoord;

    #ifndef VERTEX_LIGHTING
        // Added by me
        sunFactor = inColor.a;
        lightFactor = inColor.r;
        my_z = gl_Position.z;
    #else
        float sunFactor = inColor.a;
        float lightFactor = inColor.r;
        float my_z = gl_Position.z;
    #endif

    vec3 wvPosition = (g_WorldViewMatrix * pos).xyz;
    ///vec3 wvNormal  = normalize(g_NormalMatrix * normal);
    vec3 wvNormal  = g_NormalMatrix * inNormal;
 
    float nLength = length(wvNormal); // should give us the scale if we want it
    wvNormal = wvNormal / nLength;

    // This kind of works... but it doesn't give us a proper
    // normal
    //vec2 ortho = normalize(vec2(-wvNormal.y, wvNormal.x));
    //gl_Position.xy -= ortho * texCoord.x;
 
    // In view space, 0,0,-1 should be "into the screen" and 
    // we can use that to find a normal orthogonal to the rope
    // direction as long as we aren't looking directly down the
    // rope.  In that case, it's better to fudge something.
    vec3 look = wvPosition; //vec3(0.0, 0.0, -1.0);
    //float dot = abs(dot(look, wvNormal));
    //if( dot < 1.0 )
    //    { 
        vec3 ortho = cross(look, wvNormal);
        
        // Lean the ortho vector in towards the screen
        // a little bit because we also use it for the
        // normal and this way it will get interpolated
        // correctly.  texCoord.x is +/- 0.5
        //ortho.z += 0.01;
        // Even though the normal will be a little off,
        // it's easier to do this below since we need
        // to add it even after reversing the direction
        
        ortho = normalize(ortho);
        gl_Position.xyz += ortho * texCoord.x * m_Thickness;
 
        vec3 ropeDir = wvNormal;       
        wvNormal = ortho;
        texCoord.x += 0.5;
        if( texCoord.x == 0.0 )
            {
            wvNormal *= -1.0;
            ropeDir *= -1.0;
            }
 
    //    wvNormal.z += 0.5;
        //wvNormal = normalize(wvNormal);                        

    // A simple adding in the Z doesn't really fix the issue because
    // the "view dependence" means that the rope changes shading as the
    // camera looks around... which isn't right.
    // What we really want to do is deflect it slightly in the binormal
    // direction, I think.  Unfortunately, we need to do it before we
    // calculate the birnormal because the real binormal needs to take
    // it into account.
    vec3 bn = cross(wvNormal, ropeDir);
    wvNormal += bn * 0.5;
    wvNormal = normalize(wvNormal);
        
    vec3 viewDir = normalize(-wvPosition);
    //wvNormal = -viewDir;

    vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz, g_LightColor.w));
    wvLightPos.w = g_LightPosition.w;
    vec4 lightColor = g_LightColor;

    #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
        vec3 wvTangent = ropeDir; //normalize(g_NormalMatrix * inTangent); 
        vec3 wvBinormal = cross(wvNormal, wvTangent);
        float flip = 1.0;
        if( texCoord.x == 0.0 )
            flip = -1.0;
            
        mat3 tbnMat = mat3(wvTangent, wvBinormal * flip, wvNormal);
    
        vPosition = wvPosition * tbnMat;
        vViewDir  = viewDir * tbnMat;
        lightComputeDir(wvPosition, lightColor, wvLightPos, vLightDir);
        vLightDir.xyz = (vLightDir.xyz * tbnMat).xyz;
    #elif !defined(VERTEX_LIGHTING)
        vNormal = wvNormal;

        vPosition = wvPosition;
        vViewDir = viewDir;

        lightComputeDir(wvPosition, lightColor, wvLightPos, vLightDir);

        #ifdef V_TANGENT
            #ifdef NORMAL_LOOKUP
                vNormal = normalize(g_NormalMatrix * tangent);
            #else
                vNormal = normalize(g_NormalMatrix * inTangent.xyz);
            #endif
            vNormal = -cross(cross(vLightDir.xyz, vNormal), vNormal);
        #endif
    #endif

    lightColor.w = 1.0;
    #ifdef MATERIAL_COLORS
        AmbientSum  = m_Ambient * lightColor; //  * g_AmbientLightColor;
        DiffuseSum  = m_Diffuse  * lightColor;
        //SpecularSum = m_Specular * lightColor;
    #else
        AmbientSum  = vec4(0.2, 0.2, 0.2, 1.0) * g_AmbientLightColor; // Default: ambient color is dark gray
        DiffuseSum  = lightColor;
        //SpecularSum = lightColor;
    #endif

    //#ifdef VERTEX_COLOR
    //  AmbientSum *= inColor;
    //  DiffuseSum *= inColor;
    //#endif

    #ifdef VERTEX_LIGHTING
        vec4 lightDir;
        lightComputeDir(wvPosition, g_LightColor, wvLightPos, lightDir);
        
        vec2 light;        
        if( sunFactor > 0.0 )
            {
            // Dir is already normalized coming out of lightComputeDir... or should be. 
            lightDir.xyz = lightDir.xyz * sunFactor; 

            float diffuseFactor = lightComputeDiffuse(wvNormal, lightDir.xyz);
            //float specularFactor = lightComputeSpecular(wvNormal, viewDir, lightDir.xyz, m_Shininess);
            ////specularFactor *= step(0.01, diffuseFactor);
            //light = vec2(diffuseFactor, specularFactor) * vec2(lightDir.w);
            light = vec2(diffuseFactor, 0.0) * vec2(lightDir.w);
       
            float asun = max(0.3, min(1.0, sunFactor*2.0));
            AmbientSum *= asun;
            }
        else
            {
            light.x = 0.0;
            light.y = 0.0;
            }

        AmbientSum.a  = light.x;
        //SpecularSum.a = light.y;
 
        if( lightFactor > 0.0 )
            {
            float lightDot = dot(lightDir.xyz, wvNormal);
            float overall = sunFactor * m_TimeParms.x * lightDot;

            float localLightScale = lightFactor;
            if( overall > 0.0 )
                localLightScale = localLightScale * (1.0 - overall);
    
            if( localLightScale > 0.0 )
                {
                // Compute the lighting ourselves so we can do our own
                // attenuation using lightFactor as a 'distance' of sorts.
                float diffuseFactor = lightComputeDiffuse(wvNormal, viewDir.xyz );
                //float specularFactor = lightComputeSpecular(normal, viewDir.xyz, localLightDir.xyz, m_Shininess);
                //specularFactor *= step(1.0, m_Shininess);
                
                vLocalLight.x = diffuseFactor;
                vLocalLight.y = localLightScale;                   
                }
            }
        else
            {
            vLocalLight.x = 0.0;
            vLocalLight.y = 0.0;
            }
 
        float fogDensity = 1.2; 
        vec4 fogColor = m_FogColor;
        float fogDistance = fogColor.a;
    
        float depth = my_z / fogDistance; 
    
        float fogFactor = exp2( -fogDensity * fogDensity * depth *  depth * LOG2 );
        fogFactor = clamp(fogFactor, 0.0, 1.0);
        vFogColor = fogColor;
        vFogColor.a = fogFactor;
                  
    #endif

}
