/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.FluidSlope;
import com.simsilica.mblock.MaskUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidUtils {
    static Logger log = LoggerFactory.getLogger(FluidUtils.class);
    public static final int TYPE_MASK = 31;
    public static final int LEVEL_MASK = 480;
    public static final int SIDE_MASK_BITS = 63;
    public static final int SIDE_MASK = -67108864;
    public static final int CONNECT_MASK_BITS = 15;
    public static final int CONNECT_MASK_SHIFT = 22;
    public static final int CONNECT_MASK = 0x3C00000;
    public static final int SLOPE_BITS = 4095;
    public static final int SLOPE_MASK_SHIFT = 9;
    public static final int SLOPE_MASK = 2096640;
    private static final int D_NW = 0;
    private static final int D_N = 1;
    private static final int D_NE = 2;
    private static final int D_E = 3;
    private static final int D_SE = 4;
    private static final int D_S = 5;
    private static final int D_SW = 6;
    private static final int D_W = 7;

    public static int getType(int value) {
        return value & 0x1F;
    }

    public static int getLevel(int value) {
        if (FluidUtils.getType(value) > 0) {
            return FluidUtils.getRawLevel(value) + 1;
        }
        return 0;
    }

    public static int getRawLevel(int value) {
        return (value & 0x1E0) >> 5;
    }

    public static int setLevel(int value, int level) {
        level = Math.max(0, level - 1);
        return value & 0xFFFFFE1F | level << 5;
    }

    public static int getSlopeBits(int value) {
        return (value & 0x1FFE00) >> 9;
    }

    public static int setSlopeBits(int value, int slopeBits) {
        return value & 0xFFE001FF | slopeBits << 9;
    }

    public static int getSideMask(int value) {
        return value >> 26 & 0x3F;
    }

    public static int setSideMask(int value, int sideMask) {
        return value & 0x3FFFFFF | sideMask << 26;
    }

    public static int getConnectMask(int value) {
        return value >> 22 & 0xF;
    }

    public static int setConnectMask(int value, int connectMask) {
        return value & 0xFC3FFFFF | connectMask << 22;
    }

    public static void calculateFluidSlopes(CellArray fluid, CellArray blocks) {
        FluidUtils.calculateFluidSlopes(fluid, blocks, 0, 0, 0, fluid.getSizeX(), fluid.getSizeY(), fluid.getSizeZ());
    }

    public static void calculateFluidSlopes(CellData fluid, CellData blocks, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (log.isTraceEnabled()) {
            log.trace("calculateFluidSlopes(" + xStart + ", " + yStart + ", " + zStart + ", " + xEnd + ", " + yEnd + ", " + zEnd + ")");
        }
        int[] neighbors = new int[8];
        FluidSlope slope = new FluidSlope();
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = yStart; y < yEnd; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    int dirConnect;
                    int dirValue;
                    int val = fluid.getCell(x, y, z);
                    int type = FluidUtils.getType(val);
                    if (type == 0) continue;
                    int sides = FluidUtils.getSideMask(val);
                    int connectMask = FluidUtils.getConnectMask(val);
                    int level = FluidUtils.calculateLevel(val);
                    if (log.isTraceEnabled()) {
                        log.trace("sides:" + Integer.toBinaryString(sides) + "  connect:" + Integer.toBinaryString(connectMask) + "  level:" + level);
                    }
                    if (level == 9) {
                        slope.nw = 8;
                        slope.ne = 8;
                        slope.se = 8;
                        slope.sw = 8;
                        if (log.isTraceEnabled()) {
                            log.trace("  capped nw:" + slope.nw + "   ne:" + slope.ne + "  se:" + slope.se + "   sw:" + slope.sw);
                        }
                        val = FluidUtils.setSlopeBits(val, slope.getBits());
                        fluid.setCell(x, y, z, val);
                        continue;
                    }
                    Arrays.fill(neighbors, -1);
                    if (DirectionMasks.hasNorth(connectMask)) {
                        dirValue = fluid.getCell(x, y, z, Direction.North, 0);
                        neighbors[1] = FluidUtils.calculateLevel(dirValue);
                        dirConnect = FluidUtils.getConnectMask(dirValue);
                        if (DirectionMasks.hasWest(dirConnect)) {
                            neighbors[0] = FluidUtils.calculateLevel(fluid.getCell(x - 1, y, z - 1, 0));
                        }
                        if (DirectionMasks.hasEast(dirConnect)) {
                            neighbors[2] = FluidUtils.calculateLevel(fluid.getCell(x + 1, y, z - 1, 0));
                        }
                    }
                    if (DirectionMasks.hasSouth(connectMask)) {
                        dirValue = fluid.getCell(x, y, z, Direction.South, 0);
                        neighbors[5] = FluidUtils.calculateLevel(dirValue);
                        dirConnect = FluidUtils.getConnectMask(dirValue);
                        if (DirectionMasks.hasWest(dirConnect)) {
                            neighbors[6] = FluidUtils.calculateLevel(fluid.getCell(x - 1, y, z + 1, 0));
                        }
                        if (DirectionMasks.hasEast(dirConnect)) {
                            neighbors[4] = FluidUtils.calculateLevel(fluid.getCell(x + 1, y, z + 1, 0));
                        }
                    }
                    if (DirectionMasks.hasEast(connectMask)) {
                        dirValue = fluid.getCell(x, y, z, Direction.East, 0);
                        neighbors[3] = FluidUtils.calculateLevel(dirValue);
                        dirConnect = FluidUtils.getConnectMask(dirValue);
                        if (DirectionMasks.hasNorth(dirConnect) && neighbors[2] == -1) {
                            neighbors[2] = FluidUtils.calculateLevel(fluid.getCell(x + 1, y, z - 1, 0));
                        }
                        if (DirectionMasks.hasSouth(dirConnect) && neighbors[4] == -1) {
                            neighbors[4] = FluidUtils.calculateLevel(fluid.getCell(x + 1, y, z + 1, 0));
                        }
                    }
                    if (DirectionMasks.hasWest(connectMask)) {
                        dirValue = fluid.getCell(x, y, z, Direction.West, 0);
                        neighbors[7] = FluidUtils.calculateLevel(dirValue);
                        dirConnect = FluidUtils.getConnectMask(dirValue);
                        if (DirectionMasks.hasNorth(dirConnect) && neighbors[0] == -1) {
                            neighbors[0] = FluidUtils.calculateLevel(fluid.getCell(x - 1, y, z - 1, 0));
                        }
                        if (DirectionMasks.hasSouth(dirConnect) && neighbors[6] == -1) {
                            neighbors[6] = FluidUtils.calculateLevel(fluid.getCell(x - 1, y, z + 1, 0));
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Neighbors:" + Arrays.toString(neighbors));
                    }
                    int nw = FluidUtils.calculateCorner(level, neighbors[0], neighbors[7], neighbors[1]);
                    int ne = FluidUtils.calculateCorner(level, neighbors[2], neighbors[3], neighbors[1]);
                    int se = FluidUtils.calculateCorner(level, neighbors[4], neighbors[3], neighbors[5]);
                    int sw = FluidUtils.calculateCorner(level, neighbors[6], neighbors[7], neighbors[5]);
                    if (log.isTraceEnabled()) {
                        log.trace("  offsets nw:" + nw + "   ne:" + ne + "  se:" + se + "   sw:" + sw);
                    }
                    slope.nw = nw;
                    slope.ne = ne;
                    slope.se = se;
                    slope.sw = sw;
                    val = FluidUtils.setSlopeBits(val, slope.getBits());
                    fluid.setCell(x, y, z, val);
                }
            }
        }
    }

    private static boolean isBlocked(int blockCell, Direction dir1, Direction dir2) {
        BlockType type = MaskUtils.getBlockType(blockCell);
        if (type == null) {
            return false;
        }
        if (type.isSolid(dir1)) {
            return true;
        }
        return type.isSolid(dir2);
    }

    private static boolean isBlocked(BlockType type, Direction dir) {
        if (type == null) {
            return false;
        }
        return type.isSolid(dir);
    }

    private static int calculateLevel(int fluidValue) {
        if (FluidUtils.getType(fluidValue) == 0) {
            return 0;
        }
        int level = FluidUtils.getRawLevel(fluidValue) + 1;
        if (level < 8) {
            return level;
        }
        int masks = FluidUtils.getSideMask(fluidValue);
        if (!DirectionMasks.hasUp(masks)) {
            return 9;
        }
        return 8;
    }

    private static int calculateCorner(int level, int ... neighbors) {
        if (log.isTraceEnabled()) {
            log.trace("calculateCorner(" + level + ", " + Arrays.toString(neighbors) + ")");
        }
        if (level == 9) {
            return 8;
        }
        int total = level;
        int count = 1;
        int min = 8;
        for (int i : neighbors) {
            if (i == 9) {
                return 8;
            }
            if (i < 0) continue;
            if (i < min) {
                min = i;
            }
            total += i;
            ++count;
        }
        if (log.isTraceEnabled()) {
            log.trace("  min:" + min + "  total:" + total + "  count:" + count + "  avg:" + (int)Math.round((double)total / (double)count));
        }
        if (min == 0) {
            return 1;
        }
        if (count == 1) {
            return level;
        }
        int avg = (int)Math.round((double)total / (double)count);
        return Math.max(1, avg);
    }

    public static void recalculateSideMasks(CellData fluid, CellData blocks, int x, int y, int z, int defaultBorder) {
        int minY = Math.max(0, y - 1);
        int maxY = y + 2;
        FluidUtils.calculateSideMasks(fluid, blocks, x - 1, minY, z - 1, x + 2, maxY, z + 2);
        FluidUtils.calculateFluidSlopes(fluid, blocks, x - 1, minY, z - 1, x + 2, maxY, z + 2);
    }

    private static void unfinishedRecalculateSideMasks(CellData fluid, CellData blocks, int x, int y, int z, int defaultBorder) {
        int val;
        if (log.isTraceEnabled()) {
            log.trace("recalculateSideMasks(" + x + ", " + y + ", " + z + ")");
        }
        if ((val = fluid.getCell(x, y, z, -1)) == -1) {
            throw new IllegalArgumentException("Recalculating masks for invalid cell location:" + x + ", " + y + ", " + z);
        }
        int sideMask = 0;
        int connectMask = 0;
        int type = FluidUtils.getType(val);
        if (type == 0) {
            sideMask = 0;
            connectMask = 0;
        } else {
            int level = FluidUtils.getLevel(val);
            if (log.isTraceEnabled()) {
                log.trace("[" + x + "][" + y + "][" + z + "] = " + type + "  level:" + level);
            }
            int blockValue = blocks.getCell(x, y, z);
            BlockType block = MaskUtils.getBlockType(blockValue);
            for (Direction dir : Direction.values()) {
                int nextVal = fluid.getCell(x, y, z, dir, 0);
                int next = FluidUtils.getType(nextVal);
                if (log.isTraceEnabled()) {
                    log.trace("  " + (Object)((Object)dir) + "  " + next);
                }
                BlockType neighbor = MaskUtils.getBlockType(blocks.getCell(x, y, z, dir, 0));
                boolean connected = FluidUtils.isConnected(level, block, neighbor, dir);
                if (log.isTraceEnabled()) {
                    log.trace("   dir:" + (Object)((Object)dir) + "  connected:" + connected);
                }
                if (connected) {
                    if (next != type || dir == Direction.Up && level < 8 || dir == Direction.Down && FluidUtils.getLevel(nextVal) < 8) {
                        sideMask |= dir.getBitMask();
                    }
                    if (!dir.isCardinal()) continue;
                    connectMask |= dir.getBitMask();
                    continue;
                }
                if (block != null && block.getTransparency(dir) <= 0.0 || neighbor != null && neighbor.getTransparency(dir) <= 0.0) continue;
                sideMask |= dir.getBitMask();
            }
        }
        int newVal = FluidUtils.setSideMask(val, sideMask);
        newVal = FluidUtils.setConnectMask(newVal, connectMask);
        fluid.setCell(x, y, z, newVal);
    }

    public static void calculateSideMasks(CellArray fluid, CellArray blocks) {
        FluidUtils.calculateSideMasks(fluid, blocks, fluid.getSizeX(), fluid.getSizeY(), fluid.getSizeZ());
    }

    public static void calculateSideMasks(CellData fluid, CellData blocks, int size) {
        FluidUtils.calculateSideMasks(fluid, blocks, size, size, size);
    }

    public static int calculateSideMasks(CellData fluid, CellData blocks, int xSize, int ySize, int zSize) {
        return FluidUtils.calculateSideMasks(fluid, blocks, 0, 0, 0, xSize, ySize, zSize);
    }

    public static int calculateSideMasks(CellData fluid, CellData blocks, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        int sideCount = 0;
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = yStart; y < yEnd; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    int val = fluid.getCell(x, y, z);
                    int type = FluidUtils.getType(val);
                    if (type == 0) {
                        int newVal = FluidUtils.setSideMask(val, 0);
                        newVal = FluidUtils.setConnectMask(newVal, 0);
                        fluid.setCell(x, y, z, newVal);
                        continue;
                    }
                    int level = FluidUtils.getLevel(val);
                    if (log.isTraceEnabled()) {
                        log.trace("[" + x + "][" + y + "][" + z + "] = " + type + "  level:" + level);
                    }
                    int sideMask = 0;
                    int connectMask = 0;
                    int blockValue = blocks.getCell(x, y, z);
                    BlockType block = MaskUtils.getBlockType(blockValue);
                    for (Direction dir : Direction.values()) {
                        int nextVal = fluid.getCell(x, y, z, dir, 0);
                        int next = FluidUtils.getType(nextVal);
                        if (log.isTraceEnabled()) {
                            log.trace("  " + (Object)((Object)dir) + "  " + next);
                        }
                        BlockType neighbor = MaskUtils.getBlockType(blocks.getCell(x, y, z, dir, 0));
                        boolean connected = FluidUtils.isConnected(level, block, neighbor, dir);
                        if (log.isTraceEnabled()) {
                            log.trace("   dir:" + (Object)((Object)dir) + "  connected:" + connected);
                        }
                        if (connected) {
                            if (next != type || dir == Direction.Up && level < 8 || dir == Direction.Down && FluidUtils.getLevel(nextVal) < 8) {
                                sideMask |= dir.getBitMask();
                                ++sideCount;
                            }
                            if (!dir.isCardinal()) continue;
                            connectMask |= dir.getBitMask();
                            continue;
                        }
                        if (block != null && block.getTransparency(dir) <= 0.0 || neighbor != null && neighbor.getTransparency(dir) <= 0.0) continue;
                        sideMask |= dir.getBitMask();
                        ++sideCount;
                    }
                    int newVal = FluidUtils.setSideMask(val, sideMask);
                    newVal = FluidUtils.setConnectMask(newVal, connectMask);
                    fluid.setCell(x, y, z, newVal);
                }
            }
        }
        return sideCount;
    }

    public static boolean isConnected(int fluidLevel, BlockType local, BlockType neighbor, Direction dir) {
        if (log.isTraceEnabled()) {
            log.trace("isConnected(" + fluidLevel + ", " + (local == null ? "null" : local.getName().toString()) + ", " + (neighbor == null ? "null" : neighbor.getName().toString()) + ", " + (Object)((Object)dir) + ")");
        }
        if (fluidLevel <= 0) {
            return false;
        }
        if (local == null && neighbor == null) {
            return true;
        }
        if (local != null && local.isSolid(dir)) {
            return false;
        }
        Direction rev = dir.reverse();
        return neighbor == null || !neighbor.isSolid(rev);
    }
}

