/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;

public class GeomUtils {
    public static int rotateIndex(int index, int dirDelta) {
        Direction dir = Direction.values()[index];
        dir = dir.rotate(dirDelta);
        return dir.ordinal();
    }

    public static Vec3d rotatePos(Vec3d v, int dirDelta) {
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        v = v.subtract(0.5, 0.5, 0.5);
        v = Direction.getRotation(dirDelta).mult(v, v);
        return v.addLocal(0.5, 0.5, 0.5);
    }

    public static Vec3d rotateDir(Vec3d v, int dirDelta) {
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        return Direction.getRotation(dirDelta).mult(v);
    }

    public static float[] rotatePos(float[] vecs, int dirDelta) {
        if (vecs == null) {
            return null;
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        float[] result = new float[vecs.length];
        for (int i = 0; i < vecs.length; i += 3) {
            v.set((double)vecs[i], (double)vecs[i + 1], (double)vecs[i + 2]);
            v = v.subtractLocal(0.5, 0.5, 0.5);
            v = Direction.getRotation(dirDelta).mult(v, v);
            v.addLocal(0.5, 0.5, 0.5);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.y, 1000.0);
            result[i + 2] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float[] rotateDir(float[] vecs, int dirDelta) {
        if (vecs == null) {
            return null;
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        float[] result = new float[vecs.length];
        for (int i = 0; i < vecs.length; i += 3) {
            v.set((double)vecs[i], (double)vecs[i + 1], (double)vecs[i + 2]);
            v = Direction.getRotation(dirDelta).mult(v, v);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.y, 1000.0);
            result[i + 2] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float[] rotateUvs(float[] texes, int vertCount, Direction dir, int dirDelta) {
        if (texes == null) {
            return null;
        }
        float[] result = (float[])texes.clone();
        if (dirDelta == 0 || vertCount == 0) {
            return result;
        }
        switch (dir) {
            case North: 
            case South: 
            case East: 
            case West: {
                return result;
            }
            case Down: {
                dirDelta = -dirDelta;
            }
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        int step = texes.length / vertCount;
        for (int i = 0; i < texes.length; i += step) {
            v.set((double)texes[i] - 0.5, 0.0, (double)texes[i + 1] - 0.5);
            v = Direction.getRotation(dirDelta).mult(v, v);
            v.addLocal(0.5, 0.0, 0.5);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float round(float f, float scale) {
        return (float)Math.round(f * scale) / scale;
    }

    public static float round(double d, double scale) {
        return (float)((double)Math.round(d * scale) / scale);
    }
}

