/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(MaterialType.class);
    static final long serialVersionUID = 42L;
    private static Map<String, MaterialType> intern = new HashMap<String, MaterialType>();
    private String name;
    private EnumSet<GeomReq> geomReqs = EnumSet.noneOf(GeomReq.class);
    private transient EnumSet<GeomReq> impliedReqs = null;
    private transient String id;

    public MaterialType(String name, boolean needsIndexedNormals, boolean needsNormals, boolean needsTangents) {
        this.name = name;
        if (needsIndexedNormals) {
            this.geomReqs.add(GeomReq.IndexedNormals);
        } else {
            if (needsNormals) {
                this.geomReqs.add(GeomReq.Normals);
            }
            if (needsTangents) {
                this.geomReqs.add(GeomReq.Tangents);
            }
        }
        this.cacheReqs();
    }

    public MaterialType(String name, GeomReq ... reqs) {
        this(name, Arrays.asList(reqs));
    }

    public MaterialType(String name, Collection<GeomReq> reqs) {
        this.name = name;
        this.geomReqs.addAll(reqs);
        this.cacheReqs();
    }

    public synchronized MaterialType internalize() {
        MaterialType result = intern.get(this.getId());
        if (result == null) {
            intern.put(this.getId(), this);
            result = this;
        }
        return result;
    }

    public String getId() {
        if (this.id == null) {
            this.cacheReqs();
            this.id = this.toString();
        }
        return this.id;
    }

    public EnumSet<GeomReq> getImpliedReqs() {
        if (this.impliedReqs == null) {
            this.impliedReqs = GeomReq.expandImplied(this.geomReqs);
        }
        return this.impliedReqs;
    }

    protected void cacheReqs() {
        this.getImpliedReqs();
        if (this.geomReqs.contains((Object)GeomReq.IndexedNormals)) {
            for (GeomReq req : GeomReq.IndexedNormals.implies()) {
                this.geomReqs.remove((Object)req);
            }
        }
        for (GeomReq req : this.geomReqs) {
            for (GeomReq imp : req.implies()) {
                this.geomReqs.remove((Object)imp);
            }
        }
    }

    public Set<GeomReq> getGeomReqs() {
        return Collections.unmodifiableSet(this.geomReqs);
    }

    public boolean requires(GeomReq req) {
        return this.getImpliedReqs().contains((Object)req);
    }

    public boolean assertValid(GeomPart part) {
        if (this.geomReqs.contains((Object)GeomReq.IndexedNormals)) assert (part.hasIndexedNormals()) : "Missing indexed normals, mt:" + this + " part:" + part;
        if (this.geomReqs.contains((Object)GeomReq.Tangents)) {
            assert (part.getNormals() != null) : "Missing normals, mt:" + this + " part:" + part;
            assert (part.getTangents() != null) : "Missing tangents, mt:" + this + " part:" + part;
        } else if (this.geomReqs.contains((Object)GeomReq.Normals)) assert (part.getNormals() != null) : "Missing normals, mt:" + this + " part:" + part;
        return true;
    }

    public EnumSet<GeomReq> getMissingReqs(GeomPart part) {
        EnumSet<GeomReq> caps = part.calculateGeomCaps();
        Object result = this.getImpliedReqs().clone();
        ((AbstractSet)result).removeAll(caps);
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean needsIndexedNormals() {
        return this.requires(GeomReq.IndexedNormals);
    }

    public boolean needsNormals() {
        return this.requires(GeomReq.Normals);
    }

    public boolean needsTangents() {
        return this.requires(GeomReq.Tangents);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MaterialType other = (MaterialType)o;
        return Objects.equals(other.getId(), this.getId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("geomReqs", this.geomReqs).toString();
    }
}

