/*
 * Decompiled with CFR 0.152.
 */
package mythruna.cmd;

import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import mythruna.cmd.Command;
import mythruna.cmd.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSystem<S, T>
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(CommandSystem.class);
    private Thread gameThread;
    private Map<String, Command<S, T>> commands = new HashMap<String, Command<S, T>>();

    public void registerCommand(String name, Command<S, T> cmd, Class ... argTypes) {
        this.commands.put(name, cmd);
    }

    public Set<String> getCommandNames() {
        return this.commands.keySet();
    }

    public void execute(Context<S> context, String cmd, T subject, Object ... args) {
        if (this.gameThread != Thread.currentThread()) {
            this.executeLater(context, cmd, subject, args);
            return;
        }
        this.executeNow(context, cmd, subject, args);
    }

    public void executeLater(Context<S> context, String cmd, T subject, Object ... args) {
        Callable<Void> callable = () -> {
            this.executeNow(context, cmd, subject, args);
            return null;
        };
        this.getManager().enqueue(callable);
    }

    protected void executeNow(Context<S> context, String cmd, T subject, Object ... args) {
        Command<S, T> command = this.commands.get(cmd);
        command.execute(context, cmd, subject, args);
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    public void start() {
        this.gameThread = Thread.currentThread();
    }

    public void update(SimTime time) {
    }

    public void stop() {
    }
}

