/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.net.AccountListener;
import mythruna.net.AccountSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClientService
extends AbstractClientService
implements AccountSession {
    static Logger log = LoggerFactory.getLogger(AccountClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private AccountSession delegate;
    private AccountSessionCallback sessionCallback = new AccountSessionCallback();
    private List<AccountListener> listeners = new CopyOnWriteArrayList<AccountListener>();

    public AccountClientService() {
        this(-2);
    }

    public AccountClientService(int channel) {
        this.channel = channel;
    }

    @Override
    public void knock() {
        this.getDelegate().knock();
    }

    @Override
    public void login(String userId, String credentials) {
        this.getDelegate().login(userId, credentials);
    }

    @Override
    public EntityId getUserEntity() {
        return this.getDelegate().getUserEntity();
    }

    @Override
    public void createCharacter(String name, EntityComponent ... components) {
        this.getDelegate().createCharacter(name, components);
    }

    @Override
    public void enterWorld(EntityId character) {
        this.getDelegate().enterWorld(character);
    }

    public void addAccountListener(AccountListener l) {
        this.listeners.add(l);
    }

    public void removeAccountListener(AccountListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("ChatClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, AccountListener.class);
    }

    public void start() {
        log.debug("start()");
        super.start();
        this.getDelegate().knock();
    }

    private AccountSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (AccountSession)this.rmiService.getRemoteObject(AccountSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No chat session found");
            }
        }
        return this.delegate;
    }

    private class AccountSessionCallback
    implements AccountListener {
        private AccountSessionCallback() {
        }

        @Override
        public void challenge(Set<String> caps) {
            if (log.isTraceEnabled()) {
                log.trace("challenge(" + caps + ")");
            }
            for (AccountListener l : AccountClientService.this.listeners) {
                l.challenge(caps);
            }
        }

        @Override
        public void loginStatus(boolean loggedIn, String message) {
            if (log.isTraceEnabled()) {
                log.trace("loginStatus(" + loggedIn + ", " + message + ")");
            }
            for (AccountListener l : AccountClientService.this.listeners) {
                l.loginStatus(loggedIn, message);
            }
        }
    }
}

