/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.es.EntityId;
import com.simsilica.es.StringIndex;
import com.simsilica.es.client.EntityDataClientService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.es.ActivationInput;
import mythruna.es.MovementInput;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionClientService
extends AbstractClientService
implements GameSession {
    static Logger log = LoggerFactory.getLogger(GameSessionClientService.class);
    private RmiClientService rmiService;
    private GameSession delegate;
    private GameSessionCallback sessionCallback = new GameSessionCallback();
    private List<GameSessionListener> listeners = new CopyOnWriteArrayList<GameSessionListener>();
    private StringIndex strings;

    @Override
    public EntityId getCharacter() {
        return this.getDelegate().getCharacter();
    }

    @Override
    public EntityId getAvatar() {
        return this.getDelegate().getAvatar();
    }

    @Override
    public void setMovementInput(MovementInput input) {
        this.getDelegate().setMovementInput(input);
    }

    @Override
    public void setActivationInput(ActivationInput input) {
        this.getDelegate().setActivationInput(input);
    }

    @Override
    public void executeShell(String cmd) {
        this.getDelegate().executeShell(cmd);
    }

    @Override
    public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
        this.getDelegate().executeCommand(cmdId, subject, parms);
    }

    @Override
    public void executeCommand(String cmd, EntityId subject, Object ... parms) {
        int id = this.strings.getStringId(cmd, false);
        if (id < 0) {
            throw new IllegalArgumentException("No command defined:" + cmd);
        }
        this.executeCommand(id, subject, parms);
    }

    private GameSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (GameSession)this.rmiService.getRemoteObject(GameSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No game session found");
            }
        }
        return this.delegate;
    }

    public void addGameSessionListener(GameSessionListener l) {
        this.listeners.add(l);
    }

    public void removeGameSessionListener(GameSessionListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionClientService requires RMI service");
        }
        log.info("Sharing session callback.");
        this.rmiService.share((Object)this.sessionCallback, GameSessionListener.class);
        this.strings = ((EntityDataClientService)this.getService(EntityDataClientService.class)).getEntityData().getStrings();
    }

    public void start() {
        log.debug("start()");
        super.start();
    }

    private class GameSessionCallback
    implements GameSessionListener {
        private GameSessionCallback() {
        }

        @Override
        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.setAvatar(avatar);
            }
        }

        @Override
        public void newConsoleMessage(String msg) {
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.newConsoleMessage(msg);
            }
        }
    }
}

