/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.google.common.base.Supplier;
import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mythruna.net.AccountListener;
import mythruna.net.AccountSession;
import mythruna.net.server.GameSessionHostedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(AccountHostedService.class);
    private static final String ATTRIBUTE_SESSION = AccountHostedService.class.getName();
    private RmiHostedService rmiService;
    private int channel;
    private EntityData ed;
    private Supplier<String> tokenSupplier;

    public AccountHostedService(EntityData ed, Supplier<String> tokenSupplier) {
        this(ed, tokenSupplier, -2);
    }

    public AccountHostedService(EntityData ed, Supplier<String> tokenSupplier, int channel) {
        this.ed = ed;
        this.channel = channel;
        this.tokenSupplier = tokenSupplier;
    }

    protected AccountSessionImpl getSession(HostedConnection conn) {
        return (AccountSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " requires an RMI service.");
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        log.debug("startHostingOnConnection(" + conn + ")");
        AccountSessionImpl session = new AccountSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((byte)this.channel, (Object)session, AccountSession.class);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        AccountSessionImpl session = this.getSession(conn);
        if (session != null) {
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    private class AccountSessionImpl
    implements AccountSession,
    AccountListener {
        private HostedConnection conn;
        private AccountListener callback;
        private EntityId userEntity;
        private boolean loggedIn;

        public AccountSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        protected AccountListener getCallback() {
            if (this.callback == null) {
                RmiRegistry rmi = AccountHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (AccountListener)rmi.getRemoteObject(AccountListener.class);
                if (this.callback == null) {
                    throw new RuntimeException("Unable to locate client callback for AccountListener");
                }
            }
            return this.callback;
        }

        protected void checkLoggedIn() {
            if (!this.loggedIn) {
                throw new RuntimeException("Permission denied");
            }
        }

        @Override
        public void knock() {
            if (AccountHostedService.this.tokenSupplier != null) {
                this.challenge(new HashSet<String>(Arrays.asList("token", "sha256")));
            } else {
                this.challenge(new HashSet<String>(Arrays.asList("sha256")));
            }
        }

        @Override
        public void login(String userId, String credentials) {
            log.info("login(" + userId + ", " + credentials + ")");
            if (AccountHostedService.this.tokenSupplier == null) {
                this.loginStatus(false, "Token login not supported");
                return;
            }
            if (!Objects.equals(credentials, AccountHostedService.this.tokenSupplier.get())) {
                this.loginStatus(false, "Invalid user or credentials");
                return;
            }
            this.userEntity = AccountHostedService.this.ed.findEntity(Filters.fieldEquals(Name.class, (String)"name", (Object)userId), new Class[]{Name.class});
            if (this.userEntity == null) {
                this.loginStatus(false, "Invalid user or credentials");
                return;
            }
            log.info("Logged in userId:" + userId + "  entity:" + this.userEntity);
            this.loginStatus(true, null);
        }

        @Override
        public EntityId getUserEntity() {
            this.checkLoggedIn();
            return this.userEntity;
        }

        @Override
        public void createCharacter(String name, EntityComponent ... components) {
            if (!this.loggedIn) {
                return;
            }
            EntityId character = AccountHostedService.this.ed.createEntity();
            AccountHostedService.this.ed.setComponents(character, components);
            AccountHostedService.this.ed.setComponents(character, new EntityComponent[]{new Name(name), new CreatedBy(this.userEntity)});
        }

        @Override
        public void enterWorld(EntityId character) {
            this.checkLoggedIn();
            log.info("enterWorld(" + character + ")");
            CreatedBy creator = (CreatedBy)AccountHostedService.this.ed.getComponent(character, CreatedBy.class);
            if (creator == null) {
                throw new RuntimeException("Invalid character:" + character);
            }
            log.info("  owner:" + creator);
            if (!Objects.equals(this.userEntity, creator.getCreatorId())) {
                throw new RuntimeException("Invalid character:" + character + " for player:" + this.userEntity);
            }
            ((GameSessionHostedService)AccountHostedService.this.getService(GameSessionHostedService.class)).startHostingOnConnection(this.conn, character);
        }

        @Override
        public void challenge(Set<String> caps) {
            this.getCallback().challenge(caps);
        }

        @Override
        public void loginStatus(boolean loggedIn, String message) {
            this.loggedIn = loggedIn;
            this.getCallback().loginStatus(loggedIn, message);
        }
    }
}

