/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.net.BodyVisibility;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameSystemManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.GameConstants;
import mythruna.cmd.Command;
import mythruna.cmd.CommandSystem;
import mythruna.cmd.Context;
import mythruna.es.ActivationInput;
import mythruna.es.MovementInput;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellService;
import mythruna.sim.PathRecorderSystem;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(GameSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = GameSessionHostedService.class.getName();
    private GameSystemManager gameSystems;
    private EntityData ed;
    private CommandSystem<GameSessionImpl, EntityId> cmdProc;
    private RmiHostedService rmiService;
    private List<GameSessionImpl> players = new CopyOnWriteArrayList<GameSessionImpl>();

    public GameSessionHostedService(GameSystemManager gameSystems) {
        this.gameSystems = gameSystems;
        this.setAutoHost(false);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionHostedService requires an RMI service.");
        }
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
    }

    public void start() {
        super.start();
        EntityDataHostedService eds = (EntityDataHostedService)this.getService(EntityDataHostedService.class);
        if (eds == null) {
            throw new RuntimeException("AccountHostedService requires an EntityDataHostedService");
        }
        this.ed = eds.getEntityData();
        this.cmdProc = (CommandSystem)((Object)this.gameSystems.get(CommandSystem.class));
        this.cmdProc.registerCommand("record", new RecordCommand(), new Class[0]);
        this.cmdProc.registerCommand("play", new PlayCommand(), new Class[0]);
        this.cmdProc.registerCommand("stop", new StopCommand(), new Class[0]);
        this.cmdProc.registerCommand("selectType", new SelectTypeCommand(), new Class[0]);
        ActivateCommand activate = new ActivateCommand();
        this.cmdProc.registerCommand("activatePrimary", activate, new Class[0]);
        this.cmdProc.registerCommand("activatePrimaryAlt", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondary", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondaryAlt", activate, new Class[0]);
        for (String s : this.cmdProc.getCommandNames()) {
            this.ed.getStrings().getStringId(s, true);
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void startHostingOnConnection(HostedConnection conn, EntityId character) {
        log.debug("startHostingOnConnection(" + conn + ", " + character + ")");
        GameSessionImpl session = new GameSessionImpl(conn, character);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)session, GameSession.class);
        this.players.add(session);
        session.initialize();
        ((ChatHostedService)this.getService(ChatHostedService.class)).startHostingOnConnection(conn, session.getPlayerName());
    }

    protected GameSessionImpl getGameSession(HostedConnection conn) {
        return (GameSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        GameSessionImpl session = this.getGameSession(conn);
        if (session != null) {
            session.close();
            this.players.remove(session);
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    private class ActivatorImpl {
        private EntityId entity;
        private BodyPosition bPos;
        private MBlockCollisionSystem collisionSystem;

        public ActivatorImpl(EntityId entity) {
            this.entity = entity;
            this.collisionSystem = (MBlockCollisionSystem)((MPhysSystem)GameSessionHostedService.this.gameSystems.get(MPhysSystem.class, true)).getCollisionSystem();
        }

        public EntityId getId() {
            return this.entity;
        }

        private BodyPosition getBodyPosition() {
            if (this.bPos == null) {
                this.bPos = this.getAt(BodyPosition.class);
            }
            return this.bPos;
        }

        public Vec3d getEyePos() {
            Vec3d pos = this.getPos();
            return pos.add(0.0, 1.5, 0.0);
        }

        public Vec3d getPos() {
            return this.getBodyPosition().getLastLocation();
        }

        public Vec3d getLookDir() {
            return this.getLookOrientation().mult(Vec3d.UNIT_Z);
        }

        public Vec3d getDir() {
            return this.getOrientation().mult(Vec3d.UNIT_Z);
        }

        public Quatd getLookOrientation() {
            MovementInput mi = this.getAt(MovementInput.class);
            if (mi == null) {
                return null;
            }
            return mi.getFacing();
        }

        public Quatd getOrientation() {
            return this.getBodyPosition().getLastOrientation();
        }

        public Iterator<BlockIterator.Intersection> pick() {
            Rayd ray = new Rayd(this.getEyePos(), this.getLookDir());
            return this.collisionSystem.rayIterator(ray, 10.0);
        }

        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(GameSessionHostedService.this.ed.getComponent(this.entity, type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }
    }

    private class StopCommand
    implements Command<GameSessionImpl, EntityId> {
        private StopCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                long duration = ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).stop(subject);
                context.getSource().echo(String.format("%.02f", (double)duration / 1.0E9));
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class PlayCommand
    implements Command<GameSessionImpl, EntityId> {
        private PlayCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).play(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class RecordCommand
    implements Command<GameSessionImpl, EntityId> {
        private RecordCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).record(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class ActivateCommand
    implements Command<GameSessionImpl, EntityId> {
        private ActivateCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info(this.getClass().getSimpleName() + "(" + cmd + ", " + Arrays.asList(parms) + ")");
            log.info("parms[0] class:" + parms[0].getClass());
            if (!Boolean.TRUE.equals(parms[0])) {
                return;
            }
            if ("activatePrimary".equals(cmd)) {
                Iterator<BlockIterator.Intersection> it = context.getSource().activator.pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    ((World)GameSessionHostedService.this.gameSystems.get(World.class)).setWorldCell(intersect.getBlock().toVec3d(), 0);
                }
            } else if ("activatePrimaryAlt".equals(cmd)) {
                Iterator<BlockIterator.Intersection> it;
                Integer selected = (Integer)context.getSource().vars.get("selectedType");
                if (selected == null) {
                    selected = 1;
                }
                if ((it = context.getSource().activator.pick()).hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    Vec3d pos = intersect.getBlock().toVec3d();
                    pos.addLocal(intersect.getNormal());
                    ((World)GameSessionHostedService.this.gameSystems.get(World.class)).setWorldCell(pos, selected.intValue());
                }
            } else if ("activateSecondary".equals(cmd)) {
                Iterator<BlockIterator.Intersection> it = context.getSource().activator.pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    DefaultWorld world = (DefaultWorld)GameSessionHostedService.this.gameSystems.get(World.class);
                    ColumnId colId = ColumnId.fromWorld((Vec3d)intersect.getPoint());
                    long start = System.nanoTime();
                    world.recalculateLighting(colId);
                    long end = System.nanoTime();
                    context.getSource().echo(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
                    Vec3d point = intersect.getPoint();
                    int existing = world.getWorldCell(point);
                    world.setWorldCell(point, 1);
                    world.setWorldCell(point, existing);
                }
            } else {
                context.getSource().echo("Unknown command:" + cmd);
            }
        }
    }

    private class SelectTypeCommand
    implements Command<GameSessionImpl, EntityId> {
        private SelectTypeCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info("selectType(" + cmd + ", " + Arrays.asList(parms) + ")");
            context.getSource().vars.put("selectedType", parms[0]);
        }
    }

    private class GameSessionImpl
    implements GameSession {
        private HostedConnection conn;
        private GameSessionListener callback;
        private EntityId characterEntity;
        private EntityId avatarEntity;
        private CommandShell shell;
        private Vec3d spawnLoc;
        private Quatd spawnRot;
        private Context<GameSessionImpl> commandContext;
        private Map<String, Object> vars = new HashMap<String, Object>();
        private ActivatorImpl activator;

        public GameSessionImpl(HostedConnection conn, EntityId characterEntity) {
            this.conn = conn;
            this.characterEntity = characterEntity;
            this.avatarEntity = characterEntity;
            this.shell = ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).createChildShell(this.avatarEntity);
            this.shell.setVariables(this.vars);
            this.shell.setOutput(line -> this.callback.newConsoleMessage((String)line));
            this.shell.put("avatar", this.avatarEntity);
            this.commandContext = new Context<GameSessionImpl>(this);
            this.activator = new ActivatorImpl(this.avatarEntity);
            WorldManager world = (WorldManager)GameSessionHostedService.this.gameSystems.get(WorldManager.class, true);
            SpawnPosition pos = (SpawnPosition)GameSessionHostedService.this.ed.getComponent(characterEntity, SpawnPosition.class);
            if (pos == null) {
                log.info("Player has no previous spawn position, getting it from the world...");
                this.spawnLoc = world.getInfo().getSpawnPoint();
                log.info("spawnLoc:" + this.spawnLoc);
                this.spawnLoc.y += 20.0;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, new Quatd());
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            this.spawnLoc = pos.getLocation();
            this.spawnRot = pos.getOrientation();
            if (Math.floor(this.spawnLoc.x) == this.spawnLoc.x && Math.floor(this.spawnLoc.z) == this.spawnLoc.z) {
                log.info("Adjusting spawn loc to block center");
                this.spawnLoc.x += 0.5;
                this.spawnLoc.z += 0.5;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
            GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            int elevation = world.getElevation((int)this.spawnLoc.x, (int)this.spawnLoc.z);
            log.info("spawn loc:" + this.spawnLoc + "  real elevation:" + elevation);
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{new Mass(60.0), ShapeInfo.create((String)"sphere", (double)0.2, (EntityData)GameSessionHostedService.this.ed)});
        }

        public String getPlayerName() {
            Name name = (Name)GameSessionHostedService.this.ed.getComponent(this.characterEntity, Name.class);
            return name.getName();
        }

        public void initialize() {
            log.info("GameSessionImpl.initialize()");
            if (this.getCallback(false) != null) {
                this.getCallback(true).setAvatar(this.avatarEntity);
            } else {
                log.warn("No game session callback registered so can't send avatar entity.");
            }
            log.info("Spawning user at:" + this.spawnLoc);
            EtherealHost ethereal = (EtherealHost)GameSessionHostedService.this.getService(EtherealHost.class);
            ethereal.startHostingOnConnection(this.conn);
            ethereal.setConnectionObject(this.conn, Long.valueOf(this.characterEntity.getId()), this.spawnLoc);
            EntityDataHostedService eds = (EntityDataHostedService)GameSessionHostedService.this.getService(EntityDataHostedService.class);
            HostedEntityData hed = eds.getHostedEntityData(this.conn);
            if (hed == null) {
                throw new RuntimeException("Can't get hosted entity data for:" + this.conn);
            }
            hed.registerComponentVisibility((ComponentVisibility)new BodyVisibility(ethereal.getStateListener(this.conn)));
            log.info("GameSessionImpl.initialized()");
        }

        public void close() {
            log.debug("Closing game session for:" + this.conn);
            ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).removeShell(this.avatarEntity);
        }

        @Override
        public EntityId getCharacter() {
            return this.characterEntity;
        }

        @Override
        public EntityId getAvatar() {
            return this.avatarEntity;
        }

        @Override
        public void setMovementInput(MovementInput input) {
            GameSessionHostedService.this.ed.setComponent(this.avatarEntity, (EntityComponent)input);
        }

        @Override
        public void setActivationInput(ActivationInput input) {
            GameSessionHostedService.this.ed.setComponent(this.avatarEntity, (EntityComponent)input);
        }

        @Override
        public void executeShell(String cmd) {
            this.shell.execute(cmd);
        }

        @Override
        public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(cmdId);
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        @Override
        public void executeCommand(String cmd, EntityId subject, Object ... parms) {
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        protected void echo(String val) {
            this.shell.getOutput().accept(val);
        }

        protected GameSessionListener getCallback(boolean failFast) {
            if (this.callback == null) {
                RmiRegistry rmi = GameSessionHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (GameSessionListener)rmi.getRemoteObject(GameSessionListener.class);
                if (this.callback == null) {
                    if (failFast) {
                        throw new RuntimeException("Unable to locate client callback for GameSessionListener");
                    }
                    log.warn("Unable to locate client callback for GameSessionListener");
                }
            }
            return this.callback;
        }
    }
}

