/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.World;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import mythruna.es.ActivationInput;
import mythruna.es.MovementInput;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellService;
import mythruna.sim.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(ActivationSystem.class);
    private EntityData ed;
    private World world;
    private MPhysSystem mphys;
    private MBlockCollisionSystem collisionSystem;
    private Activators activators;
    private ScriptEngine scriptEngine;
    private Bindings globalBindings;

    public ActivationSystem() {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.scriptEngine = factory.getEngineByName("groovy");
        if (this.scriptEngine == null) {
            log.error("No groovy script engine found");
        }
        this.globalBindings = this.scriptEngine.createBindings();
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.world = (World)this.getSystem(World.class, true);
        this.mphys = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.collisionSystem = (MBlockCollisionSystem)this.mphys.getCollisionSystem();
        this.globalBindings.put("systems", (Object)this.getManager());
        this.globalBindings.put("activationSystem", (Object)this);
        this.globalBindings.put("ed", (Object)this.ed);
        this.globalBindings.put("world", (Object)this.world);
        this.globalBindings.put("physics", (Object)this.mphys);
        this.globalBindings.put("collisionSystem", (Object)this.collisionSystem);
        this.globalBindings.put("globals", (Object)this.globalBindings);
    }

    protected void terminate() {
    }

    public void start() {
        this.activators = new Activators(this.ed);
        this.activators.start();
    }

    public void update(SimTime time) {
        this.activators.update();
    }

    public void stop() {
        this.activators.stop();
        this.activators = null;
    }

    protected void activatePrimary(Activator activator, boolean activate) {
        log.info("a:" + activator + "  primary:" + activate);
        if (activate) {
            this.executeScript(activator, "activatePrimary.groovy", new Object[0]);
        }
    }

    protected void activatePrimaryAlt(Activator activator, boolean activate) {
        log.info("a:" + activator + "  primaryAlt:" + activate);
        if (activate) {
            this.executeScript(activator, "activatePrimaryAlt.groovy", new Object[0]);
        }
    }

    protected void activateSecondary(Activator activator, boolean activate) {
        log.info("a:" + activator + "  secondary:" + activate);
        if (activate) {
            this.executeScript(activator, "activateSecondary.groovy", new Object[0]);
        }
    }

    protected void activateSecondaryAlt(Activator activator, boolean activate) {
        log.info("a:" + activator + "  secondaryAlt:" + activate);
        if (activate) {
            this.executeScript(activator, "activateSecondaryAlt.groovy", new Object[0]);
        }
    }

    protected void changePrimarySelector(Activator activator, int delta) {
        this.executeScript(activator, "changePrimarySelector.groovy", delta);
    }

    protected void changeSecondarySelector(Activator activator, int delta) {
        this.executeScript(activator, "changeSecondarySelector.groovy", delta);
    }

    protected void executeScript(Activator activator, String scriptName, Object ... args) {
        this.executeScript(activator, new File("scripts/" + scriptName), args);
    }

    protected void executeScript(Activator activator, File script, Object ... args) {
        if (!script.exists()) {
            return;
        }
        try {
            String contents = Files.toString((File)script, (Charset)Charsets.UTF_8);
            Bindings bindings = this.scriptEngine.createBindings();
            bindings.putAll(this.globalBindings);
            bindings.put("log", (Object)LoggerFactory.getLogger((String)Files.getNameWithoutExtension((String)script.getName())));
            bindings.put("actor", (Object)activator);
            bindings.put("args", (Object)args);
            SimpleScriptContext context = new SimpleScriptContext();
            context.setBindings(bindings, 100);
            CommandShell shell = ((ShellService)this.getSystem(ShellService.class)).getShell(activator.getId());
            if (shell == null) {
                log.warn("Activator:" + activator + " has no shell");
            } else {
                context.setWriter(shell.getWriter());
            }
            log.info("Test:" + this.scriptEngine.eval("\"Eval test:$log\"", (ScriptContext)context));
            this.scriptEngine.eval(contents, (ScriptContext)context);
        }
        catch (Exception e) {
            log.error("Error evaluating:" + script, (Throwable)e);
        }
    }

    private class Activators
    extends EntityContainer<ActivatorWrapper> {
        public Activators(EntityData ed) {
            super(ed, new Class[]{ActivationInput.class});
        }

        public ActivatorWrapper[] getArray() {
            return (ActivatorWrapper[])super.getArray();
        }

        protected ActivatorWrapper addObject(Entity e) {
            log.info("addObject(" + e + ")");
            ActivatorWrapper result = new ActivatorWrapper(e);
            this.updateObject(result, e);
            return result;
        }

        protected void updateObject(ActivatorWrapper object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            object.update(e);
        }

        protected void removeObject(ActivatorWrapper object, Entity e) {
            log.info("removeObject(" + e + ")");
            object.release();
        }
    }

    private class ActivatorWrapper {
        private Entity entity;
        private Activator activator;
        private ActivationInput lastInput = new ActivationInput(0, 0, 0);

        public ActivatorWrapper(Entity entity) {
            this.entity = entity;
            this.activator = new ActivatorImpl(entity);
        }

        public void update(Entity entity) {
            ActivationInput input = (ActivationInput)entity.get(ActivationInput.class);
            log.info("update():" + input);
            if (this.lastInput.isPrimary() != input.isPrimary()) {
                ActivationSystem.this.activatePrimary(this.activator, input.isPrimary());
            }
            if (this.lastInput.isPrimaryAlt() != input.isPrimaryAlt()) {
                ActivationSystem.this.activatePrimaryAlt(this.activator, input.isPrimaryAlt());
            }
            if (this.lastInput.isSecondary() != input.isSecondary()) {
                ActivationSystem.this.activateSecondary(this.activator, input.isSecondary());
            }
            if (this.lastInput.isSecondaryAlt() != input.isSecondaryAlt()) {
                ActivationSystem.this.activateSecondaryAlt(this.activator, input.isSecondaryAlt());
            }
            if (input.getPrimaryDelta() != 0) {
                ActivationSystem.this.changePrimarySelector(this.activator, input.getPrimaryDelta());
            }
            if (input.getSecondaryDelta() != 0) {
                ActivationSystem.this.changeSecondarySelector(this.activator, input.getSecondaryDelta());
            }
            this.lastInput = input;
        }

        public void release() {
            if (this.lastInput.isPrimary()) {
                ActivationSystem.this.activatePrimary(this.activator, false);
            }
            if (this.lastInput.isPrimaryAlt()) {
                ActivationSystem.this.activatePrimaryAlt(this.activator, false);
            }
            if (this.lastInput.isSecondary()) {
                ActivationSystem.this.activateSecondary(this.activator, false);
            }
            if (this.lastInput.isSecondaryAlt()) {
                ActivationSystem.this.activateSecondaryAlt(this.activator, false);
            }
            this.lastInput = new ActivationInput(0, 0, 0);
        }
    }

    private class ActivatorImpl
    implements Activator {
        private Entity entity;
        private BodyPosition bPos;

        public ActivatorImpl(Entity entity) {
            this.entity = entity;
        }

        @Override
        public EntityId getId() {
            return this.entity.getId();
        }

        private BodyPosition getBodyPosition() {
            if (this.bPos == null) {
                this.bPos = this.getAt(BodyPosition.class);
            }
            return this.bPos;
        }

        @Override
        public Vec3d getEyePos() {
            Vec3d pos = this.getPos();
            return pos.add(0.0, 1.5, 0.0);
        }

        @Override
        public Vec3d getPos() {
            return this.getBodyPosition().getLastLocation();
        }

        @Override
        public Vec3d getLookDir() {
            return this.getLookOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Vec3d getDir() {
            return this.getOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Quatd getLookOrientation() {
            MovementInput mi = this.getAt(MovementInput.class);
            if (mi == null) {
                return null;
            }
            return mi.getFacing();
        }

        @Override
        public Quatd getOrientation() {
            return this.getBodyPosition().getLastOrientation();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick() {
            Rayd ray = new Rayd(this.getEyePos(), this.getLookDir());
            return ActivationSystem.this.collisionSystem.rayIterator(ray, 10.0);
        }

        @Override
        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(ActivationSystem.this.ed.getComponent(this.entity.getId(), type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }
    }
}

