/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.RigidBody;
import mythruna.GameConstants;
import mythruna.es.MovementInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerDriver
extends AbstractControlDriver<EntityId, MBlockShape> {
    static Logger log = LoggerFactory.getLogger(PlayerDriver.class);
    private EntityData ed;
    private EntityId player;
    private Vec3d vTemp = new Vec3d();
    private double groundImpulse = 200.0;
    private Vec3d desiredVelocity = new Vec3d();
    private Vec3d forward = new Vec3d();
    private Vec3d sideways = new Vec3d();
    private Quatd facing = new Quatd();
    private Quatd flatFacing = new Quatd();
    private boolean jump;
    private double upThreshold = 0.7;
    private double verticalThreshold = 0.42;
    private double jumpForce = 9.0;
    private boolean shortJumps = true;
    private boolean autoBounce = true;
    private int groundContactCount = 0;
    private Vec3d groundVelocity = new Vec3d();
    private EntityId groundEntity;
    private boolean canJump = false;
    private boolean isJumping = false;
    private boolean autoclimbEnabled = true;
    private double climbForce;
    private double highestSideContact;
    private boolean autoclimb;
    private boolean isClimbing;
    private Vec3d force;
    private double[] angles;
    private boolean noGravity;
    private boolean enabled;
    private long nextSpawnUpdateTime;
    private long updateInterval;

    public PlayerDriver(EntityData ed, EntityId player) {
        this.climbForce = 4.0 + -GameConstants.DEFAULT_GRAVITY.y;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
        this.force = new Vec3d();
        this.angles = new double[3];
        this.noGravity = false;
        this.enabled = true;
        this.nextSpawnUpdateTime = 0L;
        this.updateInterval = 5000000000L;
        this.ed = ed;
        this.player = player;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void initialize(RigidBody<EntityId, MBlockShape> body) {
        super.initialize(body);
        if (this.noGravity) {
            body.setLinearAcceleration(new Vec3d(0.0, 0.0, 0.0));
        }
        body.setLinearDamping(0.2);
    }

    public void applyMovementInput(MovementInput input) {
        if (log.isTraceEnabled()) {
            log.trace("applyInput(" + input + ")");
        }
        this.jump = input.isJumping();
        Vec3d move = input.getMove();
        double up = move.y;
        this.forward.set(0.0, 0.0, move.z);
        if (Math.abs(move.z) > 0.001) {
            input.getFacing().mult(this.forward, this.forward);
            this.forward.y = 0.0;
            this.forward.normalizeLocal().multLocal(Math.abs(move.z));
        }
        this.sideways.set(move.x, 0.0, 0.0);
        input.getFacing().mult(this.sideways, this.sideways);
        this.desiredVelocity.set(this.forward).addLocal(this.sideways);
        this.desiredVelocity.y += up;
        this.facing.set(input.getFacing());
        Vec3d dir = input.getFacing().mult(Vec3d.UNIT_Z);
        double flatRads = Math.atan2(dir.x, dir.z);
        if (Double.isNaN(flatRads) || Double.isInfinite(flatRads)) {
            flatRads = 0.0;
        }
        this.flatFacing.fromAngles(0.0, flatRads, 0.0);
    }

    public void newContact(Contact<EntityId, MBlockShape> contact) {
        double upness = Vec3d.UNIT_Y.dot(contact.contactNormal);
        if (upness < this.upThreshold) {
            contact.friction = 0.0;
            double dot = this.desiredVelocity.dot(contact.contactNormal);
            if (dot < 0.0) {
                double yRelative = contact.contactPoint.y - this.getBody().position.y;
                this.highestSideContact = Math.max(yRelative, this.highestSideContact);
                this.autoclimb = this.autoclimbEnabled;
            }
            return;
        }
        if (contact.body1 == this.getBody()) {
            this.canJump = upness > this.verticalThreshold ? true : this.autoclimbEnabled;
            if (contact.body2 instanceof RigidBody) {
                this.groundVelocity.addLocal(((RigidBody)contact.body2).getLinearVelocity());
                ++this.groundContactCount;
                this.groundEntity = (EntityId)contact.body2.id;
            }
        }
    }

    protected void calculateCollisionData() {
        if (this.groundContactCount > 0) {
            this.groundVelocity.multLocal(1.0 / (double)this.groundContactCount);
            log.info("walk: groundVelocity:" + this.groundVelocity);
        }
    }

    protected void invalidateCollisionData() {
        this.groundEntity = null;
        this.groundContactCount = 0;
        this.groundVelocity.set(0.0, 0.0, 0.0);
        this.canJump = false;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
    }

    protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
        body.orientation.toAngles(this.angles);
        if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
            this.angles[0] = 0.0;
            this.angles[2] = 0.0;
            body.orientation.fromAngles(this.angles);
        }
        Vec3d rot = body.getRotationalVelocity();
        if (rot.x != 0.0 || rot.z != 0.0) {
            rot.x = 0.0;
            rot.z = 0.0;
            body.setRotationalVelocity(rot);
        }
    }

    public void update(long frameTime, double step) {
        if (!this.enabled) {
            return;
        }
        RigidBody body = this.getBody();
        if (log.isTraceEnabled()) {
            log.trace("update(" + step + ")  temperature:" + body.getTemperature());
        }
        this.calculateCollisionData();
        this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)body);
        body.orientation.set(this.facing);
        Vec3d velocity = body.getLinearVelocity();
        double verticalVelocity = velocity.y - this.groundVelocity.y;
        if (this.desiredVelocity.lengthSq() > 0.0) {
            this.force.set(this.desiredVelocity).subtractLocal(velocity);
            this.force.addLocal(this.groundVelocity);
            if (this.desiredVelocity.y == 0.0) {
                this.force.y = 0.0;
            }
            this.force.multLocal(this.groundImpulse * 10.0);
            if (!this.isJumping && this.autoclimb && this.highestSideContact <= 0.0) {
                double mass = 1.0 / body.getInverseMass();
                this.force.y += this.climbForce * mass;
                this.isClimbing = true;
            }
            body.addForceAtPoint(this.force, 0.1, body.position.subtract(0.0, 0.8, 0.0));
        } else if (this.noGravity) {
            body.getLinearVelocity().set(0.0, 0.0, 0.0);
        }
        if (this.jump) {
            if ((this.isClimbing || this.canJump) && !this.isJumping) {
                log.info("walk: -------------------JUMP!   velocity.y:" + velocity.y);
                velocity.y = this.groundVelocity.y;
                velocity.y += this.jumpForce;
                this.isJumping = true;
            }
        } else {
            if (this.shortJumps && this.isJumping && verticalVelocity > 0.0) {
                log.info("walk: ---------------KILL JUMP!");
                velocity.y = Math.min(velocity.y, this.groundVelocity.y + 2.0);
            }
            this.isJumping = false;
        }
        if (this.isJumping) {
            log.info("walk:  y velocity:" + verticalVelocity);
        }
        if (this.autoBounce && this.isJumping && verticalVelocity <= 0.0) {
            this.isJumping = false;
            log.info("walk: ---------------Jump done, faling.");
        }
        body.wakeUp(true);
        this.invalidateCollisionData();
        if (frameTime > this.nextSpawnUpdateTime) {
            this.nextSpawnUpdateTime = frameTime + this.updateInterval;
            this.ed.setComponent(this.player, (EntityComponent)new SpawnPosition(GameConstants.PHYSICS_GRID, body.position, body.orientation));
        }
    }
}

