/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3d;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldInfo {
    public static final String DIR_EXTENSION = ".world";
    public static final String WORLD_INFO_FILE = "world.info";
    static Logger log = LoggerFactory.getLogger(WorldInfo.class);
    private transient File dir;
    private String name;
    private long created = System.currentTimeMillis();
    private long seed;
    private Vec3d spawnPoint;
    private Long fractalHash;

    public WorldInfo(String name, long seed) {
        this.seed = seed;
        this.name = name;
    }

    protected void setDirectory(File dir) {
        if (this.dir != null) {
            throw new IllegalArgumentException("WorldInfo already has a directory");
        }
        this.dir = dir;
    }

    public File getDirectory() {
        return this.dir;
    }

    public File getFile(String file) {
        return new File(this.dir, file);
    }

    public String getName() {
        return this.name;
    }

    public long getSeed() {
        return this.seed;
    }

    public Date getCreatedDate() {
        return new Date(this.created);
    }

    public void setSpawnPoint(Vec3d spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public Vec3d getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setFractalHash(Long fractalHash) {
        this.fractalHash = fractalHash;
    }

    public Long getFractalHash() {
        return this.fractalHash;
    }

    public BufferedImage getPreview() {
        File f = this.getFile("preview.png");
        if (!f.exists()) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(f);
            return image;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading preview:" + f, e);
        }
    }

    public String toString() {
        return "WorldInfo[" + this.name + "]";
    }
}

