/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.GeneratedColumnDb;
import com.simsilica.mworld.db.InitialSunlightProcessor;
import com.simsilica.mworld.db.InternalLightingProcessor;
import com.simsilica.mworld.db.LightingPostProcessor;
import com.simsilica.mworld.db.MaskPostProcessor;
import com.simsilica.mworld.db.ObservableColumnDb;
import com.simsilica.mworld.db.ObservableColumnDbAdapter;
import com.simsilica.mworld.db.PostProcColumnDb;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.ColumnStates;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageDb;
import com.simsilica.mworld.tile.TerrainImageManager;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TerrainTypeFunction;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileBasedColumnGenerator;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.insert.ApplyInsertsFunction;
import com.simsilica.mworld.tile.insert.InsertColumnProcessor;
import com.simsilica.mworld.tile.insert.InsertLayer;
import com.simsilica.mworld.tile.insert.InsertLayerDb;
import com.simsilica.mworld.tile.insert.InsertLayerProtocol;
import com.simsilica.mworld.tile.morph.ApplyMorphologyFunction;
import com.simsilica.mworld.tile.morph.BoxFill;
import com.simsilica.mworld.tile.morph.BoxFillProtocol;
import com.simsilica.mworld.tile.morph.MorphologyColumnProcessor;
import com.simsilica.mworld.tile.morph.MorphologyLayerDb;
import com.simsilica.mworld.tile.morph.MorphologyLayerProtocol;
import com.simsilica.mworld.tile.morph.SphereFill;
import com.simsilica.mworld.tile.morph.SphereFillProtocol;
import com.simsilica.mworld.tile.pc.PointCloudManager;
import com.simsilica.mworld.tile.pc.PointIndexFunction;
import com.simsilica.mworld.tile.tree.TreeColumnProcessor;
import com.simsilica.mworld.tile.tree.TreeLayerDb;
import com.simsilica.mworld.tile.tree.TreeLayerProtocol;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import javax.imageio.ImageIO;
import mythruna.world.BaseColumnProcessor;
import mythruna.world.FractalTerrainImageGenerator2;
import mythruna.world.PhysicalWorld;
import mythruna.world.PointTypeMapping;
import mythruna.world.TerrainTypes;
import mythruna.world.TreeGenerator;
import mythruna.world.WorldFractal;
import mythruna.world.WorldFractalFactory;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldUtils;
import mythruna.world.river.RiverSection;
import mythruna.world.river.RiverSectionProtocol;
import mythruna.world.river.RiverTileFunction;
import mythruna.world.town.TestBlockRegistry;
import mythruna.world.town.TownTestTileFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldManager {
    static Logger log = LoggerFactory.getLogger(WorldManager.class);
    private WorldInfo info;
    private WorldFractal worldFractal;
    private DefaultWorld world;
    private TileManager tileManager;
    private TreeLayerDb treeDb;
    private MorphologyLayerDb morphDb;
    private InsertLayerDb insertDb;
    private ObservableEntityData entityData;
    private ColumnDb rawColDb;
    private PhysicalWorld physWorld;

    public WorldManager(WorldInfo info) {
        this(info, null);
    }

    public WorldManager(WorldInfo info, ObservableEntityData ed) {
        this.info = info;
        this.entityData = ed;
    }

    public WorldInfo getInfo() {
        return this.info;
    }

    public World getWorld() {
        return this.world;
    }

    public World getPhysicalWorld() {
        return this.physWorld;
    }

    public int getElevation(int x, int z) {
        double elevation = this.worldFractal.getElevation(x, z);
        int e = (int)Math.round(elevation);
        if (e == 0) {
            e = 1;
        }
        return e;
    }

    public ObservableEntityData getEntityData() {
        return this.entityData;
    }

    public EntityId findNamedEntity(String name) {
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)name);
        return this.entityData.findEntity(filter, new Class[]{Name.class});
    }

    public String getName(EntityId entity) {
        Name name = (Name)this.entityData.getComponent(entity, Name.class);
        return name == null ? null : name.getName();
    }

    protected void initialize() {
        File indexFile;
        BlockTypeData lastGlobal;
        boolean changed;
        BlockTypeData local;
        BlockTypeData global;
        this.worldFractal = WorldFractalFactory.createSample(this.info.getSeed());
        if (this.info.getFractalHash() == null) {
            log.info("Resetting fractal hash...");
            this.info.setFractalHash(this.worldFractal.getFractalHash());
            WorldLibrary.store(this.info);
        } else {
            log.info("Checking fractal hash...");
            if (this.info.getFractalHash().longValue() != this.worldFractal.getFractalHash()) {
                log.warn("Current world fractal does not match stored world data.");
            }
        }
        if (this.entityData == null) {
            try {
                this.entityData = new SqlEntityData(this.info.getFile("entities"), 1000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Error starting entity database", e);
            }
        }
        if (this.info.getSpawnPoint() == null) {
            log.warn("World is missing spawn location:" + this.info);
            Vec3d spawn = WorldUtils.findSpawn(this.worldFractal);
            log.info("Calculated spawn:" + spawn);
            spawn.y = this.getElevation((int)spawn.x, (int)spawn.z);
            spawn.y += 1.0;
            this.info.setSpawnPoint(spawn);
            WorldLibrary.store(this.info);
        }
        try {
            global = BlockTypeData.load((String)"/blocks.bset");
            if (global == null) {
                throw new RuntimeException("No base blockset data found for resource: blocks.bset");
            }
            File bsetFile = this.info.getFile("blocks.bset");
            File lastBsetFile = this.info.getFile("last-global-blocks.bset");
            local = BlockTypeData.load((File)bsetFile);
            changed = false;
            if (local == null) {
                log.info("Initializing world blockset file.");
                local = global;
                changed = true;
            } else {
                log.info("Checking for blockset upgrades.");
                lastGlobal = BlockTypeData.load((File)lastBsetFile);
                if (lastGlobal != null) {
                    log.info("Comparing global blockset snapshot...");
                    changed = lastGlobal.update(global);
                } else {
                    changed = true;
                }
                if (changed) {
                    log.info("Upgrading local version to latest global...");
                    local.update(global);
                }
            }
            if (changed) {
                log.info("Storing world blockset:" + bsetFile);
                BlockTypeData.store((BlockTypeData)local, (File)bsetFile);
                log.info("Storing global blockset snapshot:" + lastBsetFile);
                BlockTypeData.store((BlockTypeData)global, (File)lastBsetFile);
                indexFile = this.info.getFile("block.index");
                log.info("Writing block.index:" + indexFile);
                local.writeIndex(indexFile);
            }
            BlockTypeIndex.reset();
            BlockTypeIndex.initialize((BlockTypeData)local);
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world blockset", e);
        }
        try {
            global = FluidTypeData.load((String)"/fluids.fset");
            if (global == null) {
                throw new RuntimeException("No base fluidset data found for resource: fluids.fset");
            }
            File fsetFile = this.info.getFile("fluids.fset");
            File lastFsetFile = this.info.getFile("last-global-fluids.fset");
            local = FluidTypeData.load((File)fsetFile);
            changed = false;
            if (local == null) {
                log.info("Initializing world fluidset file.");
                local = global;
                changed = true;
            } else {
                log.info("Checking for fluidset upgrades.");
                lastGlobal = FluidTypeData.load((File)lastFsetFile);
                if (lastGlobal != null) {
                    log.info("Comparing global fluidset snapshot...");
                    changed = lastGlobal.update((FluidTypeData)global);
                } else {
                    changed = true;
                }
                if (changed) {
                    log.info("Upgrading local version to latest global...");
                    local.update((FluidTypeData)global);
                }
            }
            if (changed) {
                log.info("Storing world fluidset:" + fsetFile);
                FluidTypeData.store((FluidTypeData)local, (File)fsetFile);
                log.info("Storing global fluidset snapshot:" + lastFsetFile);
                FluidTypeData.store((FluidTypeData)global, (File)lastFsetFile);
                indexFile = this.info.getFile("fluid.index");
                log.info("Writing fluid.index:" + indexFile);
                local.writeIndex(indexFile);
            }
            FluidTypeIndex.reset();
            FluidTypeIndex.initialize((FluidTypeData)local);
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world fluidset", e);
        }
        final int sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1);
        final int dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1);
        final int grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1);
        final int stoneType = BlockTypeIndex.findType((BlockName)new BlockName("stone", "cube"), (int)1);
        TerrainTypeFunction insertTypeFunction = new TerrainTypeFunction(){

            public int apply(int rawType, int blockType) {
                if (blockType == sandType) {
                    return 0;
                }
                if (blockType == dirtType) {
                    return 1;
                }
                if (blockType == grassType) {
                    return 9;
                }
                if (blockType == stoneType) {
                    return 2;
                }
                return -1;
            }
        };
        final int TERRAIN_BITS = CellGenType.Terrain.getBits();
        TerrainTypeFunction imageTypeFunction = new TerrainTypeFunction(){

            public int apply(int rawType, int blockType) {
                int typeBits = CellGenType.getTypeBits((int)rawType);
                if (typeBits != TERRAIN_BITS) {
                    return -1;
                }
                if (blockType == sandType) {
                    return 0;
                }
                if (blockType == dirtType) {
                    return 1;
                }
                if (blockType == grassType) {
                    return 9;
                }
                if (blockType == stoneType) {
                    return 2;
                }
                return -1;
            }
        };
        IntCombiner typeMerge = new IntCombiner(){

            public int apply(int existing, int type) {
                if (type == -1) {
                    return TerrainTypes.getBaseType(existing);
                }
                int baseType = TerrainTypes.getBaseType(type);
                if (baseType == 0) {
                    return -2;
                }
                if (baseType == 1) {
                    int foliage = TerrainTypes.getFoliageLevel(type);
                    if (foliage == 0) {
                        existing = TerrainTypes.getBaseType(type);
                    }
                    return existing;
                }
                return type;
            }
        };
        IntCombiner blockMerge = new IntCombiner(){

            public int apply(int rawExisting, int rawType) {
                int existing = MaskUtils.getType((int)rawExisting);
                int type = MaskUtils.getType((int)rawType);
                if (type == sandType) {
                    return rawExisting;
                }
                if (existing == 0) {
                    return rawType;
                }
                if (type == 0) {
                    return rawExisting;
                }
                if (type == dirtType || type == grassType) {
                    if (existing == 0) {
                        return rawType;
                    }
                    return rawExisting;
                }
                return rawType;
            }
        };
        File tileRoot = this.info.getFile("tile.db");
        TerrainImageDb terrainImageDb = new TerrainImageDb(tileRoot);
        this.tileManager = new TileManager(terrainImageDb);
        this.tileManager.addTileFunction(new TileFunction[]{new FractalTerrainImageGenerator2(this.worldFractal)});
        TestBlockRegistry blocksFunction = new TestBlockRegistry();
        this.morphDb = new MorphologyLayerDb(tileRoot, new MorphologyLayerProtocol());
        this.morphDb.getProtocol().registerProtocol(BoxFill.class, (ObjectProtocol)new BoxFillProtocol());
        this.morphDb.getProtocol().registerProtocol(SphereFill.class, (ObjectProtocol)new SphereFillProtocol());
        this.morphDb.getProtocol().registerProtocol(RiverSection.class, (ObjectProtocol)new RiverSectionProtocol());
        this.insertDb = new InsertLayerDb(tileRoot, new InsertLayerProtocol());
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.morphDb.getLoadFunction(), new RiverTileFunction(), new ApplyMorphologyFunction()});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.insertDb.getLoadFunction(), new TownTestTileFunction(blocksFunction, this.info.getSpawnPoint()), new ApplyInsertsFunction((Function)blocksFunction, insertTypeFunction, typeMerge)});
        this.treeDb = new TreeLayerDb(tileRoot, new TreeLayerProtocol());
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.treeDb.getLoadFunction(), new TreeGenerator(this.worldFractal)});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.treeDb.getSaveFunction()});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.morphDb.getSaveFunction()});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.insertDb.getSaveFunction()});
        this.tileManager.addTileFunction(new TileFunction[]{terrainImageDb.getSaveFunction()});
        File worldDb = this.info.getFile("world.db");
        int leafCount = 21;
        TileBasedColumnGenerator colGenerator = new TileBasedColumnGenerator(this.tileManager, leafCount, new TileColumnProcessor[]{new BaseColumnProcessor(this.worldFractal, this.tileManager), new MorphologyColumnProcessor(), new InsertColumnProcessor((Function)blocksFunction, blockMerge, null), new TreeColumnProcessor()});
        GeneratedColumnDb cdb = new GeneratedColumnDb(worldDb, (Function)colGenerator);
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new MaskPostProcessor()});
        this.rawColDb = cdb;
        this.physWorld = new PhysicalWorld(this.rawColDb, 672);
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new InitialSunlightProcessor()});
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new InternalLightingProcessor()});
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new LightingPostProcessor()});
        ObservableColumnDbAdapter colDb = new ObservableColumnDbAdapter((ColumnDb)cdb);
        final TerrainImageManager terrainImageManager = new TerrainImageManager(tileRoot, terrainImageDb, (ObservableColumnDb)colDb, this.tileManager, imageTypeFunction);
        PointCloudManager pointCloudManager = new PointCloudManager(tileRoot, (ObservableColumnDb)colDb, this.tileManager, terrainImageManager){

            protected boolean initializeStates(TileId id, ColumnStates states) {
                boolean changed = false;
                Tile tile = this.getTileManager().getTile(id, Resolution.High);
                InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
                if (log.isTraceEnabled()) {
                    log.trace("PointCloud total active morph bins:" + inserts.getActiveBinIds().size());
                }
                for (Short s : inserts.getActiveBinIds()) {
                    if (!states.markDirty(s.shortValue())) continue;
                    changed = true;
                }
                if (changed) {
                    TerrainImage terrainImage = terrainImageManager.getTerrainImage(id, TerrainImageType.Terrain, Resolution.High);
                }
                return changed;
            }
        };
        pointCloudManager.setPointIndexFunction((PointIndexFunction)new PointTypeMapping());
        this.treeDb.initialize();
        this.morphDb.initialize();
        this.insertDb.initialize();
        this.world = new DefaultWorld((ColumnDb)colDb, this.tileManager, terrainImageManager, pointCloudManager, 672);
        this.world.initialize();
    }

    public void close() {
        this.world.terminate();
        this.treeDb.terminate();
        this.morphDb.terminate();
        this.insertDb.terminate();
    }

    public static WorldManager loadWorld(WorldInfo info) {
        WorldManager result = new WorldManager(info);
        result.initialize();
        return result;
    }

    public static WorldManager createWorld(WorldInfo info) {
        WorldManager result = new WorldManager(info);
        result.initialize();
        Vec3d spawn = info.getSpawnPoint();
        log.info("Generating preview image...");
        double previewSize = 65536.0;
        Vec3d corner = spawn.subtract(previewSize * 0.5, 0.0, previewSize * 0.5);
        BufferedImage image = WorldUtils.createMapImage(result.worldFractal, 512, corner.x, corner.z, previewSize);
        try {
            File imgFile = info.getFile("preview.png");
            ImageIO.write((RenderedImage)image, "png", imgFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating preview", e);
        }
        WorldLibrary.store(info);
        return result;
    }
}

