/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellUtils;
import com.simsilica.mblock.io.BlockObject;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockRegistry
implements Function<BlockDataId, BlockData> {
    static Logger log = LoggerFactory.getLogger(TestBlockRegistry.class);
    private static BuildingFactory[] testBuildings = new BuildingFactory[]{new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("tower2.blocks", 1, true), new BuildingFactory("dungeon-stairs.blocks", 10, 9, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg7.blocks", 1, true), new BuildingFactory("tall-dungeon.blocks", 12, 12, true), new BuildingFactory("test-path2.blocks", 1, true), new BuildingFactory("test-bldg8.blocks", 2, true)};
    private static BuildingFactory[] other = new BuildingFactory[]{new BuildingFactory("spawn-tower.blocks", 1, true)};
    private Map<BlockDataId, BlockData> index = new HashMap<BlockDataId, BlockData>();
    private ListMultimap<String, BlockDataId> nameIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    private Map<String, BuildingFactory> factoryIndex = new HashMap<String, BuildingFactory>();

    public TestBlockRegistry() {
        BlockData blocks;
        BlockObject bo;
        for (BuildingFactory factory : testBuildings) {
            try {
                bo = BlocksFileFormat.readBlocks((String)("/Models/" + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.addAllOrientations(factory.name, blocks);
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
        for (BuildingFactory factory : other) {
            try {
                bo = BlocksFileFormat.readBlocks((String)("/Models/" + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.nameIndex.put((Object)factory.name, (Object)this.add(blocks));
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
    }

    public BuildingFactory getSpawnTower() {
        return other[0];
    }

    public BuildingFactory getRandomBuilding(Random rand) {
        int i = rand.nextInt(testBuildings.length);
        return testBuildings[i];
    }

    public BlockDataId getRandomOrientation(BuildingFactory factory, Random rand) {
        return this.getRandomOrientation(factory.name, rand);
    }

    public BlockDataId getRandomOrientation(String name, Random rand) {
        List<BlockDataId> list = this.find(name);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No orientations mapped for:" + name);
        }
        int i = rand.nextInt(list.size());
        return list.get(i);
    }

    public BlockDataId findFirst(String name) {
        List values = this.nameIndex.get((Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return (BlockDataId)values.get(0);
    }

    public List<BlockDataId> find(String name) {
        return this.nameIndex.get((Object)name);
    }

    public int size() {
        return this.index.size();
    }

    @Override
    public BlockData apply(BlockDataId id) {
        return this.index.get(id);
    }

    protected void addAllOrientations(String name, BlockData blocks) {
        this.nameIndex.put((Object)name, (Object)this.add(blocks));
        CellArray cells = blocks.getCells();
        CellArray xformed = null;
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)2);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)3);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.mirrorX((CellArray)cells);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.mirrorZ((CellArray)cells);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        xformed = CellUtils.mirrorX((CellArray)xformed);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        xformed = CellUtils.mirrorZ((CellArray)xformed);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
    }

    public BlockDataId add(BlockData blocks) {
        BlockDataId id = new BlockDataId((long)this.index.size());
        this.index.put(id, blocks);
        return id;
    }

    public static class BuildingFactory {
        String name;
        int groundLevel;
        int yOffset;
        boolean aboveGround;

        public BuildingFactory(String name, int groundLevel, boolean aboveGround) {
            this(name, groundLevel, groundLevel, aboveGround);
        }

        public BuildingFactory(String name, int groundLevel, int yOffset, boolean aboveGround) {
            this.name = name;
            this.groundLevel = groundLevel;
            this.yOffset = yOffset;
            this.aboveGround = aboveGround;
        }
    }
}

