/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tree;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChristmasTreeType
extends AbstractTreeType {
    static Logger log = LoggerFactory.getLogger(ChristmasTreeType.class);
    private static final int RADIUS = 3;
    private static final int WIDTH = 7;
    private static final int[][][] layers = new int[][][]{new int[][]{{0, -1, -1, 5, -1, -1, 0}, {-1, 4, 4, 5, 6, 6, -1}, {-1, 4, 4, 5, 6, 6, -1}, {3, 3, 3, 9, 7, 7, 7}, {-1, 2, 2, 1, 8, 8, -1}, {-1, 2, 2, 1, 8, 8, -1}, {0, -1, -1, 1, -1, -1, 0}}, new int[][]{{0, 0, -1, 5, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {-1, 4, 4, 5, 6, 6, -1}, {3, 3, 3, 9, 7, 7, 7}, {-1, 2, 2, 1, 8, 8, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, 1, -1, 0, 0}}, new int[][]{{0, 0, -1, 5, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {-1, 4, 4, 5, 6, 6, -1}, {3, 3, 3, 9, 7, 7, 7}, {-1, 2, 2, 1, 8, 8, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, 1, -1, 0, 0}}, new int[][]{{0, 0, -1, -1, -1, 0, 0}, {0, 0, 4, 5, 6, -1, 0}, {-1, 4, 4, 5, 6, 6, -1}, {-1, 3, 3, 9, 7, 7, -1}, {-1, 2, 2, 1, 8, 8, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, -1, -1, 0, 0}}, new int[][]{{0, 0, -1, -1, -1, 0, 0}, {0, 0, 4, 5, 6, -1, 0}, {-1, 4, 4, 5, 6, 6, -1}, {-1, 3, 3, 9, 7, 7, -1}, {-1, 2, 2, 1, 8, 8, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, -1, -1, 0, 0}}, new int[][]{{0, 0, 0, -1, 0, 0, 0}, {0, 0, -1, 5, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {-1, 3, 3, 10, 7, 7, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, 1, -1, 0, 0}, {0, 0, 0, -1, 0, 0, 0}}, new int[][]{{0, 0, 0, -1, 0, 0, 0}, {0, 0, -1, 5, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {-1, 3, 3, 10, 7, 7, -1}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, 1, -1, 0, 0}, {0, 0, 0, -1, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -1, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {0, -1, 3, 10, 7, -1, 0}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, -1, -1, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -1, -1, 0, 0}, {0, -1, 4, 5, 6, -1, 0}, {0, -1, 3, 10, 7, -1, 0}, {0, -1, 2, 1, 8, -1, 0}, {0, 0, -1, -1, -1, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, -1, 0, 0, 0}, {0, 0, -1, 5, -1, 0, 0}, {0, -1, 3, 10, 7, -1, 0}, {0, 0, -1, 1, -1, 0, 0}, {0, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, -1, 0, 0, 0}, {0, 0, -1, 5, -1, 0, 0}, {0, -1, 3, 10, 7, -1, 0}, {0, 0, -1, 1, -1, 0, 0}, {0, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}};
    private int[][] footprint = new int[][]{{0, 0, 2, 2, 2, 0, 0}, {0, 2, 4, 4, 4, 2, 0}, {2, 4, 6, 6, 6, 4, 2}, {2, 4, 6, 15, 6, 4, 2}, {2, 4, 6, 6, 6, 4, 2}, {0, 2, 4, 4, 4, 2, 0}, {0, 0, 2, 2, 2, 0, 0}};
    private int footprintSize = 7;
    private int footprintOffset = 3;
    private int baseTrunkHeight = 1;
    private int randomTrunkHeight = 4;
    private int baseCanopyHeight = 3;
    private int randomCanopyHeight = 12;
    private int typeTop;
    private int[] parts;
    private int[] lights;

    public ChristmasTreeType(String name, AtlasCell atlasCell) {
        this(name, atlasCell, 1, 4, 3, 12);
    }

    public ChristmasTreeType(String name, AtlasCell atlasCell, int baseTrunkHeight, int randomTrunkHeight, int baseCanopyHeight, int randomCanopyHeight) {
        super(name, atlasCell);
        this.baseTrunkHeight = baseTrunkHeight;
        this.randomTrunkHeight = randomTrunkHeight;
        this.baseCanopyHeight = baseCanopyHeight;
        this.randomCanopyHeight = randomCanopyHeight;
    }

    public void initialize(TreeTypeIndex treeTypes) {
        this.parts = new int[]{0, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(0))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(1))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(1))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(2))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(2))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(3))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(3))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(0))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl")) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl25")) | TREE_BITS, this.typeTop = BlockTypeIndex.findType((BlockName)new BlockName("pine", "top")) | TREE_BITS};
        this.lights = new int[]{BlockTypeIndex.findType((BlockName)new BlockName("magic-red", "mini2")), BlockTypeIndex.findType((BlockName)new BlockName("magic-green", "mini2")), BlockTypeIndex.findType((BlockName)new BlockName("magic-blue", "mini2")), BlockTypeIndex.findType((BlockName)new BlockName("magic-white", "mini2"))};
    }

    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random rand) {
        int trunkHeight = rand.nextInt(this.randomTrunkHeight) + this.baseTrunkHeight;
        int canopyHeight = rand.nextInt(this.randomCanopyHeight) + this.baseCanopyHeight;
        int height = trunkHeight + canopyHeight;
        return new Tree(x, y, z, (byte)(height += 2), 3, (byte)trunkHeight, (TreeType)this);
    }

    private void addLayer(int[][] layer, int i, int j, int k, CellData cells, Random rand) {
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                int v;
                int r = layer[z][x];
                if (r == 0) continue;
                if (r > 0) {
                    v = this.parts[r];
                } else {
                    double chance = rand.nextDouble();
                    if (chance < 0.85) {
                        int index = rand.nextInt(3);
                        v = this.lights[index];
                    } else {
                        if (!(chance < 0.95)) continue;
                        v = this.lights[3];
                    }
                }
                cells.setCell(i + x - 3, j, k + z - 3, v);
            }
        }
    }

    public boolean markTree(Tree tree, boolean[][] used) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                if (this.footprint[x][z] <= 0) continue;
                used[i + x][k + z] = true;
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TileColumnCells cells, Random rand) {
        int y;
        int treeHeight = tree.height - 2;
        byte trunkHeight = tree.other;
        int canopyHeight = treeHeight - trunkHeight;
        float delta = (float)layers.length / (float)canopyHeight;
        float layer = 0.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
            layer = layers.length - canopyHeight;
        }
        int trunkType = layers[Math.round(layer)][3][3];
        trunkType = this.parts[trunkType];
        short i = tree.x;
        short j = tree.y;
        short k = tree.z;
        int start = tree.y;
        int end = tree.y + trunkHeight;
        for (y = start; y < end; ++y) {
            cells.setCell((int)i, y, (int)k, trunkType);
        }
        start = j + trunkHeight;
        end = j + treeHeight;
        for (y = start; y < end; ++y) {
            int index = Math.min(Math.round(layer), layers.length - 1);
            layer += delta;
            this.addLayer(layers[index], i, y, k, (CellData)cells, rand);
        }
        cells.setCell((int)i, j + treeHeight, (int)k, this.typeTop);
        cells.setCell((int)i, j + treeHeight + 1, (int)k, this.lights[3]);
        cells.setCell((int)i, j + treeHeight + 2, (int)k, this.lights[3]);
        cells.setCell(i + 1, j + treeHeight + 2, (int)k, this.lights[3]);
        cells.setCell(i - 1, j + treeHeight + 2, (int)k, this.lights[3]);
        cells.setCell((int)i, j + treeHeight + 2, k + 1, this.lights[3]);
        cells.setCell((int)i, j + treeHeight + 2, k - 1, this.lights[3]);
        cells.setCell((int)i, j + treeHeight + 3, (int)k, this.lights[3]);
        return true;
    }

    public boolean insertTree(Tree tree, TerrainImage terrain) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                byte existing = terrain.getLight(i + x, k + z);
                terrain.setLight(i + x, k + z, (byte)Math.max(-this.footprint[x][z], existing));
            }
        }
        return true;
    }
}

