/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.google.common.base.Supplier;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ErrorListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.client.EntityDataClientService;
import com.simsilica.ethereal.EtherealClient;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.fsm.StateMachine;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import mythruna.client.net.GameClient;
import mythruna.client.net.TimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ConnectionState.class);
    private StateMachine fsm;
    private String host;
    private int port;
    private GameClient client;
    private ConnectionObserver connectionObserver = new ConnectionObserver();
    private Connector connector;
    private Thread renderThread;
    private AtomicBoolean closing = new AtomicBoolean(false);
    private Supplier<String> tokenSupplier;

    public ConnectionState(StateMachine fsm, String host, int port, Supplier<String> tokenSupplier) {
        this.fsm = fsm;
        this.host = host;
        this.port = port;
        this.tokenSupplier = tokenSupplier;
        this.client = new GameClient();
    }

    public int getClientId() {
        if (this.client.getClient() == null) {
            return -1;
        }
        return this.client.getClient().getId();
    }

    public TimeSource getRemoteTimeSource() {
        return this.getService(EtherealClient.class).getTimeSource();
    }

    public EntityData getEntityData() {
        return this.getService(EntityDataClientService.class).getEntityData();
    }

    public <T> T getService(Class<T> type) {
        if (this.client == null) {
            return null;
        }
        return this.client.getService(type);
    }

    public void close() {
        if (this.closing.get()) {
            return;
        }
        this.closing.set(true);
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void initialize(Application app) {
        if (this.getState(ConnectionState.class) != this) {
            throw new RuntimeException("More than one ConnectionState is not yet allowed.");
        }
        this.renderThread = Thread.currentThread();
        this.connector = new Connector();
        this.connector.start();
    }

    protected void cleanup(Application app) {
        this.close();
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void onError(Throwable t) {
        this.fsm.trigger((Object)"disconnect", (Object)t);
    }

    protected void onConnected() {
        log.info("onConnected()");
        ((TimeState)this.getState(TimeState.class)).setTimeSource(this.getRemoteTimeSource());
        if (this.fsm.isRunning()) {
            this.fsm.trigger((Object)"success");
        }
    }

    protected void onDisconnected(ClientStateListener.DisconnectInfo info) {
        log.info("onDisconnected(" + info + ")");
        if (this.fsm.isRunning()) {
            this.fsm.trigger((Object)"disconnect", (Object)info);
        }
    }

    private class Connector
    extends Thread {
        @Override
        public void run() {
            if (ConnectionState.this.closing.get()) {
                return;
            }
            try {
                log.info("Creating game client for:" + ConnectionState.this.host + " " + ConnectionState.this.port);
                ConnectionState.this.client.connect(ConnectionState.this.host, ConnectionState.this.port);
                ConnectionState.this.client.getClient().addClientStateListener((ClientStateListener)ConnectionState.this.connectionObserver);
                ConnectionState.this.client.getClient().addErrorListener((ErrorListener)ConnectionState.this.connectionObserver);
                if (ConnectionState.this.closing.get()) {
                    return;
                }
                log.info("Starting client...");
                ConnectionState.this.client.start();
                log.info("Client started.");
            }
            catch (IOException e) {
                if (ConnectionState.this.closing.get()) {
                    return;
                }
                log.error("Error connecting", (Throwable)e);
                ConnectionState.this.getApplication().enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        ConnectionState.this.onError(e);
                        return null;
                    }
                });
            }
        }
    }

    private class ConnectionObserver
    implements ClientStateListener,
    ErrorListener<Client> {
        private ConnectionObserver() {
        }

        public void clientConnected(Client c) {
            log.info("clientConnected(" + c + ")");
            ConnectionState.this.getApplication().enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    ConnectionState.this.onConnected();
                    return null;
                }
            });
        }

        public void clientDisconnected(Client c, final ClientStateListener.DisconnectInfo info) {
            log.info("clientDisconnected(" + c + ", " + info + ")");
            ConnectionState.this.getApplication().enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    ConnectionState.this.onDisconnected(info);
                    return null;
                }
            });
        }

        public void handleError(Client source, final Throwable throwable) {
            log.error("Connection error", throwable);
            ConnectionState.this.getApplication().enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    ConnectionState.this.onError(throwable);
                    return null;
                }
            });
        }
    }
}

