/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.simsilica.es.EntityData;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.fsm.StateMachine;
import com.simsilica.fx.LightingState;
import com.simsilica.fx.sky.SkySettingsState;
import com.simsilica.fx.sky.SkyState;
import com.simsilica.input.MovementState;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mworld.World;
import com.simsilica.mworld.view.FarTerrainState;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.PointCloudState;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.TreeState;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CameraState;
import com.simsilica.state.CompositeAppState;
import java.io.InputStream;
import java.util.Map;
import mythruna.client.GameSettingsState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.view.ActivationInputState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.BlockTypeSelectionState;
import mythruna.client.view.HelpMenuState;
import mythruna.client.view.HudStatsState;
import mythruna.client.view.InGameMenuState;
import mythruna.client.view.ModelViewState;
import mythruna.client.view.PlayerMenuState;
import mythruna.client.view.ShellState;
import mythruna.client.view.TerrainMaterials;
import mythruna.client.view.WorldViewState;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.client.GameSessionClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(GameSessionState.class);
    private GameSessionClientService session;
    private Map<String, Material> materials;
    private GeometryFactory geomFactory;
    private StateMachine<String, String> uiFsm;
    public static final String T_EXIT = "exit";
    public static final String T_RETURN_TO_GAME = "returnToGame";
    public static final String T_OPEN_GAME_MENU = "openGameMenu";
    public static final String T_OPEN_PLAYER_BOOK = "openPlayerBook";
    public static final String T_OPEN_SETTINGS_MENU = "openSettingsMenu";
    public static final String T_SELECT_TYPE = "selectType";
    public static final String T_OPEN_HELP = "openHelp";
    public static final String STATE_IN_GAME = "In Game";
    public static final String STATE_GAME_MENU = "Game Menu";
    public static final String STATE_PLAYER_BOOK = "Player Book";
    public static final String STATE_SETTINGS = "Settings";
    public static final String STATE_SELECT_TYPE = "Select Type";
    public static final String STATE_HELP = "Help";

    public GameSessionState() {
        super(new AppState[]{new MovementState(), new CameraState(), new LightingState(), new SkyState(true), new SkySettingsState(), new BlackboardState()});
    }

    public GameSession getGameSession() {
        return this.session;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geomFactory;
    }

    public World getWorld() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
    }

    public EntityData getEntityData() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
    }

    public TimeSource getTimeSource() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getRemoteTimeSource();
    }

    public void addGameSessionListener(GameSessionListener l) {
        this.session.addGameSessionListener(l);
    }

    public void removeGameSessionListener(GameSessionListener l) {
        this.session.removeGameSessionListener(l);
    }

    public void exit() {
        log.info("exit()");
        this.getApplication().stop();
    }

    protected void initialize(Application app) {
        ((BlackboardState)this.getState(BlackboardState.class)).set(World.class, (Object)this.getWorld());
        FogSettings fogSettings = new FogSettings();
        ((BlackboardState)this.getState(BlackboardState.class)).set(FogSettings.class, (Object)fogSettings);
        fogSettings.setFogColor(new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        fogSettings.setFogDistance(3072);
        this.addChild((AppState)new AvatarState());
        this.addChild((AppState)new ActivationInputState());
        this.addChild((AppState)new WorldViewState());
        this.addChild((AppState)new ModelViewState());
        this.addChild((AppState)new TerrainState());
        this.addChild((AppState)new FarTerrainState());
        this.addChild((AppState)new TreeState());
        this.addChild((AppState)new PointCloudState(true).workerPoolId("backgroundWorkers"), true);
        this.addChild((AppState)new HudStatsState(), true);
        this.addChild((AppState)new InGameMenuState(), true);
        this.addChild((AppState)new PlayerMenuState(), true);
        this.addChild((AppState)new BlockTypeSelectionState(), true);
        this.addChild((AppState)new ShellState());
        this.addChild((AppState)new HelpMenuState(), true);
        ((CameraState)this.getState(CameraState.class)).setFieldOfView(60.0f);
        ((CameraState)this.getState(CameraState.class)).setNear(0.1f);
        ((CameraState)this.getState(CameraState.class)).setFar(8000.0f);
        ((MovementState)this.getState(MovementState.class)).setWalkSpeed(4.5);
        ((MovementState)this.getState(MovementState.class)).setRunSpeed(7.5);
        ((TerrainState)this.getChild(TerrainState.class)).setMaterialFactory(TerrainMaterials.terrainMaterial(app));
        ((FarTerrainState)this.getChild(FarTerrainState.class)).setMaterialFactory(TerrainMaterials.farTerrainMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setMaterialFactory(TerrainMaterials.treeBillboardMaterial(app));
        ((PointCloudState)this.getChild(PointCloudState.class)).setMaterialFactory(TerrainMaterials.pointCloudMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setClipDistance(3072.0f);
        ((PointCloudState)this.getChild(PointCloudState.class)).setClipDistance(3072.0f);
        LightingState lighting = (LightingState)this.getChild(LightingState.class);
        lighting.setSunColor(new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f));
        lighting.setTimeOfDay(0.16f);
        this.session = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(GameSessionClientService.class);
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host != null) {
            // empty if block
        }
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/materials.mset");
            if (in == null) {
                throw new RuntimeException("Resource /materials.mset not found");
            }
            this.materials = MaterialRegistry.loadCompiledMaterials((AssetManager)app.getAssetManager(), (InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading /materials.mset", e);
        }
        this.geomFactory = new GeometryFactory(false, this.materials);
        this.configureUiStateMachine();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        super.onEnable();
        this.uiFsm.start();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(STATE_IN_GAME);
    }

    protected void onDisable() {
        super.onDisable();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(STATE_IN_GAME);
    }

    public void trigger(String transition) {
        this.uiFsm.trigger((Object)transition);
    }

    public void openGameMenu() {
        this.trigger(T_OPEN_GAME_MENU);
    }

    public void openPlayerMenu() {
        this.trigger(T_OPEN_PLAYER_BOOK);
    }

    public void selectBlockType() {
        this.trigger(T_SELECT_TYPE);
    }

    public void openHelp() {
        this.trigger(T_OPEN_HELP);
    }

    protected void configureUiStateMachine() {
        this.uiFsm = new StateMachine();
        StateMachine<String, String> fsm = this.uiFsm;
        fsm.addDefaultTermination((Object)T_EXIT);
        fsm.addDefaultTransition((Object)T_RETURN_TO_GAME, (Object)STATE_IN_GAME);
        fsm.addDefaultTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_GAME_MENU);
        fsm.addDefaultTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_PLAYER_BOOK);
        fsm.addDefaultTransition((Object)T_OPEN_SETTINGS_MENU, (Object)STATE_SETTINGS);
        fsm.addDefaultTransition((Object)T_SELECT_TYPE, (Object)STATE_SELECT_TYPE);
        fsm.addDefaultTransition((Object)T_OPEN_HELP, (Object)STATE_HELP);
        fsm.setStart((Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_GAME_MENU).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_PLAYER_BOOK).addTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_SETTINGS).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_SELECT_TYPE).addTransition((Object)T_SELECT_TYPE, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_HELP).addTransition((Object)T_OPEN_HELP, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_IN_GAME).onEnter(() -> ((MovementState)this.getState(MovementState.class)).setEnabled(true)).onExit(() -> ((MovementState)this.getState(MovementState.class)).setEnabled(false));
        fsm.getState((Object)STATE_GAME_MENU).onEnter(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(true)).onExit(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_PLAYER_BOOK).onEnter(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(true)).onExit(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_SETTINGS).onEnter(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(true);
        }).onExit(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(true);
        });
        fsm.getState((Object)STATE_SELECT_TYPE).onEnter(() -> ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setEnabled(true)).onExit(() -> ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setEnabled(false));
        fsm.getState((Object)STATE_HELP).onEnter(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(true)).onExit(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(false));
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_MENU, (Object)this, T_OPEN_GAME_MENU);
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_MENU, (Object)this, "openPlayerMenu");
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_EQUIPMENT, (Object)this, "selectBlockType");
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_HELP, (Object)this, T_OPEN_HELP);
    }
}

