/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.fx.LightingState;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import com.simsilica.state.DebugHudState;
import com.simsilica.thread.JobState;
import mythruna.SystemInfo;
import mythruna.client.GuiState;
import mythruna.client.view.AvatarState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudStatsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HudStatsState.class);
    private VersionedHolder<String> posText;
    private VersionedHolder<String> tileText;
    private VersionedHolder<String> velText;
    private VersionedHolder<String> timeOfDayText;
    private Vec3d lastPos = new Vec3d();
    private VersionedReference<Vec3d> posRef;
    private JobsTracker regularJobs;
    private JobsTracker priorityJobs;
    private JobsTracker backgroundJobs;
    private double lastAverageVelocity;
    private double averageVelocity;
    private int samples = 10;
    private LightingState time;
    private double lastTimeOfDay = Double.NEGATIVE_INFINITY;
    private Label tempHeader;

    protected void initialize(Application app) {
        this.posText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Pos", DebugHudState.Location.Right);
        this.tileText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Tile", DebugHudState.Location.Right);
        this.velText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Vel", DebugHudState.Location.Right);
        this.timeOfDayText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("ToD", DebugHudState.Location.Right);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.regularJobs = new JobsTracker("Regular", "regularWorkers");
        this.priorityJobs = new JobsTracker("High", "priorityWorkers");
        this.backgroundJobs = new JobsTracker("Low", "backgroundWorkers");
        this.time = (LightingState)this.getState(LightingState.class, true);
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(this.isEnabled());
        String buildDate = SystemInfo.getInstance().getBuildDate();
        this.tempHeader = new Label("Engine Test Build v" + buildDate + " - Graphics do not represent final quality.  <Press F1 for help>");
        this.tempHeader.setColor(ColorRGBA.Yellow);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        Node gui = ((GuiState)this.getState(GuiState.class, true)).getGuiRoot();
        gui.attachChild((Spatial)this.tempHeader);
        log.info("screenSize:" + ((GuiState)this.getState(GuiState.class, true)).getGuiSize());
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.tempHeader);
        this.tempHeader.getLocalTranslation().y = 900.0f;
        this.tempHeader.setLocalTranslation(this.tempHeader.getLocalTranslation());
    }

    protected void onDisable() {
        this.tempHeader.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            Vec3d pos = (Vec3d)this.posRef.get();
            this.posText.updateObject((Object)String.format("%.1f, %.1f, %.1f", pos.x, pos.y, pos.z));
            TileId tileId = TileId.fromWorld((Vec3d)pos);
            this.tileText.updateObject((Object)String.valueOf(tileId.getWorld(null)));
        }
        double dist = ((Vec3d)this.posRef.get()).distanceSq(this.lastPos);
        this.lastPos.set((Vec3d)this.posRef.get());
        double vel = 0.0;
        if (dist > 0.0) {
            vel = Math.sqrt(dist) / (double)tpf;
        }
        this.averageVelocity = (this.averageVelocity * (double)this.samples + vel) / (double)(this.samples + 1);
        if (Math.abs(this.lastAverageVelocity - this.averageVelocity) > 0.001) {
            this.velText.updateObject((Object)String.format("%.02f", this.averageVelocity));
            this.lastAverageVelocity = this.averageVelocity;
        }
        this.regularJobs.update();
        this.priorityJobs.update();
        this.backgroundJobs.update();
        double timeOfDay = (double)this.time.getTimeOfDay() + 0.5;
        if (timeOfDay != this.lastTimeOfDay) {
            this.lastTimeOfDay = timeOfDay;
            this.timeOfDayText.updateObject((Object)HudStatsState.timeToString(timeOfDay));
        }
    }

    public static String timeToString(double time) {
        int minutes = (int)(time * 12.0 * 60.0);
        return String.format("%02d:%02d", minutes / 60, minutes % 60);
    }

    private class JobsTracker {
        VersionedHolder<String> jobsText;
        VersionedReference<Integer> queuedRef;
        VersionedReference<Integer> activeRef;

        public JobsTracker(String name, String poolId) {
            this.jobsText = ((DebugHudState)HudStatsState.this.getState(DebugHudState.class)).createDebugValue(name, DebugHudState.Location.Right);
            JobState jobs = (JobState)HudStatsState.this.getState(poolId, JobState.class);
            this.queuedRef = jobs.createQueuedCountReference();
            this.activeRef = jobs.createActiveCountReference();
        }

        public void update() {
            if (this.queuedRef.update() || this.activeRef.update()) {
                this.jobsText.updateObject((Object)("Queued:" + this.queuedRef.get() + " Active:" + this.activeRef.get()));
            }
        }
    }
}

