/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mblock.BlocksResourceShapeFactory;
import com.simsilica.ext.mblock.SphereFactory;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.trans.PositionTransition3d;
import com.simsilica.mathd.trans.TransitionBuffer;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.state.DebugHudState;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.view.AvatarState;
import mythruna.client.view.GameSessionState;
import mythruna.client.view.SpatialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelViewState.class);
    private static final long VIS_DELAY = 100000000L;
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private SpatialFactory modelFactory;
    private GeometryFactory geomFactory;
    private Node objectRoot;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private TimeSource timeSource;
    private MobContainer mobs;
    private ModelContainer models;
    private LargeModelContainer largeModels;
    private LinkedList<MarkVisible> markerQueue = new LinkedList();
    private Vec3i modelCenter = new Vec3i();
    private Vec3i largeModelCenter = new Vec3i();
    private int gridRadius = 1;
    private ComponentFilter[][] gridFilters;
    private ComponentFilter[][] largeGridFilters;
    private Map<EntityId, Model> modelIndex = new HashMap<EntityId, Model>();
    private VersionedHolder<String> mobCount;
    private VersionedHolder<String> modelCount;
    private VersionedHolder<String> largeModelCount;
    private VersionedHolder<String> spatialCount;

    protected Spatial findPickedSpatial(Spatial spatial) {
        Long oid = (Long)spatial.getUserData("oid");
        if (oid != null) {
            return spatial;
        }
        if (spatial.getParent() != null) {
            return this.findPickedSpatial((Spatial)spatial.getParent());
        }
        return null;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Node getObjectRoot() {
        return this.objectRoot;
    }

    protected void initialize(Application app) {
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
        this.modelFactory = new SpatialFactory(this.geomFactory);
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.timeSource = ((GameSessionState)this.getState(GameSessionState.class)).getTimeSource();
        this.objectRoot = new Node("objectRoot");
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            this.mobCount = debug.createDebugValue("Mobs", DebugHudState.Location.Right);
            this.modelCount = debug.createDebugValue("Statics", DebugHudState.Location.Right);
            this.largeModelCount = debug.createDebugValue("Lobs", DebugHudState.Location.Right);
            this.spatialCount = debug.createDebugValue("Spatials", DebugHudState.Location.Right);
        }
        this.shapeFactory = new ShapeFactoryRegistry();
        this.shapeFactory.registerFactory(ShapeInfo.create((String)"sphere", (double)1.0, (EntityData)this.ed), (ShapeFactory)new SphereFactory());
        this.shapeFactory.setDefaultFactory((ShapeFactory)new BlocksResourceShapeFactory(this.ed));
        this.mobs = new MobContainer(this.ed);
        this.models = new ModelContainer(this.ed);
        this.largeModels = new LargeModelContainer(this.ed);
        this.resetModelFilter();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
    }

    protected void cleanup(Application app) {
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            debug.removeDebugValue("Mobs");
            debug.removeDebugValue("Statics");
            debug.removeDebugValue("Spatials");
        }
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.objectRoot);
        this.mobs.start();
        this.models.start();
        this.largeModels.start();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.mobs.update();
        this.models.update();
        this.largeModels.update();
        long time = this.timeSource.getTime();
        for (Mob mob : this.mobs.getArray()) {
            mob.update(time);
        }
        while (!this.markerQueue.isEmpty()) {
            MarkVisible marker = this.markerQueue.peek();
            if (marker.visibleTime > time) break;
            marker = this.markerQueue.poll();
            marker.update();
        }
        if (this.mobCount != null) {
            this.mobCount.setObject((Object)String.valueOf(this.mobs.size()));
            this.modelCount.setObject((Object)String.valueOf(this.models.size()));
            this.largeModelCount.setObject((Object)String.valueOf(this.largeModels.size()));
            this.spatialCount.setObject((Object)String.valueOf(this.modelIndex.size()));
        }
    }

    protected void onDisable() {
        log.info("shutting down");
        this.mobs.stop();
        this.models.stop();
        this.largeModels.stop();
        this.objectRoot.removeFromParent();
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.modelCenter.x != this.centerCell.x || this.modelCenter.z != this.centerCell.z) {
            this.modelCenter.x = this.centerCell.x;
            this.modelCenter.z = this.centerCell.z;
            this.resetModelFilter();
        }
        Vec3i largeCenter = GameConstants.LARGE_OBJECT_GRID.worldToCell(this.centerWorld.toVec3d());
        if (this.largeModelCenter.x != largeCenter.x || this.largeModelCenter.z != largeCenter.z) {
            this.largeModelCenter.x = largeCenter.x;
            this.largeModelCenter.z = largeCenter.z;
            this.resetLargeModelFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (Model m : this.models.getArray()) {
            m.updateRelativePosition();
        }
        for (Model m : this.largeModels.getArray()) {
            m.updateRelativePosition();
        }
    }

    protected void resetModelFilter() {
        int size = this.gridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.modelCenter.x - this.gridRadius;
        int zOffset = this.modelCenter.z - this.gridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.models.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected void resetLargeModelFilter() {
        int size = this.gridRadius * 2 + 1;
        this.largeGridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.largeModelCenter.x - this.gridRadius;
        int zOffset = this.largeModelCenter.z - this.gridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = GameConstants.LARGE_OBJECT_GRID.cellToId(xOffset + x, 0, zOffset + z);
                this.largeGridFilters[x][z] = filter = Filters.fieldEquals(LargeGridCell.class, (String)"cellId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.largeModels.setFilter(Filters.or(LargeGridCell.class, (ComponentFilter[])filters));
    }

    protected Spatial createModel(EntityId id, MBlockShape shape, Mass mass) {
        return this.modelFactory.createModel(id, shape, mass);
    }

    protected Model getModel(EntityId entityId, boolean create) {
        Model result = this.modelIndex.get(entityId);
        if (result == null && create) {
            result = new Model(entityId);
            this.modelIndex.put(entityId, result);
        }
        result.acquire();
        return result;
    }

    protected Model releaseModel(EntityId entityId) {
        Model result = this.modelIndex.get(entityId);
        if (result.release()) {
            this.modelIndex.remove(entityId);
        }
        return result;
    }

    private class LargeModelContainer
    extends EntityContainer<Model> {
        public LargeModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, LargeObject.class, LargeGridCell.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public Model[] getArray() {
            return (Model[])super.getArray();
        }

        protected Model addObject(Entity e) {
            log.info("LargeObject add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            Model object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(Model object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(Model object, Entity e) {
            log.info("LargeObject remove model for:" + e.getId());
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class ModelContainer
    extends EntityContainer<Model> {
        public ModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public Model[] getArray() {
            return (Model[])super.getArray();
        }

        protected Model addObject(Entity e) {
            log.info("add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            Model object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(Model object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(Model object, Entity e) {
            log.info("remove model for:" + e.getId());
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class MobContainer
    extends EntityContainer<Mob> {
        public MobContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, ShapeInfo.class});
        }

        public Mob[] getArray() {
            return (Mob[])super.getArray();
        }

        protected Mob addObject(Entity e) {
            log.info("add mob for:" + e.getId());
            Mob object = new Mob(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Mob object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((BodyPosition)e.get(BodyPosition.class));
            log.info("updateMob(" + e.getId() + ") pos:" + e.get(BodyPosition.class));
        }

        protected void removeObject(Mob object, Entity e) {
            log.info("remove mob for:" + e.getId());
            object.release();
        }
    }

    private class Mob {
        private Entity entity;
        private Model model;
        private BodyPosition pos;
        private TransitionBuffer<? extends PositionTransition3d> buffer;
        boolean visible;
        boolean forceInvisible;

        public Mob(Entity entity) {
            this.entity = entity;
            this.model = ModelViewState.this.getModel(entity.getId(), true);
            this.model.setDynamic(true);
        }

        public void setShape(ShapeInfo shapeInfo) {
            this.model.setShape(shapeInfo);
        }

        public void setPosition(BodyPosition pos) {
            if (this.pos == pos) {
                return;
            }
            pos.initialize(this.entity.getId(), 12);
            this.buffer = pos.getBuffer();
        }

        public void update(long time) {
            PositionTransition3d trans = (PositionTransition3d)this.buffer.getTransition(time);
            if (trans != null) {
                Vec3d pos = trans.getPosition(time, true);
                pos = pos.subtract(ModelViewState.this.centerWorld.toVec3d());
                this.model.spatial.setLocalTranslation(pos.toVector3f());
                this.model.spatial.setLocalRotation(trans.getRotation(time, true).toQuaternion());
                this.setVisible(trans.getVisibility(time));
            }
        }

        protected void setVisible(boolean f) {
            if (this.visible == f) {
                return;
            }
            log.info("setVisible(" + this.entity.getId() + ", " + f + ")");
            this.visible = f;
            if (this.visible) {
                this.model.markVisible();
            } else {
                this.model.markInvisible();
            }
        }

        public void release() {
            ModelViewState.this.releaseModel(this.entity.getId());
            this.model.setDynamic(false);
        }
    }

    private class Model {
        private EntityId entityId;
        private Spatial spatial;
        private ShapeInfo shapeInfo;
        private int useCount;
        private boolean dynamic;
        private SpawnPosition pos;
        private int visibleCount;

        public Model(EntityId entityId) {
            this.entityId = entityId;
        }

        public void acquire() {
            ++this.useCount;
        }

        public boolean release() {
            --this.useCount;
            if (this.useCount <= 0) {
                if (this.spatial != null) {
                    this.spatial.removeFromParent();
                }
                return true;
            }
            return false;
        }

        public void setShape(ShapeInfo shapeInfo) {
            if (Objects.equals(this.shapeInfo, shapeInfo)) {
                return;
            }
            this.shapeInfo = shapeInfo;
            if (this.spatial != null) {
                this.spatial.removeFromParent();
            }
            Mass mass = (Mass)ModelViewState.this.ed.getComponent(this.entityId, Mass.class);
            this.spatial = ModelViewState.this.createModel(this.entityId, (MBlockShape)ModelViewState.this.shapeFactory.createShape(shapeInfo, mass), mass);
            if (this.spatial != null) {
                ModelViewState.this.getObjectRoot().attachChild(this.spatial);
                this.resetVisibility();
            }
        }

        public void setPosition(SpawnPosition pos) {
            this.pos = pos;
            this.updateRelativePosition();
        }

        public void updateRelativePosition() {
            if (!this.dynamic) {
                if (this.pos == null) {
                    log.info("dynamic=false, pos=null, useCount=" + this.useCount);
                } else {
                    Vec3d loc = this.pos.getLocation();
                    loc = loc.subtract(ModelViewState.this.centerWorld.toVec3d());
                    this.spatial.setLocalTranslation(loc.toVector3f());
                    this.spatial.setLocalRotation(this.pos.getOrientation().toQuaternion());
                }
            }
        }

        public void setDynamic(boolean dynamic) {
            if (this.dynamic == dynamic) {
                return;
            }
            this.dynamic = dynamic;
            if (!dynamic) {
                this.updateRelativePosition();
            }
        }

        protected void markVisible() {
            ++this.visibleCount;
            this.resetVisibility();
        }

        protected void markInvisible() {
            --this.visibleCount;
            this.resetVisibility();
        }

        protected void resetVisibility() {
            log.info("resetVisibility():" + this.visibleCount);
            if (this.visibleCount > 0) {
                log.info("visible:" + this.entityId);
                this.spatial.setCullHint(Spatial.CullHint.Inherit);
            } else {
                log.info("invisible:" + this.entityId);
                this.spatial.setCullHint(Spatial.CullHint.Always);
            }
        }
    }

    private class MarkVisible {
        Model model;
        long visibleTime;

        public MarkVisible(Model model, long visibleTime) {
            this.model = model;
            this.visibleTime = visibleTime;
        }

        public void update() {
            log.info("MarkVisible.update() useCount:" + this.model.useCount + "  dynamic:" + this.model.dynamic);
            if (this.model.useCount == 1 && this.model.dynamic) {
                log.info("only dynamic... should already be visible.");
                return;
            }
            if (this.model.useCount == 0) {
                log.info("not used anymore");
                return;
            }
            log.info("Marking static object visible:" + this.model.entityId);
            this.model.markVisible();
        }
    }
}

