/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.state.CompositeAppState;
import mythruna.client.GuiState;
import mythruna.client.view.MapViewState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerMenuState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(PlayerMenuState.class);
    private Container window;
    private TabbedPanel tabs;

    public PlayerMenuState() {
        super(new AppState[]{new MapViewState()});
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void initialize(Application app) {
        MapViewState mapView = (MapViewState)this.getChild(MapViewState.class);
        mapView.setEnabled(this.isEnabled());
        this.window = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even));
        this.window.setLocalScale(1.5f);
        this.window.addChild((Node)new Label("Player Menu", new ElementId("window.title")), new Object[0]);
        this.tabs = (TabbedPanel)this.window.addChild((Node)new TabbedPanel(), new Object[0]);
        this.tabs.addTab("Character", (Panel)new Label("TBD"));
        this.tabs.addTab("Journal", (Panel)new Label("TBD"));
        this.tabs.addTab("Map", (Panel)mapView.getMap());
        this.tabs.setSelectedTab((TabbedPanel.Tab)this.tabs.getTabs().get(this.tabs.getTabs().size() - 1));
        float width = (float)app.getCamera().getWidth() / 1.5f;
        float height = (float)app.getCamera().getHeight() / 1.5f;
        Vector3f pref = this.window.getPreferredSize();
        this.window.setPreferredSize(new Vector3f(width *= 0.9f, height *= 0.9f, Math.max(pref.z, 10.0f)));
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        super.onEnable();
        this.getApplication().enqueue(() -> {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
        });
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        super.onDisable();
        this.window.removeFromParent();
    }
}

