/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.BodyMass;

public class SpatialFactory {
    private GeometryFactory geomFactory;
    private boolean debugCoG = false;

    public SpatialFactory(GeometryFactory geomFactory) {
        this.geomFactory = geomFactory;
    }

    public Spatial createModel(EntityId id, MBlockShape shape, Mass mass) {
        Spatial result;
        Part part = shape.getPart();
        if (part instanceof CellArrayPart) {
            result = this.createPartSpatial(id, (CellArrayPart)part, true, mass);
        } else if (part instanceof Group) {
            result = this.createPartSpatial(id, (Group)part, mass);
        } else {
            throw new IllegalArgumentException("Unhandled part type:" + shape.getPart());
        }
        return result;
    }

    protected Spatial createPartSpatial(EntityId id, Group group, Mass mass) {
        Node node = new Node("Object:" + id);
        if (this.debugCoG) {
            node.attachChild((Spatial)this.createBox(0.1f, ColorRGBA.Orange));
        }
        Node cogOffset = new Node("CoG:" + id);
        node.attachChild((Spatial)cogOffset);
        this.createPartSpatial(cogOffset, id, group, mass);
        return node;
    }

    protected Spatial createPartSpatial(Node parent, EntityId id, Group group, Mass mass) {
        for (Part child : group.getChildren()) {
            if (child instanceof CellArrayPart) {
                Spatial ps = this.createPartSpatial(id, (CellArrayPart)child, false, mass);
                ps.setLocalTranslation(child.getShapeRelativePosition().toVector3f());
                ps.setLocalRotation(child.getShapeRelativeOrientation().toQuaternion());
                parent.attachChild(ps);
                continue;
            }
            if (child instanceof Group) {
                this.createPartSpatial(parent, id, (Group)child, mass);
                continue;
            }
            throw new IllegalArgumentException("Unhandled part type:" + child);
        }
        return parent;
    }

    protected Spatial createPartSpatial(EntityId id, CellArrayPart part, boolean isRoot, Mass mass) {
        if (part.getCells() == null) {
            return this.createSphere(id, (float)part.getMass().getRadius(), mass);
        }
        Node node = new Node("Object:" + id);
        Node parts = new Node("Parts:" + id);
        node.attachChild((Spatial)parts);
        this.geomFactory.generateBlocks(parts, part.getCells(), (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        if (isRoot) {
            BodyMass bm = part.getMass();
            if (this.debugCoG) {
                node.attachChild((Spatial)this.createBox(0.1f, ColorRGBA.Red));
            }
        }
        parts.setLocalScale((float)part.getScale());
        parts.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        node.setUserData("oid", (Object)id.getId());
        return node;
    }

    public Spatial createSphere(EntityId id, float radius, Mass mass) {
        Sphere mesh = new Sphere(24, 24, radius);
        mesh.setTextureMode(Sphere.TextureMode.Projected);
        mesh.scaleTextureCoordinates(new Vector2f(4.0f, 2.0f));
        Geometry geom = new Geometry("Object:" + id, (Mesh)mesh);
        if (mass != null && mass.getMass() != 0.0) {
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(0.0f, 0.6f, 0.6f, 1.0f), true).getMaterial());
            Texture texture = GuiGlobals.getInstance().loadTexture("Interface/grid-shaded-labeled.png", true, true);
            geom.getMaterial().setTexture("DiffuseMap", texture);
        } else {
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(0.2f, 0.6f, 0.2f, 1.0f), true).getMaterial());
        }
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        geom.setUserData("oid", (Object)id.getId());
        return geom;
    }

    protected Geometry createBox(float size, ColorRGBA color) {
        Box box = new Box(size, size, size);
        Geometry geom = new Geometry("box", (Mesh)box);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(color, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setWireframe(true);
        return geom;
    }
}

