/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLeafBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 717360561052148665L;
    static Logger log = LoggerFactory.getLogger(TreeLeafBlockFactory.class);
    private static Vec3d min = new Vec3d(0.25, 0.25, 0.25);
    private static Vec3d max = new Vec3d(0.75, 0.75, 0.75);
    private static final int ATLAS_SIZE = 16;
    private float[][] yTexOffsets = new float[][]{{0.0f, 0.249f}, {0.25f, 0.49f}, {0.5f, 0.749f}, {0.75f, 0.99f}, {0.249f, 0.0f}, {0.49f, 0.25f}, {0.749f, 0.5f}, {0.99f, 0.75f}, {0.0f, 0.249f}, {0.25f, 0.49f}, {0.5f, 0.749f}, {0.75f, 0.99f}, {0.249f, 0.0f}, {0.49f, 0.25f}, {0.749f, 0.5f}, {0.99f, 0.75f}};
    private float[][] xTexOffsets = new float[][]{{0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}};
    private GeomPart[] template = new GeomPart[5];

    public TreeLeafBlockFactory(MaterialType mt) {
        GeomPart part;
        float height = 1.8f;
        float width = 0.9f;
        float xCenter = 0.5f;
        float zCenter = 0.5f;
        float yBase = -0.4f;
        float offset = 0.05f;
        float nest = 0.1f;
        float angle = 0.5105088f;
        float cos = FastMath.cos((float)angle);
        float sin = FastMath.sin((float)angle);
        Vector3f norm = new Vector3f(cos, cos, sin);
        norm.normalize();
        Vector3f norm2 = new Vector3f(cos, 0.0f, sin);
        norm2.normalize();
        this.template[0] = part = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{xCenter + width - offset - nest, yBase, zCenter + width + offset + nest, xCenter - width - offset + nest, yBase, zCenter - width + offset - nest, xCenter - width + nest, yBase + height, zCenter - width - nest, xCenter + width - nest, yBase + height, zCenter + width + nest});
        part.setNormals(new float[]{norm2.x, -norm2.y, norm2.z, -norm2.z, -norm2.y, -norm2.x, -norm.z, norm.y, -norm.x, norm.x, norm.y, norm.z});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        this.template[1] = part = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{xCenter - width + offset + nest, yBase, zCenter - width - offset - nest, xCenter + width + offset - nest, yBase, zCenter + width - offset + nest, xCenter + width - nest, yBase + height, zCenter + width + nest, xCenter - width + nest, yBase + height, zCenter - width - nest});
        part.setNormals(new float[]{-norm2.x, -norm2.y, -norm2.z, norm2.z, -norm2.y, norm2.x, norm.z, norm.y, norm.x, -norm.x, norm.y, -norm.z});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        this.template[2] = part = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{xCenter + width + offset + nest, yBase, zCenter - width + offset + nest, xCenter - width + offset - nest, yBase, zCenter + width + offset - nest, xCenter - width - nest, yBase + height, zCenter + width - nest, xCenter + width + nest, yBase + height, zCenter - width + nest});
        part.setNormals(new float[]{norm2.z, -norm2.y, -norm2.x, -norm2.x, -norm2.y, norm2.z, -norm.x, norm.y, norm.z, norm.z, norm.y, -norm.x});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        this.template[3] = part = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{xCenter - width - offset - nest, yBase, zCenter + width - offset - nest, xCenter + width - offset + nest, yBase, zCenter - width - offset + nest, xCenter + width + nest, yBase + height, zCenter - width + nest, xCenter - width - nest, yBase + height, zCenter + width - nest});
        part.setNormals(new float[]{-norm2.z, -norm2.y, norm2.x, norm2.x, -norm2.y, -norm2.z, norm.x, norm.y, -norm.z, -norm.z, norm.y, norm.x});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        this.template[4] = part = new GeomPart(mt, -1, true);
        float topWidth = 0.5f;
        float yTop = 0.5f;
        part.setCoords(new float[]{xCenter - topWidth, yTop, zCenter + topWidth, xCenter + topWidth, yTop, zCenter + topWidth, xCenter + topWidth, yTop, zCenter - topWidth, xCenter - topWidth, yTop, zCenter - topWidth});
        part.setNormals(new float[]{-norm.z, norm.y, norm.x, norm.x, norm.y, norm.z, norm.z, norm.y, -norm.x, -norm.x, norm.y, -norm.z});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        int texIndex = (int)(buffer.nextRandom() * 16.0);
        for (GeomPart p : this.template) {
            p = p.clone();
            p.setTexCoords(new float[]{this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]});
            buffer.addPart(i, j, k, p);
            texIndex = (texIndex + 1) % 16;
        }
        return 5;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 0.75;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return min;
    }

    public Vec3d getMax() {
        return max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TreeLeafBlockFactory other = (TreeLeafBlockFactory)o;
        return Arrays.equals(other.template, this.template);
    }

    public int hashCode() {
        return Arrays.hashCode(this.template);
    }

    public BlockFactory rotate(int dirDelta) {
        return this;
    }
}

