/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.google.common.base.Supplier;
import com.jme3.network.HostedConnection;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.ArraySerializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rpc.RpcHostedService;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.bpos.mphys.BodyPositionPublisher;
import com.simsilica.bpos.mphys.LargeGridIndexSystem;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.Name;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.EntityUpdater;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ethereal.NetworkStateListener;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mblock.BlocksResourceShapeFactory;
import com.simsilica.ext.mblock.SphereFactory;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.ext.mphys.net.ZoneNetworkSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mworld.World;
import com.simsilica.mworld.net.server.WorldHostedService;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameLoop;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.common.DecaySystem;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import mythruna.GameConstants;
import mythruna.cmd.CommandSystem;
import mythruna.es.ActivationInput;
import mythruna.es.MovementInput;
import mythruna.net.server.AccountHostedService;
import mythruna.net.server.GameSessionHostedService;
import mythruna.shell.CommandShell;
import mythruna.shell.Echo;
import mythruna.shell.Help;
import mythruna.shell.ShellCommand;
import mythruna.shell.ShellService;
import mythruna.sim.ActivationSystem;
import mythruna.sim.MovementSystem;
import mythruna.sim.PathRecorderSystem;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameServer {
    static Logger log = LoggerFactory.getLogger(GameServer.class);
    private WorldManager worldManager;
    private String description;
    private Server server;
    private GameSystemManager systems;
    private GameLoop loop;

    public GameServer(WorldManager worldManager, Supplier<String> tokenSupplier, InetAddress hostAddress, int port, String description) throws IOException {
        this.worldManager = worldManager;
        this.description = description;
        if (worldManager.getInfo().getSpawnPoint() == null) {
            log.error("World has no spawn point:" + worldManager.getInfo());
        }
        Serializer.initialize();
        this.systems = new GameSystemManager();
        this.loop = new GameLoop(this.systems);
        this.systems.register(WorldManager.class, (Object)worldManager);
        this.server = Network.createServer((String)"Mythruna", (int)20210103, (int)port, (int)port);
        this.server.addChannel(port + 0 + 1);
        this.server.addChannel(port + 1 + 1);
        this.server.addChannel(port + 2 + 1);
        this.server.getServices().addServices(new HostedService[]{new RpcHostedService(), new RmiHostedService(), new ChatHostedService(0), new GameSessionHostedService(this.systems)});
        EtherealHost ethereal = new EtherealHost(GameConstants.OBJECT_PROTOCOL, GameConstants.ZONE_GRID, GameConstants.ZONE_RADIUS);
        ethereal.getZones().setSupportLargeObjects(true);
        ethereal.setTimeSource(new TimeSource(){

            public long getTime() {
                return GameServer.this.systems.getStepTime().getUnlockedTime(System.nanoTime());
            }
        });
        this.server.getServices().addService((HostedService)ethereal);
        ObservableEntityData ed = worldManager.getEntityData();
        this.systems.register(EntityData.class, (Object)ed);
        this.server.getServices().addService((HostedService)new EntityDataHostedService(1, ed));
        World world = worldManager.getWorld();
        this.systems.register(World.class, (Object)world);
        this.server.getServices().addService((HostedService)new WorldHostedService(world, 2));
        this.systems.addSystem((GameSystem)new LargeGridIndexSystem(GameConstants.LARGE_OBJECT_GRID));
        this.systems.addSystem((GameSystem)new EntityUpdater((EntityDataHostedService)this.server.getServices().getService(EntityDataHostedService.class)));
        this.server.getServices().addService((HostedService)new AccountHostedService((EntityData)ed, tokenSupplier));
        this.systems.addSystem((GameSystem)new DecaySystem());
        ShapeFactoryRegistry shapeFactory = new ShapeFactoryRegistry();
        shapeFactory.registerFactory(ShapeInfo.create((String)"sphere", (double)1.0, (EntityData)ed), (ShapeFactory)new SphereFactory());
        shapeFactory.setDefaultFactory((ShapeFactory)new BlocksResourceShapeFactory((EntityData)ed));
        this.systems.register(ShapeFactory.class, (Object)shapeFactory);
        EntityBodyFactory bodyFactory = new EntityBodyFactory((EntityData)ed, GameConstants.DEFAULT_GRAVITY, (ShapeFactory)shapeFactory);
        MPhysSystem mphys = new MPhysSystem(GameConstants.PHYSICS_GRID, bodyFactory);
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        mphys.setCollisionSystem((CollisionSystem)new MBlockCollisionSystem(worldManager.getPhysicalWorld(), colliders));
        this.systems.register(MPhysSystem.class, (Object)mphys);
        this.systems.register(PhysicsSpace.class, (Object)mphys.getPhysicsSpace());
        this.systems.register(EntityBodyFactory.class, (Object)bodyFactory);
        this.systems.register(ZoneNetworkSystem.class, (Object)new ZoneNetworkSystem(ethereal.getZones()));
        this.systems.addSystem((GameSystem)new BodyPositionPublisher());
        this.systems.register(MovementSystem.class, (Object)new MovementSystem());
        this.systems.register(ActivationSystem.class, (Object)new ActivationSystem());
        this.systems.register(PathRecorderSystem.class, (Object)new PathRecorderSystem());
        this.systems.register(ShellService.class, (Object)new ShellService());
        this.setupShell((ShellService)this.systems.get(ShellService.class));
        this.systems.register(CommandSystem.class, (Object)new CommandSystem());
        this.registerSerializers();
    }

    protected void registerSerializers() {
        Serializer.registerClass(Quatd.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Vec3d.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Name.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(SpawnPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(BodyPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ShapeInfo.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Mass.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Array.newInstance(EntityComponent.class, 0).getClass(), (Serializer)new ArraySerializer());
        Serializer.registerClass(LargeObject.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LargeGridCell.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(MovementInput.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ActivationInput.class, (Serializer)new FieldSerializer());
    }

    protected void setupShell(ShellService shellService) {
        CommandShell global = shellService.getGlobalShell();
        global.addCommand("help", (ShellCommand)new Help());
        global.addCommand("echo", (ShellCommand)new Echo());
        global.put("systems", (Object)this.systems);
    }

    public Server getServer() {
        return this.server;
    }

    public GameSystemManager getSystems() {
        return this.systems;
    }

    public void start() {
        log.info("Starting game server...");
        this.server.start();
        this.loop.start(true);
        log.info("Game server started.");
    }

    public void close(String kickMessage) {
        log.info("Stopping game server..." + kickMessage);
        this.loop.stop();
        if (kickMessage != null) {
            for (HostedConnection conn : this.server.getConnections()) {
                conn.close(kickMessage);
            }
        }
        this.server.close();
        if (this.systems.isInitialized()) {
            this.systems.stop();
            this.systems.terminate();
        }
        log.info("Game server stopped.");
    }

    public void close() {
        this.close(null);
    }

    public void logStats() {
        EtherealHost host = (EtherealHost)this.server.getServices().getService(EtherealHost.class);
        for (HostedConnection conn : this.server.getConnections()) {
            log.info("Client[" + conn.getId() + "] address:" + conn.getAddress());
            NetworkStateListener listener = host.getStateListener(conn);
            if (listener == null) {
                log.info("[" + conn.getId() + "] No stats");
                continue;
            }
            log.info("[" + conn.getId() + "] Ping time: " + (double)listener.getConnectionStats().getAveragePingTime() / 1000000.0 + " ms");
            String miss = String.format("%.02f", listener.getConnectionStats().getAckMissPercent());
            log.info("[" + conn.getId() + "] Ack miss: " + miss + "%");
            log.info("[" + conn.getId() + "] Average msg size: " + listener.getConnectionStats().getAverageMessageSize() + " bytes");
        }
    }
}

