/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.LeafChangeListenerSupport;
import com.simsilica.mworld.base.WorldCellData;
import com.simsilica.mworld.db.LeafDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeafWorld
implements World {
    static Logger log = LoggerFactory.getLogger(DefaultLeafWorld.class);
    private LeafDb leafDb;
    private int yMax;
    private List<CellChangeListener> cellListeners = new ArrayList<CellChangeListener>();
    private CellChangeListener[] cellListenerArray;
    private CellChangeListener[] emptyCellListenerArray = new CellChangeListener[0];
    private LeafChangeListenerSupport leafListeners = new LeafChangeListenerSupport();

    public DefaultLeafWorld(LeafDb leafDb, int yMax) {
        this.leafDb = leafDb;
        this.yMax = yMax;
    }

    @Override
    public void addCellChangeListener(CellChangeListener l) {
        this.cellListeners.add(l);
        this.cellListenerArray = null;
    }

    @Override
    public void removeCellChangeListener(CellChangeListener l) {
        this.cellListeners.remove(l);
        this.cellListenerArray = null;
    }

    @Override
    public void addLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.add(l);
    }

    @Override
    public void removeLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.remove(l);
    }

    @Override
    public int getMaxY() {
        return this.yMax;
    }

    protected CellChangeListener[] getCellListenerArray() {
        if (this.cellListenerArray == null) {
            this.cellListenerArray = this.cellListeners.toArray(this.emptyCellListenerArray);
        }
        return this.cellListenerArray;
    }

    protected void fireCellChanged(CellChangeEvent event) {
        for (CellChangeListener l : this.getCellListenerArray()) {
            l.cellChanged(event);
        }
    }

    @Override
    public int setWorldCell(Vec3d world, int type) {
        LeafId id = LeafId.fromWorld(world);
        LeafData leaf = this.getLeaf(id);
        if (leaf == null) {
            return -1;
        }
        WorldCellData data = new WorldCellData(leaf, this);
        int x = Coordinates.worldToCell(world.x);
        int y = Coordinates.worldToCell(world.y);
        int z = Coordinates.worldToCell(world.z);
        data.setCell(x, y, z, type);
        MaskUtils.recalculateSideMasks((CellData)data, (int)x, (int)y, (int)z, (int)-1);
        int value = data.getCell(x, y, z);
        for (LeafData mod : data.getModified()) {
            this.leafDb.storeLeaf(mod);
        }
        for (LeafData mod : data.getModified()) {
            this.leafListeners.fireLeafChanged(mod.getInfo().leafId, mod.getInfo().version.getVersion());
        }
        for (CellChangeEvent event : data.getChanges()) {
            this.fireCellChanged(event);
        }
        return value;
    }

    @Override
    public int getWorldCell(Vec3d world) {
        LeafId id = LeafId.fromWorld(world);
        LeafData leaf = this.getLeaf(id);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell(world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell(world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell(world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    @Override
    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld(worldLocation));
    }

    @Override
    public LeafData getLeaf(LeafId leafId) {
        return this.leafDb.loadLeaf(leafId);
    }

    @Override
    public LightData getLight(LeafId leafId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FluidData getFluid(LeafId leafId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }
}

