@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  client-java8 startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and CLIENT_JAVA8_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-ea" "-Xmx3g" "-Xms512m" "-XX:MaxDirectMemorySize=3g"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\client-1.0.0.jar;%APP_HOME%\lib\guava-19.0.jar;%APP_HOME%\lib\jme3-desktop-3.3.0-stable.jar;%APP_HOME%\lib\jme3-effects-3.3.0-stable.jar;%APP_HOME%\lib\jme3-plugins-3.3.0-stable.jar;%APP_HOME%\lib\jme3-lwjgl-3.3.0-stable.jar;%APP_HOME%\lib\slf4j-api-1.7.32.jar;%APP_HOME%\lib\log4j-api-2.15.0.jar;%APP_HOME%\lib\log4j-core-2.15.0.jar;%APP_HOME%\lib\groovy-all-2.4.11.jar;%APP_HOME%\lib\lemur-1.16.0-SNAPSHOT.jar;%APP_HOME%\lib\lemur-proto-1.12.1-SNAPSHOT.jar;%APP_HOME%\lib\lemur-props-1.1.1.jar;%APP_HOME%\lib\sim-math-1.4.2-SNAPSHOT.jar;%APP_HOME%\lib\sio2-1.6.1-SNAPSHOT.jar;%APP_HOME%\lib\sim-ethereal-1.6.1-SNAPSHOT.jar;%APP_HOME%\lib\zay-es-1.3.3-SNAPSHOT.jar;%APP_HOME%\lib\zay-es-net-1.4.4-SNAPSHOT.jar;%APP_HOME%\lib\sim-fx-1.0.1-SNAPSHOT.jar;%APP_HOME%\lib\gson-2.8.6.jar;%APP_HOME%\lib\bpos-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\fsm-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\core-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\server-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\blockset-1.0.0.jar;%APP_HOME%\lib\log4j-slf4j-impl-2.15.0.jar;%APP_HOME%\lib\hsqldb-2.5.1.jar;%APP_HOME%\lib\lwjgl-2.9.3.jar;%APP_HOME%\lib\mphys-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\sio2-mphys-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\fractal-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mblock-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mworld-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mblock-physb-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\sio2-mblock-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\lwjgl-platform-2.9.3-natives-windows.jar;%APP_HOME%\lib\lwjgl-platform-2.9.3-natives-linux.jar;%APP_HOME%\lib\lwjgl-platform-2.9.3-natives-osx.jar;%APP_HOME%\lib\jinput-2.0.5.jar;%APP_HOME%\lib\jutils-1.0.0.jar;%APP_HOME%\lib\jinput-platform-2.0.5-natives-linux.jar;%APP_HOME%\lib\jinput-platform-2.0.5-natives-windows.jar;%APP_HOME%\lib\jinput-platform-2.0.5-natives-osx.jar;%APP_HOME%\lib\jme3-core-3.6.0-SNAPSHOT.jar;%APP_HOME%\lib\jme3-networking-3.6.0-SNAPSHOT.jar

@rem Execute client-java8
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CLIENT_JAVA8_OPTS%  -classpath "%CLASSPATH%" mythruna.client.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CLIENT_JAVA8_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CLIENT_JAVA8_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
