/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.core.VersionedReference;

public class DefaultRangedValueModel
implements RangedValueModel {
    private long version;
    private double min;
    private double max;
    private double value;

    public DefaultRangedValueModel() {
        this(0.0, 100.0, 0.0);
    }

    public DefaultRangedValueModel(double min, double max, double value) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.checkRange();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public Double getObject() {
        return this.getValue();
    }

    @Override
    public VersionedReference<Double> createReference() {
        return new VersionedReference<Double>(this);
    }

    protected void checkRange() {
        this.value = Math.max(this.min, this.value);
        this.value = Math.min(this.max, this.value);
    }

    @Override
    public void setValue(double value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        ++this.version;
        this.checkRange();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setPercent(double v) {
        double range = this.max - this.min;
        double projected = this.min + range * v;
        this.setValue(projected);
    }

    @Override
    public double getPercent() {
        double range = this.max - this.min;
        if (range == 0.0) {
            return 0.0;
        }
        double part = this.getValue() - this.min;
        return part / range;
    }

    @Override
    public void setMaximum(double max) {
        if (this.max == max) {
            return;
        }
        this.max = max;
        ++this.version;
        this.checkRange();
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public void setMinimum(double min) {
        if (this.min == min) {
            return;
        }
        this.min = min;
        ++this.version;
        this.checkRange();
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    public String toString() {
        return this.getClass().getName() + "[value=" + this.value + ", min=" + this.min + ", max=" + this.max + "]";
    }
}

