/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.MaskUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightUtils {
    static Logger log = LoggerFactory.getLogger(LightUtils.class);
    public static final int DIRECT_SUN = LightUtils.toLight(15, 0, 0, 0);
    public static final int SOLID = -65536;
    public static int MAX_LIGHT_EFFECT = 14;

    public static int toLight(int sun, int r, int g, int b) {
        return sun << 12 | r << 8 | g << 4 | b;
    }

    public static int sun(int light) {
        return light >> 12 & 0xF;
    }

    public static int red(int light) {
        return light >> 8 & 0xF;
    }

    public static int green(int light) {
        return light >> 4 & 0xF;
    }

    public static int blue(int light) {
        return light & 0xF;
    }

    public static int localLight(int light) {
        return light & 0xFFF;
    }

    public static int getLight(int value) {
        return value & 0xFFFF;
    }

    public static int localMax(int light) {
        int r = LightUtils.red(light);
        int g = LightUtils.green(light);
        int b = LightUtils.blue(light);
        return Math.max(r, Math.max(g, b));
    }

    public static int getBlockLight(int type) {
        BlockType bt = BlockTypeIndex.get(type);
        return bt == null ? (short)0 : bt.getLight();
    }

    public static int mergeLights(int light1, int light2) {
        if (light1 == light2) {
            return light1;
        }
        if (light1 == -65536) {
            return light2;
        }
        if (light2 == -65536) {
            return light1;
        }
        int s = Math.max(LightUtils.sun(light1), LightUtils.sun(light2));
        int r = Math.max(LightUtils.red(light1), LightUtils.red(light2));
        int g = Math.max(LightUtils.green(light1), LightUtils.green(light2));
        int b = Math.max(LightUtils.blue(light1), LightUtils.blue(light2));
        return LightUtils.toLight(s, r, g, b);
    }

    public static boolean isDecreasing(int light1, int light2) {
        if (light2 == -65536) {
            return true;
        }
        if (light1 == -65536) {
            return false;
        }
        if (LightUtils.sun(light2) < LightUtils.sun(light1)) {
            return true;
        }
        if (LightUtils.red(light2) < LightUtils.red(light1)) {
            return true;
        }
        if (LightUtils.green(light2) < LightUtils.green(light1)) {
            return true;
        }
        return LightUtils.blue(light2) < LightUtils.blue(light1);
    }

    public static boolean anyMatch(int light1, int light2) {
        if (light1 == light2) {
            return true;
        }
        if (light1 == -65536 || light2 == -65536) {
            return false;
        }
        if (LightUtils.sun(light1) == LightUtils.sun(light2)) {
            return true;
        }
        if (LightUtils.red(light1) == LightUtils.red(light2)) {
            return true;
        }
        if (LightUtils.green(light1) == LightUtils.green(light2)) {
            return true;
        }
        return LightUtils.blue(light1) == LightUtils.blue(light2);
    }

    private static int nextSun(int current, Direction dir) {
        int nextVal = current;
        if (current >= 14) {
            if (dir != Direction.Down) {
                --nextVal;
            }
        } else {
            nextVal = dir == Direction.Up ? (current > 10 ? (nextVal -= 4) : (nextVal -= 3)) : --nextVal;
        }
        return nextVal < 0 ? 0 : nextVal;
    }

    public static boolean isLightPassable(BlockType cell, Direction dir, BlockType other) {
        if (cell != null && cell.isSolid(dir) && cell.getTransparency(dir) == 0.0) {
            return false;
        }
        if (other == null) {
            return true;
        }
        Direction back = dir.reverse();
        return !other.isSolid(back) || other.getTransparency(back) != 0.0;
    }

    public static int filter(double filter, int light) {
        if (filter > 0.99) {
            return light;
        }
        if (filter > 0.9) {
            if (light == 15) {
                return 14;
            }
            return light;
        }
        return (int)Math.round(filter * (double)light);
    }

    public static int attenuateLight(int light, BlockType from, Direction dir, BlockType to) {
        if (to != null && to.isSolid() && !to.isTransparent()) {
            return -65536;
        }
        if (!LightUtils.isLightPassable(from, dir, to)) {
            return 0;
        }
        double filter = 1.0;
        if (from != null) {
            filter = from.getTransparency(dir);
        }
        int s = LightUtils.filter(filter, LightUtils.sun(light));
        int r = LightUtils.filter(filter, LightUtils.red(light));
        int g = LightUtils.filter(filter, LightUtils.green(light));
        int b = LightUtils.filter(filter, LightUtils.blue(light));
        s = LightUtils.nextSun(s, dir);
        if (r > 0) {
            --r;
        }
        if (g > 0) {
            --g;
        }
        if (b > 0) {
            --b;
        }
        return LightUtils.toLight(s, r, g, b);
    }

    public static void resetLighting(int topLight, CellData cells, CellData lights, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                int val;
                int light = topLight;
                boolean lit = true;
                BlockType lastType = null;
                for (int y = yEnd - 1; y >= yStart && (val = cells.getCell(x, y, z, -1)) != -1; --y) {
                    BlockType type = MaskUtils.getBlockType(val);
                    if (lit) {
                        int attenuated;
                        light = attenuated = LightUtils.attenuateLight(light, lastType, Direction.Down, type);
                        lastType = type;
                        lit = LightUtils.getLight(light) != 0;
                    } else {
                        light = type != null && type.isSolid() && !type.isTransparent() ? -65536 : 0;
                    }
                    lights.setCell(x, y, z, light);
                }
            }
        }
    }

    public static void recalculateLighting(CellData cells, CellData lights, int arraySize) {
        LightUtils.recalculateLighting(cells, lights, 0, 0, 0, arraySize, arraySize, arraySize);
    }

    public static void recalculateLighting(CellData cells, CellData lights, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        LinkedList<LightSeed> seeds = new LinkedList<LightSeed>();
        LightUtils.resetLighting(DIRECT_SUN, cells, lights, xStart, yStart, zStart, xEnd, yEnd, zEnd);
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                int val;
                for (int y = yEnd - 1; y >= yStart && (val = cells.getCell(x, y, z, -1)) != -1; --y) {
                    int sun;
                    int existing;
                    BlockType type = MaskUtils.getBlockType(val);
                    int emit = 0;
                    if (type != null && (emit = type.getLight()) == 0 && type.isSolid() && !type.isTransparent() || (existing = lights.getCell(x, y, z, -1)) == -1 || existing == -65536 && emit == 0 || existing == DIRECT_SUN && emit == 0) continue;
                    int maxSun = sun = existing;
                    for (Direction dir : Direction.values()) {
                        Direction back;
                        BlockType neighbor;
                        int attenuatedSun;
                        int neighborSun = lights.getCell(x, y, z, dir, -1);
                        if (neighborSun == -1 || (attenuatedSun = LightUtils.attenuateLight(neighborSun, neighbor = MaskUtils.getBlockType(cells.getCell(x, y, z, dir, 0)), back = dir.reverse(), type)) <= maxSun) continue;
                        maxSun = attenuatedSun;
                    }
                    if (maxSun > sun) {
                        emit = LightUtils.mergeLights(emit, maxSun);
                    }
                    if (emit <= 0) continue;
                    seeds.add(new LightSeed(x, y, z, emit));
                }
            }
        }
        LightUtils.propagateSeeds(cells, lights, seeds, false);
    }

    public static final int propagateSeeds(CellData cells, CellData lights, LinkedList<LightSeed> seeds, boolean clamp) {
        if (log.isTraceEnabled()) {
            log.trace("Processing " + seeds.size() + " initial seeds.");
        }
        int initialSize = seeds.size();
        int counter = 0;
        HashMap visited = new HashMap();
        while (!seeds.isEmpty()) {
            int newLight;
            LightSeed seed = seeds.removeFirst();
            int light = lights.getCell(seed.x, seed.y, seed.z, -1);
            if (light == -1 || (newLight = LightUtils.mergeLights(light, seed.light)) == light) continue;
            lights.setCell(seed.x, seed.y, seed.z, newLight);
            BlockType source = MaskUtils.getBlockType(cells.getCell(seed.x, seed.y, seed.z, 0));
            for (Direction dir : Direction.values()) {
                int predict;
                int existing;
                BlockType type;
                int attenuated;
                int val;
                if (seed.dir == dir.reverse()) {
                    // empty if block
                }
                if ((val = cells.getCell(seed.x, seed.y, seed.z, dir, -1)) == -1 || (attenuated = LightUtils.attenuateLight(newLight, source, dir, type = MaskUtils.getBlockType(val))) <= 0 || (existing = lights.getCell(seed.x, seed.y, seed.z, dir, -1)) == -1 || (predict = LightUtils.mergeLights(existing, attenuated)) == existing) continue;
                seeds.add(new LightSeed(seed.x, seed.y, seed.z, dir, attenuated));
            }
            if (++counter <= 500000) continue;
            log.warn("Counter overrun:" + counter + "  Original seeds:" + initialSize, new Throwable("stack"));
            break;
        }
        if (log.isTraceEnabled()) {
            log.trace(counter + " seed iterations");
        }
        return counter;
    }

    public static int propagateBorders(CellData cells, CellData lights, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        BlockType type;
        BlockType from;
        int att;
        int predict;
        int att2;
        int predict2;
        int y;
        if (log.isTraceEnabled()) {
            log.trace("propagateBorders(" + xStart + ", " + yStart + ", " + zStart + ", " + xEnd + ", " + yEnd + ", " + zEnd + ")");
        }
        LinkedList<LightSeed> seeds = new LinkedList<LightSeed>();
        for (int x = xStart; x < xEnd; ++x) {
            for (y = yStart; y < yEnd; ++y) {
                BlockType type2;
                BlockType from2;
                int nExisting = lights.getCell(x, y, zStart);
                int nValue = cells.getCell(x, y, zStart);
                int n = lights.getCell(x, y, zStart - 1);
                int nPrev = cells.getCell(x, y, zStart - 1, 0);
                if (nValue != -1 && (predict2 = LightUtils.mergeLights(nExisting, att2 = LightUtils.attenuateLight(n, from2 = MaskUtils.getBlockType(nPrev), Direction.South, type2 = MaskUtils.getBlockType(nValue)))) != nExisting) {
                    seeds.add(new LightSeed(x, y, zStart, Direction.South, att2));
                }
                int sExisting = lights.getCell(x, y, zEnd - 1);
                int sValue = cells.getCell(x, y, zEnd - 1);
                int s = lights.getCell(x, y, zEnd);
                int sPrev = cells.getCell(x, y, zEnd, 0);
                if (sValue == -1 || (predict = LightUtils.mergeLights(sExisting, att = LightUtils.attenuateLight(s, from = MaskUtils.getBlockType(sPrev), Direction.North, type = MaskUtils.getBlockType(sValue)))) == sExisting) continue;
                seeds.add(new LightSeed(x, y, zEnd - 1, Direction.North, att));
            }
        }
        for (int z = zStart; z < zEnd; ++z) {
            for (y = yStart; y < yEnd; ++y) {
                BlockType type3;
                BlockType from3;
                int wExisting = lights.getCell(xStart, y, z);
                int wValue = cells.getCell(xStart, y, z);
                int w = lights.getCell(xStart - 1, y, z);
                int wPrev = cells.getCell(xStart - 1, y, z, 0);
                if (wValue != -1 && (predict2 = LightUtils.mergeLights(wExisting, att2 = LightUtils.attenuateLight(w, from3 = MaskUtils.getBlockType(wPrev), Direction.East, type3 = MaskUtils.getBlockType(wValue)))) != wExisting) {
                    seeds.add(new LightSeed(xStart, y, z, Direction.East, att2));
                }
                int eExisting = lights.getCell(xEnd - 1, y, z);
                int eValue = cells.getCell(xEnd - 1, y, z);
                int e = lights.getCell(xEnd, y, z);
                int ePrev = cells.getCell(xEnd, y, z, 0);
                if (eValue == -1 || (predict = LightUtils.mergeLights(eExisting, att = LightUtils.attenuateLight(e, from = MaskUtils.getBlockType(ePrev), Direction.West, type = MaskUtils.getBlockType(eValue)))) == eExisting) continue;
                seeds.add(new LightSeed(xEnd - 1, y, z, Direction.West, att));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Propagating " + seeds.size() + " border seeds.");
        }
        return LightUtils.propagateSeeds(cells, lights, seeds, true);
    }

    public static LightSeed calculateSeed(CellData cells, CellData light, int x, int y, int z, int originalLight, int newLight) {
        if (log.isTraceEnabled()) {
            log.trace("calculateSeed(" + x + ", " + y + ", " + z + ", " + Integer.toHexString(originalLight) + ", " + Integer.toHexString(newLight) + ")");
        }
        int sourceLight = newLight;
        BlockType sourceType = MaskUtils.getBlockType(cells.getCell(x, y, z, 0));
        if (sourceLight <= 0 && sourceType != null && sourceType.getLight() > 0) {
            if (log.isTraceEnabled()) {
                log.trace("calculating see for emissive cell:" + Integer.toHexString(sourceType.getLight()));
            }
            sourceLight = sourceType.getLight();
        }
        int bestLight = sourceLight;
        Object sunDir = null;
        for (Direction dir : Direction.values()) {
            int existing = light.getCell(x, y, z, dir, -1);
            int val = cells.getCell(x, y, z, dir, -1);
            if (val == -1) continue;
            BlockType type = MaskUtils.getBlockType(val);
            if (type != null && type.getLight() > 0 && existing <= 0) {
                existing = type.getLight();
            }
            if (existing <= 0) continue;
            int attenuated = LightUtils.attenuateLight(existing, type, dir.reverse(), sourceType);
            bestLight = LightUtils.mergeLights(bestLight, attenuated);
        }
        if (bestLight != originalLight) {
            return new LightSeed(x, y, z, bestLight);
        }
        return null;
    }

    public static List<Vec3i> subtractLight(CellData cells, CellData lights, int x, int y, int z, int start) {
        if (log.isTraceEnabled()) {
            log.trace("subtractLight(" + x + ", " + y + ", " + z + ", " + Integer.toHexString(start));
        }
        if (start == 0 || start == -65536) {
            return Collections.emptyList();
        }
        LinkedList<LightSeed> seeds = new LinkedList<LightSeed>();
        seeds.add(new LightSeed(x, y, z, start));
        ArrayList<Vec3i> removed = new ArrayList<Vec3i>();
        int counter = 0;
        while (!seeds.isEmpty()) {
            LightSeed seed = (LightSeed)seeds.removeFirst();
            int light = lights.getCell(seed.x, seed.y, seed.z, -1);
            if (light == -1) continue;
            if (log.isTraceEnabled()) {
                log.trace("  seed:" + seed + "  existing:" + Integer.toHexString(light));
            }
            if (light == -65536 || light == 0) continue;
            int sSeed = LightUtils.sun(seed.light);
            int rSeed = LightUtils.red(seed.light);
            int gSeed = LightUtils.green(seed.light);
            int bSeed = LightUtils.blue(seed.light);
            int s = LightUtils.sun(light);
            int r = LightUtils.red(light);
            int g = LightUtils.green(light);
            int b = LightUtils.blue(light);
            boolean warn = false;
            boolean clear = false;
            if (sSeed > 0) {
                if (sSeed > s) {
                    warn = true;
                } else if (sSeed == s) {
                    clear = true;
                }
            }
            if (rSeed > 0) {
                if (rSeed > r) {
                    warn = true;
                } else if (rSeed == r) {
                    clear = true;
                }
            }
            if (gSeed > 0) {
                if (gSeed > g) {
                    warn = true;
                } else if (gSeed == g) {
                    clear = true;
                }
            }
            if (bSeed > 0) {
                if (bSeed > b) {
                    warn = true;
                } else if (bSeed == b) {
                    clear = true;
                }
            }
            if (warn) {
                log.warn("Propagation error detected, existing value:" + Integer.toHexString(light) + " seed:" + seed);
            }
            if (clear) {
                if (log.isTraceEnabled()) {
                    log.trace("    clearing:" + seed);
                }
            } else {
                if (!log.isTraceEnabled()) continue;
                log.trace("    unaffected");
                continue;
            }
            removed.add(new Vec3i(seed.x, seed.y, seed.z));
            lights.setCell(seed.x, seed.y, seed.z, 0);
            BlockType source = MaskUtils.getBlockType(cells.getCell(seed.x, seed.y, seed.z, 0));
            for (Direction dir : Direction.values()) {
                int val;
                if (seed.dir == dir.reverse()) {
                    // empty if block
                }
                if ((val = cells.getCell(seed.x, seed.y, seed.z, dir, -1)) == -1) continue;
                BlockType type = MaskUtils.getBlockType(val);
                int attenuated = LightUtils.attenuateLight(seed.light, source, dir, type);
                if (log.isTraceEnabled()) {
                    log.trace((Object)((Object)dir) + " attenuated:" + Integer.toHexString(attenuated));
                }
                if (attenuated <= 0) continue;
                int existing = lights.getCell(seed.x, seed.y, seed.z, dir, -1);
                if (log.isTraceEnabled()) {
                    log.trace("    existing:" + Integer.toHexString(existing));
                }
                if (existing == -1 || existing == 0) continue;
                if (existing == -65536) {
                    log.warn("How did this happen?  attenuateLight() error somewhere.");
                    continue;
                }
                seeds.add(new LightSeed(seed.x, seed.y, seed.z, dir, attenuated));
            }
            if (++counter <= 500000) continue;
            log.warn("Counter overrun:" + counter, new Throwable("stack"));
            break;
        }
        if (log.isTraceEnabled()) {
            log.trace(counter + " subtract light seed iterations");
        }
        return removed;
    }

    public static class LightSeed {
        int x;
        int y;
        int z;
        Direction dir;
        int light;

        public LightSeed(int x, int y, int z, Direction dir, int light) {
            this.x = x + dir.getVec3i().x;
            this.y = y + dir.getVec3i().y;
            this.z = z + dir.getVec3i().z;
            this.dir = dir;
            this.light = light;
        }

        public LightSeed(int x, int y, int z, int light) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.light = light;
        }

        public String toString() {
            return "LightSeed[(" + this.x + ", " + this.y + ", " + this.z + "), " + (Object)((Object)this.dir) + ", " + Integer.toHexString(this.light) + "]";
        }
    }
}

