/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Quaternion;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;
import java.io.Serializable;

public final class Quatd
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quatd() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Quatd(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quatd(Quatd quat) {
        this(quat.x, quat.y, quat.z, quat.w);
    }

    public Quatd(Quaternion quat) {
        this.x = quat.getX();
        this.y = quat.getY();
        this.z = quat.getZ();
        this.w = quat.getW();
    }

    public final Quatd clone() {
        return new Quatd(this.x, this.y, this.z, this.w);
    }

    public Quaternion toQuaternion() {
        return new Quaternion((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        bits ^= Double.doubleToLongBits(this.y) * 31L;
        bits ^= Double.doubleToLongBits(this.z) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.w) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Quatd other = (Quatd)o;
        if (other.x != this.x) {
            return false;
        }
        if (other.y != this.y) {
            return false;
        }
        if (other.z != this.z) {
            return false;
        }
        return other.w == this.w;
    }

    public boolean isSimilar(Quatd other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (Double.compare(Math.abs(other.x - this.x), epsilon) > 0) {
            return false;
        }
        if (Double.compare(Math.abs(other.y - this.y), epsilon) > 0) {
            return false;
        }
        if (Double.compare(Math.abs(other.z - this.z), epsilon) > 0) {
            return false;
        }
        return Double.compare(Math.abs(other.w - this.w), epsilon) <= 0;
    }

    public final Quatd set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public final Quatd set(Quatd q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
        return this;
    }

    public final Quatd set(Quaternion quat) {
        this.x = quat.getX();
        this.y = quat.getY();
        this.z = quat.getZ();
        this.w = quat.getW();
        return this;
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException("Index:" + i);
    }

    public Quatd set(int i, double d) {
        switch (i) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            case 3: {
                this.w = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index:" + i);
            }
        }
        return this;
    }

    public final Quatd add(Quatd q) {
        return new Quatd(this.x + q.x, this.y + q.y, this.z + q.z, this.w + q.w);
    }

    public final Quatd addLocal(Quatd q) {
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
        this.w += q.w;
        return this;
    }

    public final Quatd subtract(Quatd q) {
        return new Quatd(this.x - q.x, this.y - q.y, this.z - q.z, this.w - q.w);
    }

    public final Quatd subtractLocal(Quatd q) {
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
        this.w -= q.w;
        return this;
    }

    public final Quatd addScaledVectorLocal(Vec3d v, double scale) {
        Quatd q = new Quatd(v.x * scale, v.y * scale, v.z * scale, 0.0);
        q.multLocal(this);
        this.x += q.x * 0.5;
        this.y += q.y * 0.5;
        this.z += q.z * 0.5;
        this.w += q.w * 0.5;
        return this;
    }

    public final Quatd mult(Quatd q) {
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        double qw = q.w;
        double xr = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        double yr = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        double zr = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        double wr = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        return new Quatd(xr, yr, zr, wr);
    }

    public final Quatd multLocal(Quatd q) {
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        double qw = q.w;
        double xr = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        double yr = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        double zr = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        double wr = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        this.x = xr;
        this.y = yr;
        this.z = zr;
        this.w = wr;
        return this;
    }

    public Vec3d mult(Vec3d v) {
        if (v.x == 0.0 && v.y == 0.0 && v.z == 0.0) {
            return new Vec3d();
        }
        double vx = v.x;
        double vy = v.y;
        double vz = v.z;
        double rx = this.w * this.w * vx + 2.0 * this.y * this.w * vz - 2.0 * this.z * this.w * vy + this.x * this.x * vx + 2.0 * this.y * this.x * vy + 2.0 * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
        double ry = 2.0 * this.x * this.y * vx + this.y * this.y * vy + 2.0 * this.z * this.y * vz + 2.0 * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0 * this.x * this.w * vz - this.x * this.x * vy;
        double rz = 2.0 * this.x * this.z * vx + 2.0 * this.y * this.z * vy + this.z * this.z * vz - 2.0 * this.w * this.y * vx - this.y * this.y * vz + 2.0 * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        return new Vec3d(rx, ry, rz);
    }

    public Vec3d mult(Vec3d v, Vec3d result) {
        if (v.x == 0.0 && v.y == 0.0 && v.z == 0.0) {
            if (v != result) {
                result.set(0.0, 0.0, 0.0);
            }
            return result;
        }
        double vx = v.x;
        double vy = v.y;
        double vz = v.z;
        double rx = this.w * this.w * vx + 2.0 * this.y * this.w * vz - 2.0 * this.z * this.w * vy + this.x * this.x * vx + 2.0 * this.y * this.x * vy + 2.0 * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
        double ry = 2.0 * this.x * this.y * vx + this.y * this.y * vy + 2.0 * this.z * this.y * vz + 2.0 * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0 * this.x * this.w * vz - this.x * this.x * vy;
        double rz = 2.0 * this.x * this.z * vx + 2.0 * this.y * this.z * vy + this.z * this.z * vz - 2.0 * this.w * this.y * vx - this.y * this.y * vz + 2.0 * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        result.set(rx, ry, rz);
        return result;
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final Quatd normalizeLocal() {
        double d = this.lengthSq();
        if (d == 0.0) {
            this.w = 1.0;
            return this;
        }
        double s = 1.0 / Math.sqrt(d);
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        return this;
    }

    public Matrix3d toRotationMatrix() {
        double d = this.lengthSq();
        double s = 2.0 / d;
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        double m00 = 1.0 - (yy + zz);
        double m01 = xy - zw;
        double m02 = xz + yw;
        double m10 = xy + zw;
        double m11 = 1.0 - (xx + zz);
        double m12 = yz - xw;
        double m20 = xz - yw;
        double m21 = yz + xw;
        double m22 = 1.0 - (xx + yy);
        return new Matrix3d(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Quatd inverse() {
        double norm = this.lengthSq();
        if (norm <= 0.0) {
            return null;
        }
        double inv = 1.0 / norm;
        return new Quatd(-this.x * inv, -this.y * inv, -this.z * inv, this.w * inv);
    }

    public Quatd fromAngles(double[] angles) {
        return this.fromAngles(angles[0], angles[1], angles[2]);
    }

    public Quatd fromAngles(double xAngle, double yAngle, double zAngle) {
        double a = zAngle * 0.5;
        double sinZ = Math.sin(a);
        double cosZ = Math.cos(a);
        a = yAngle * 0.5;
        double sinY = Math.sin(a);
        double cosY = Math.cos(a);
        a = xAngle * 0.5;
        double sinX = Math.sin(a);
        double cosX = Math.cos(a);
        double cosYXcosZ = cosY * cosZ;
        double sinYXsinZ = sinY * sinZ;
        double cosYXsinZ = cosY * sinZ;
        double sinYXcosZ = sinY * cosZ;
        this.w = cosYXcosZ * cosX - sinYXsinZ * sinX;
        this.x = cosYXcosZ * sinX + sinYXsinZ * cosX;
        this.y = sinYXcosZ * cosX + cosYXsinZ * sinX;
        this.z = cosYXsinZ * cosX - sinYXcosZ * sinX;
        this.normalizeLocal();
        return this;
    }

    public double[] toAngles(double[] angles) {
        if (angles == null) {
            angles = new double[3];
        } else if (angles.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        double sqw = this.w * this.w;
        double sqx = this.x * this.x;
        double sqy = this.y * this.y;
        double sqz = this.z * this.z;
        double unit = sqx + sqy + sqz + sqw;
        double test = this.x * this.y + this.z * this.w;
        if (test > 0.499 * unit) {
            angles[1] = 2.0 * Math.atan2(this.x, this.w);
            angles[2] = 1.5707963267948966;
            angles[0] = 0.0;
        } else if (test < -0.499 * unit) {
            angles[1] = -2.0 * Math.atan2(this.x, this.w);
            angles[2] = -1.5707963267948966;
            angles[0] = 0.0;
        } else {
            angles[1] = Math.atan2(2.0 * this.y * this.w - 2.0 * this.x * this.z, sqx - sqy - sqz + sqw);
            angles[2] = Math.asin(2.0 * test / unit);
            angles[0] = Math.atan2(2.0 * this.x * this.w - 2.0 * this.y * this.z, -sqx + sqy - sqz + sqw);
        }
        return angles;
    }

    public Quatd slerpLocal(Quatd start, Quatd end, double mix) {
        if (start.x == end.x && start.y == end.y && start.z == end.z && start.w == end.w) {
            this.set(start);
            return this;
        }
        double endx = end.x;
        double endy = end.y;
        double endz = end.z;
        double endw = end.w;
        double dot = start.x * endx + start.y * endy + start.z * endz + start.w * endw;
        if (dot < 0.0) {
            endx = -endx;
            endy = -endy;
            endz = -endz;
            endw = -endw;
            dot = -dot;
        }
        double scale1 = 1.0 - mix;
        double scale2 = mix;
        if (dot < 0.9) {
            double theta = Math.acos(dot);
            double invSinTheta = 1.0 / Math.sin(theta);
            scale1 = Math.sin(scale1 * theta) * invSinTheta;
            scale2 = Math.sin(scale2 * theta) * invSinTheta;
        }
        this.x = scale1 * start.x + scale2 * endx;
        this.y = scale1 * start.y + scale2 * endy;
        this.z = scale1 * start.z + scale2 * endz;
        this.w = scale1 * start.w + scale2 * endw;
        return this;
    }

    public String toString() {
        return "Quatd[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

