#import "Common/ShaderLib/GLSLCompat.glsllib"

#if defined(HAS_GLOWMAP) || defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPARATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

#if defined(DISCARD_ALPHA)
    uniform float m_AlphaDiscardThreshold;
#endif

// fog - jayfella
#ifdef USE_FOG
#import "Common/ShaderLib/MaterialFog.glsllib"
varying float fog_distance;
uniform vec4 m_FogColor;

#ifdef FOG_LINEAR
uniform vec2 m_LinearFog;
#endif

#ifdef FOG_EXP
uniform float m_ExpFog;
#endif

#ifdef FOG_EXPSQ
uniform float m_ExpSqFog;
#endif

#endif // end fog

uniform vec4 m_Color;
uniform sampler2D m_ColorMap;
uniform sampler2D m_LightMap;

uniform float m_Alpha;

varying vec2 texCoord1;
varying vec2 texCoord2;

varying vec4 vertColor;

varying vec2 vertexLightValues;
varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;
varying vec4 modelLight;


void main(){
    vec4 color = vec4(1.0);

    #ifdef HAS_COLORMAP
        color *= texture2D(m_ColorMap, texCoord1);     
    #endif

    #ifdef HAS_VERTEXCOLOR
        color *= vertColor;
    #endif

    #ifdef HAS_COLOR
        color *= m_Color;
    #endif

    #ifdef HAS_LIGHTMAP
        #ifdef SEPARATE_TEXCOORD
            color.rgb *= texture2D(m_LightMap, texCoord2).rgb;
        #else
            color.rgb *= texture2D(m_LightMap, texCoord1).rgb;
        #endif
    #endif

    #if defined(DISCARD_ALPHA)
        if(color.a < m_AlphaDiscardThreshold){
           discard;
        }
    #endif

    vec2 light = vertexLightValues.xy;
    #ifdef COLORRAMP
        color.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
        //specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
        light.xy = vec2(1.0);
    #endif

    gl_FragColor.rgb =  AmbientSum     * color.rgb + 
                        DiffuseSum.rgb * color.rgb  * vec3(light.x); // +
                        //SpecularSum    * specularColor.rgb * vec3(light.y);

    float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.w * light.x + length(AmbientSum.rgb) * modelLight.w);
    float localContrib = min(1.0, 1.25 - sunContrib);
 
    gl_FragColor.rgb += modelLight.xyz * 0.25 * color.rgb * localContrib 
                           + modelLight.xyz * color.rgb * localContrib;
                           //+ 1.0 * specularColor.rgb;  

    float fogMultiplier = 1.0 - min(1.0, 0.5 * localContrib * length(modelLight.xyz));

    // add fog after the lighting because shadows will cause the fog to darken
    // which just results in the geometry looking like it's changed color
    #ifdef USE_FOG
        #ifdef FOG_LINEAR
            gl_FragColor = getFogLinear(gl_FragColor, m_FogColor, m_LinearFog.x, m_LinearFog.y, fog_distance * fogMultiplier);
        #endif
        #ifdef FOG_EXP
            gl_FragColor = getFogExp(gl_FragColor, m_FogColor, m_ExpFog, fog_distance * fogMultiplier);
        #endif
        #ifdef FOG_EXPSQ
            gl_FragColor = getFogExpSquare(gl_FragColor, m_FogColor, m_ExpSqFog, fog_distance * fogMultiplier);
        #endif
    #endif // end fog

    gl_FragColor.a = m_Alpha;
}


