/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mblock.Direction;

public class DirectionMasks {
    public static final int NORTH_MASK = 1;
    public static final int SOUTH_MASK = 2;
    public static final int EAST_MASK = 4;
    public static final int WEST_MASK = 8;
    public static final int UP_MASK = 16;
    public static final int DOWN_MASK = 32;
    public static final int ALL_MASKS = 63;
    public static final int[] MASKS = new int[Direction.values().length];

    public static boolean hasMask(int test, int mask) {
        return (test & mask) != 0;
    }

    public static final boolean hasNorth(int mask) {
        return (mask & 1) != 0;
    }

    public static final boolean hasSouth(int mask) {
        return (mask & 2) != 0;
    }

    public static final boolean hasEast(int mask) {
        return (mask & 4) != 0;
    }

    public static final boolean hasWest(int mask) {
        return (mask & 8) != 0;
    }

    public static final boolean hasUp(int mask) {
        return (mask & 0x10) != 0;
    }

    public static final boolean hasDown(int mask) {
        return (mask & 0x20) != 0;
    }

    public static final boolean hasNorthOrSouth(int mask) {
        return DirectionMasks.hasNorth(mask) || DirectionMasks.hasSouth(mask);
    }

    public static final boolean hasEastOrWest(int mask) {
        return DirectionMasks.hasEast(mask) || DirectionMasks.hasWest(mask);
    }

    public static final boolean hasUpOrDown(int mask) {
        return DirectionMasks.hasUp(mask) || DirectionMasks.hasDown(mask);
    }

    public static final String toString(int mask) {
        if (mask == 0) {
            return "None";
        }
        StringBuilder sb = new StringBuilder();
        if (DirectionMasks.hasNorth(mask)) {
            sb.append("N");
        }
        if (DirectionMasks.hasSouth(mask)) {
            sb.append("S");
        }
        if (DirectionMasks.hasEast(mask)) {
            sb.append("E");
        }
        if (DirectionMasks.hasWest(mask)) {
            sb.append("W");
        }
        if (DirectionMasks.hasUp(mask)) {
            sb.append("U");
        }
        if (DirectionMasks.hasDown(mask)) {
            sb.append("D");
        }
        return sb.toString();
    }

    static {
        DirectionMasks.MASKS[Direction.North.ordinal()] = 1;
        DirectionMasks.MASKS[Direction.South.ordinal()] = 2;
        DirectionMasks.MASKS[Direction.East.ordinal()] = 4;
        DirectionMasks.MASKS[Direction.West.ordinal()] = 8;
        DirectionMasks.MASKS[Direction.Up.ordinal()] = 16;
        DirectionMasks.MASKS[Direction.Down.ordinal()] = 32;
    }
}

