/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.event.BasePickState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveGuiState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PerspectiveGuiState.class);
    private Node previousGuiNode;
    private Camera guiCam;
    private float fov = 45.0f;
    private float nearPlane = 1.0f;
    private float farPlane = 2000.0f;
    private ViewPort viewport;
    private ViewPort guiViewPort;
    private Node root;
    private DirectionalLight light;
    private AmbientLight ambient;
    private float neutralPlane;
    private Node perspectiveRoot;
    private Node glassRoot = new Node("Glass Plane");

    public PerspectiveGuiState() {
    }

    public PerspectiveGuiState(String id) {
        super(id);
    }

    public Node getRoot() {
        return this.perspectiveRoot;
    }

    public Node getGlassRoot() {
        return this.glassRoot;
    }

    public Camera getGuiCamera() {
        return this.guiCam;
    }

    public DirectionalLight getGuiSun() {
        return this.light;
    }

    public AmbientLight getGuiAmbient() {
        return this.ambient;
    }

    protected void resetProjection() {
        float z;
        float aspect = (float)this.guiCam.getWidth() / (float)this.guiCam.getHeight();
        this.guiCam.setFrustumPerspective(this.fov, aspect, this.nearPlane, this.farPlane);
        this.guiCam.setRotation(new Quaternion().fromAngles(0.0f, (float)Math.PI, 0.0f));
        float m11 = this.guiCam.getViewProjectionMatrix().m11;
        this.neutralPlane = z = m11 * (float)this.guiCam.getHeight() * 0.5f;
        log.info("Setting z to:" + z);
        this.guiCam.setLocation(new Vector3f(0.0f, 0.0f, z));
        this.root.setLocalTranslation((float)(-this.guiCam.getWidth() / 2), (float)(-this.guiCam.getHeight() / 2), 0.0f);
    }

    protected void resetCameraSize() {
        this.root.setLocalTranslation((float)(-this.guiCam.getWidth() / 2), (float)(-this.guiCam.getHeight() / 2), 0.0f);
    }

    protected void initialize(Application app) {
        this.root = new Node("Perspective GUI root");
        this.root.setCullHint(Spatial.CullHint.Never);
        Camera appCam = app.getCamera();
        this.guiCam = new Camera(appCam.getWidth(), appCam.getHeight());
        this.resetProjection();
        this.viewport = app.getRenderManager().createPostView("Perspective GUI ViewPort", this.guiCam);
        this.viewport.setEnabled(this.isEnabled());
        this.viewport.setClearFlags(false, true, true);
        this.viewport.attachScene((Spatial)this.root);
        Camera guiCam = new Camera(appCam.getWidth(), appCam.getHeight());
        this.guiViewPort = app.getRenderManager().createPostView("Glass Plane", guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
        this.guiViewPort.attachScene((Spatial)this.glassRoot);
        this.glassRoot.setQueueBucket(RenderQueue.Bucket.Gui);
        this.glassRoot.setCullHint(Spatial.CullHint.Never);
        GuiGlobals.getInstance().setupGuiComparators(this.viewport);
        ((BasePickState)this.getState(BasePickState.class)).addCollisionRoot(this.guiViewPort, "gui");
        ((BasePickState)this.getState(BasePickState.class)).addCollisionRoot(this.viewport, "scene");
        RenderQueue rq = this.viewport.getQueue();
        rq.setGeometryComparator(RenderQueue.Bucket.Transparent, (GeometryComparator)new LayerComparator((GeometryComparator)new OpaqueComparator(), -1));
        this.light = new DirectionalLight(){

            public void setColor(ColorRGBA color) {
                this.color = color;
            }
        };
        this.light.setDirection(new Vector3f(1.0f, -0.5f, -1.5f).normalizeLocal());
        this.root.addLight((Light)this.light);
        this.ambient = new AmbientLight();
        this.ambient.setColor(ColorRGBA.Gray);
        this.root.addLight((Light)this.ambient);
        this.perspectiveRoot = new Node("Zero Plane");
        int width = guiCam.getWidth();
        int height = guiCam.getHeight();
        float nearDist = 5.0f;
        float nearScale = nearDist / this.neutralPlane;
        this.perspectiveRoot.setLocalScale(nearScale);
        this.perspectiveRoot.setLocalTranslation((float)(width / 2), (float)(height / 2), this.neutralPlane - nearDist);
        this.perspectiveRoot.move(-nearScale * (float)width / 2.0f, -nearScale * (float)height / 2.0f, 0.0f);
        this.root.attachChild((Spatial)this.perspectiveRoot);
        this.root.updateLogicalState(1.0f);
        this.root.updateGeometricState();
        this.glassRoot.updateLogicalState(1.0f);
        this.glassRoot.updateGeometricState();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.viewport.setEnabled(true);
        this.guiViewPort.setEnabled(true);
        this.previousGuiNode = GuiGlobals.getInstance().getPopupState().getGuiNode();
    }

    protected void onDisable() {
        this.viewport.setEnabled(false);
        this.guiViewPort.setEnabled(false);
        this.root.updateGeometricState();
        this.glassRoot.updateGeometricState();
    }

    public void update(float tpf) {
        this.root.updateLogicalState(tpf);
        this.glassRoot.updateLogicalState(tpf);
    }

    public void render(RenderManager rm) {
        this.root.updateGeometricState();
        this.glassRoot.updateGeometricState();
    }
}

