/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.view.FarTerrainState;
import mythruna.client.net.ConnectionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.MapComponent;
import mythruna.net.AccountSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MapViewState.class);
    private EntityData ed;
    private Container mapContainer;
    private Container left;
    private Container right;
    private Label map;
    private MapComponent mapComponent;
    private Node playerMarker;
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Quatd> orientRef;

    public Container getMap() {
        return this.mapContainer;
    }

    protected void initialize(Application app) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.mapContainer = new Container((GuiLayout)new BorderLayout());
        this.left = (Container)this.mapContainer.addChild((Node)new Container(), new Object[]{BorderLayout.Position.West});
        this.right = (Container)this.mapContainer.addChild((Node)new Container(), new Object[]{BorderLayout.Position.East});
        Texture terrain = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarTerrainTexture();
        Texture fluid = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarFluidTexture();
        this.map = (Label)this.mapContainer.addChild((Node)new Label(""), new Object[]{BorderLayout.Position.Center});
        Texture paper = app.getAssetManager().loadTexture("Textures/sand.jpg");
        this.map.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.mapComponent = new MapComponent(app.getAssetManager(), terrain, fluid);
        this.map.setIcon((GuiComponent)this.mapComponent);
        this.map.setPreferredSize(new Vector3f(512.0f, 512.0f, 1.0f));
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        EntityId worldEntity = account.getWorldEntity();
        Name name = (Name)this.ed.getComponent(worldEntity, Name.class);
        this.left.addChild((Node)new Label("TBD"), new Object[0]);
        this.right.addChild((Node)new Label("World:" + name.getName()), new Object[0]);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.orientRef = ((AvatarState)this.getState(AvatarState.class)).createOrientationReference();
        this.playerMarker = new Node();
        Quad quad = new Quad(64.0f, 64.0f);
        Geometry geom = new Geometry("marker", (Mesh)quad);
        geom.setLocalScale(0.15f);
        Texture arrow = app.getAssetManager().loadTexture("Interface/arrow-right.png");
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(arrow, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.getMaterial().setColor("Color", new ColorRGBA(0.75f, 0.1f, 0.1f, 0.75f));
        geom.center();
        this.playerMarker.attachChild((Spatial)geom);
        this.playerMarker.setLocalTranslation(100.0f, -100.0f, 10.0f);
        this.map.attachChild((Spatial)this.playerMarker);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
    }

    protected void onDisable() {
        log.info("onDisable()");
    }

    public void update(float tpf) {
        if (this.orientRef.update()) {
            this.updatePlayerMarker();
        }
        if (this.posRef.update()) {
            this.updateTextureOffset((Vec3d)this.posRef.get());
        }
    }

    protected void updateTextureOffset(Vec3d pos) {
        TileId tile = TileId.fromWorld((double)pos.x, (double)pos.z);
        Vec3d offset = pos.subtract(tile.getWorld(null).toVec3d());
        double x = offset.x / 16384.0;
        double z = offset.z / 16384.0;
        this.mapComponent.setTextureOffset(x -= 0.03125, z -= 0.03125);
    }

    protected void updatePlayerMarker() {
        Vector3f size = this.map.getSize();
        if (size.y > 0.0f) {
            float center = size.y * 0.5f;
            this.playerMarker.setLocalTranslation(center, -center, 10.0f);
        }
        Quatd orient = (Quatd)this.orientRef.get();
        Vec3d dir = orient.mult(Vec3d.UNIT_Z);
        double rads = Math.atan2(-dir.z, dir.x);
        this.playerMarker.setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, (float)rads));
    }
}

