/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.ElevationSource;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptElevationSource
implements ElevationSource {
    static Logger log = LoggerFactory.getLogger(ScriptElevationSource.class);
    private ElevationSource delegate;
    private double seaLevel = 64.0;
    private double maxElevation = 576.0;
    private ScriptEngine engine;
    private Bindings bindings;
    private CompiledScript transform;

    public ScriptElevationSource(ElevationSource delegate, String script) {
        this.delegate = delegate;
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("groovy");
        this.bindings = this.engine.createBindings();
        this.resetBindings();
        this.setScript(script);
    }

    protected void resetBindings() {
        this.bindings.put("maxElevation", (Object)this.maxElevation);
        this.bindings.put("waterElevation", (Object)this.seaLevel);
    }

    public void setScript(String script) {
        try {
            this.transform = ((Compilable)((Object)this.engine)).compile(script);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Could not parse script:" + script, e);
        }
    }

    @Override
    public double getElevation(double x, double y) {
        double elevation = this.delegate.getElevation(x, y);
        try {
            this.bindings.put("y", (Object)elevation);
            Object result = this.transform.eval(this.bindings);
            if (result instanceof Number) {
                elevation = ((Number)result).doubleValue();
            }
            return elevation;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error processing value:" + elevation, e);
        }
    }
}

