/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.ElevationData;
import org.progeeks.map.ElevationGenerator;

public abstract class AbstractElevationGenerator
implements ElevationGenerator {
    private String name;
    private boolean valid = false;
    private boolean enabled = true;
    private ElevationData sourceData;
    private ElevationData result;
    private int elevationOffset = -1500;
    private int elevationScale = 15000;

    protected AbstractElevationGenerator(String name) {
        this.name = name;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptsSourceData() {
        return true;
    }

    @Override
    public void setSourceData(ElevationData data) {
        if (this.sourceData == data) {
            return;
        }
        this.sourceData = data;
        this.invalidate();
    }

    public void setElevationScale(int scale) {
        if (this.elevationScale == scale) {
            return;
        }
        this.elevationScale = scale;
        this.invalidate();
    }

    public int getElevationScale() {
        return this.elevationScale;
    }

    public void setElevationOffset(int offset) {
        if (this.elevationOffset == offset) {
            return;
        }
        this.elevationOffset = offset;
        this.invalidate();
    }

    public int getElevationOffset() {
        return this.elevationOffset;
    }

    protected abstract ElevationData generateElevations(ElevationData var1);

    @Override
    public ElevationData getSourceData() {
        return this.sourceData;
    }

    @Override
    public ElevationData getGeneratedData() {
        if (!this.enabled) {
            return this.getSourceData();
        }
        if (!this.valid || this.result == null) {
            this.result = this.generateElevations(this.result);
            this.valid = true;
        }
        return this.result;
    }
}

