/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.reflect.TypeToken;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.BinIndex;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bin<K, S extends AbstractShape> {
    static Logger log = LoggerFactory.getLogger(Bin.class);
    private final BinIndex<K, S> parent;
    private final GridCell cell;
    private Status status = Status.Empty;
    private int watchers = 0;
    private final DynArray<StaticBody<K, S>> staticObjects = new DynArray(new TypeToken<StaticBody<K, S>>(){});
    private final DynArray<RigidBody<K, S>> activeObjects = new DynArray(new TypeToken<RigidBody<K, S>>(){});
    private final DynArray<RigidBody<K, S>> inactiveObjects = new DynArray(new TypeToken<RigidBody<K, S>>(){});

    public Bin(BinIndex<K, S> parent, GridCell cell) {
        this.parent = parent;
        this.cell = cell;
    }

    public void writeDebugInfo(PrintWriter out) {
        out.println("------------------------------------------------------------");
        out.println("Bin:" + this.cell + "  Status:" + (Object)((Object)this.status) + "  Watchers:" + this.watchers);
        out.println("  static bodies:");
        for (StaticBody<K, S> staticBody : this.staticObjects.getArray()) {
            out.println("    " + staticBody);
        }
        out.println("  active bodies:");
        for (AbstractBody abstractBody : this.activeObjects.getArray()) {
            out.println("    " + abstractBody);
        }
        out.println("  inactive bodies:");
        for (AbstractBody abstractBody : this.inactiveObjects.getArray()) {
            out.println("    " + abstractBody);
        }
    }

    protected void checkDependencies() {
        if (log.isTraceEnabled()) {
            log.trace("watchers:" + this.watchers + "  activeObjects:" + this.activeObjects.size());
        }
        if (this.watchers == 0 && this.status != Status.Active) {
            if (log.isTraceEnabled()) {
                log.trace("Bin can be unloaded:" + this);
            }
            this.parent.markForUnload(this);
        }
    }

    protected void updateWatchersCount(int delta) {
        this.watchers += delta;
        this.checkDependencies();
    }

    protected int getWatchersCount() {
        return this.watchers;
    }

    public GridCell getGridCell() {
        return this.cell;
    }

    public Status getStatus() {
        return this.status;
    }

    public StaticBody<K, S> addStaticBody(K bodyId) {
        StaticBody<K, S> body = this.parent.getStaticBody(bodyId, true);
        if (!this.cell.contains(body.position)) {
            log.warn("Body " + bodyId + " is not really in bin:" + this);
        }
        this.staticObjects.add(body);
        this.refreshStatus();
        return body;
    }

    public StaticBody<K, S> removeStaticBody(K bodyId) {
        StaticBody<K, S> result = null;
        Iterator<StaticBody<K, S>> it = this.staticObjects.iterator();
        while (it.hasNext()) {
            StaticBody<K, S> body = it.next();
            if (!Objects.equals(body.id, bodyId)) continue;
            it.remove();
            result = body;
            break;
        }
        this.parent.unloadStaticBody(bodyId);
        this.refreshStatus();
        return result;
    }

    public RigidBody<K, S> addRigidBody(K bodyId) {
        if (log.isDebugEnabled()) {
            log.debug(this + " add(" + bodyId + ")");
        }
        return this.parent.addRigidBodyToBin(this, bodyId);
    }

    public RigidBody<K, S> removeRigidBody(K bodyId) {
        if (log.isDebugEnabled()) {
            log.debug(this + " remove(" + bodyId + ")");
        }
        return this.parent.removeRigidBodyFromBin(this, bodyId);
    }

    public void addJoint(K jointId, K bodyId1, K bodyId2) {
        this.parent.addJointToBin(this, jointId, bodyId1, bodyId2);
    }

    public void removeJoint(K jointId) {
        this.parent.removeJointFromBin(this, jointId);
    }

    protected void add(RigidBody<K, S> body, boolean active) {
        body.gridCell = this.cell;
        if (active) {
            if (log.isTraceEnabled()) {
                log.trace("adding " + body.id + " to active objects");
            }
            this.activeObjects.add(body);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("adding " + body.id + " to inactive objects");
            }
            this.inactiveObjects.add(body);
        }
        this.refreshStatus();
    }

    protected void remove(RigidBody<K, S> body, boolean active) {
        if (active) {
            if (log.isTraceEnabled()) {
                log.trace("removing " + body.id + " from active objects");
            }
            this.activeObjects.remove(body);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("removing " + body.id + " from inactive objects");
            }
            this.inactiveObjects.remove(body);
        }
        this.refreshStatus();
    }

    protected void activate(RigidBody<K, S> body) {
        if (log.isDebugEnabled()) {
            log.debug(this + " activate(" + body.id + ") sleepy:" + body.isSleepy());
        }
        if (log.isTraceEnabled()) {
            log.trace("removing " + body.id + " from inactive objects");
        }
        this.inactiveObjects.remove(body);
        if (log.isTraceEnabled()) {
            log.trace("adding " + body.id + " to active objects");
        }
        this.activeObjects.add(body);
        this.refreshStatus();
    }

    protected void deactivate(RigidBody<K, S> body) {
        if (log.isDebugEnabled()) {
            log.debug(this + " deactivate(" + body.id + ") sleepy:" + body.isSleepy());
        }
        if (log.isTraceEnabled()) {
            log.trace("removing " + body.id + " from active objects");
        }
        this.activeObjects.remove(body);
        if (log.isTraceEnabled()) {
            log.trace("adding " + body.id + " to inactive objects");
        }
        this.inactiveObjects.add(body);
        this.refreshStatus();
    }

    private Status calculateStatus() {
        if (!this.activeObjects.isEmpty()) {
            return Status.Active;
        }
        if (!this.inactiveObjects.isEmpty()) {
            return Status.Asleep;
        }
        if (!this.staticObjects.isEmpty()) {
            return Status.Static;
        }
        return Status.Empty;
    }

    private void refreshStatus() {
        this.setStatus(this.calculateStatus());
    }

    protected void setStatus(Status status) {
        if (this.status == status) {
            return;
        }
        Status old = this.status;
        this.status = status;
        if (log.isTraceEnabled()) {
            log.trace(this + " setStatus(" + (Object)((Object)status) + ")");
        }
        boolean deactivated = false;
        if (old == Status.Active) {
            this.parent.deactivate(this);
            deactivated = true;
        } else if (status == Status.Active) {
            this.parent.activate(this);
        }
        this.parent.fireBinStatusChanged(this, status);
        if (deactivated) {
            this.checkDependencies();
        }
    }

    public DynArray<RigidBody<K, S>> getActiveObjects() {
        return this.activeObjects;
    }

    public DynArray<RigidBody<K, S>> getInactiveObjects() {
        return this.inactiveObjects;
    }

    public DynArray<StaticBody<K, S>> getStaticObjects() {
        return this.staticObjects;
    }

    public boolean contains(Vec3d world) {
        return this.cell.contains(world);
    }

    public String toString() {
        return "Bin[" + this.cell + "]";
    }

    public static enum Status {
        Empty,
        Static,
        Asleep,
        Active;

    }
}

