/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AnnealingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnealingFunction
implements AnnealingFunction {
    static Logger log = LoggerFactory.getLogger(DefaultAnnealingFunction.class);
    public static final DefaultAnnealingFunction GLOBAL_ANNEALING = new DefaultAnnealingFunction();
    private static final double MOTION_EPSILON = 0.07;
    private static final double ROTATION_EPSILON = 0.01;
    private static final double MOTION_SLOW_COOL = 0.15;
    private static final double ROTATION_SLOW_COOL = 0.04;
    private static final double COOLING = 0.98;
    private static final double SLOW_COOLING = 0.99;
    private static final double HEATING = 1.5;
    private static final double SLEEP_EPSILON = 0.01;
    private static final double WAKING_TEMPERATURE = 0.1;
    private double minLinear = Math.sqrt(0.07);
    private double minRot = Math.sqrt(0.01);
    private double midLinear = Math.sqrt(0.15);
    private double midRot = Math.sqrt(0.04);
    private double highLinear = Math.sqrt(0.22499999999999998);
    private double highRot = Math.sqrt(0.06);
    private double minLinearSq = 0.07;
    private double minRotSq = 0.01;
    private double midLinearSq = 0.15;
    private double midRotSq = 0.04;
    private double highLinearSq = 0.22499999999999998;
    private double highRotSq = 0.06;
    private double coolingFactor = 0.98;
    private double slowCoolingFactor = 0.99;
    private double heatingFactor = 1.5;
    private double minTemperature = 0.01;
    private double wakingTemperature = 0.1;

    public void setMinLinear(double d) {
        this.minLinear = d;
        this.minLinearSq = d * d;
    }

    public double getMinLinear() {
        return this.minLinear;
    }

    public void setMinRotational(double d) {
        this.minRot = d;
        this.minRotSq = d * d;
    }

    public double getMinRotational() {
        return this.minRot;
    }

    public void setMidLinear(double d) {
        this.midLinear = d;
        this.midLinearSq = d * d;
    }

    public double getMidLinear() {
        return this.midLinear;
    }

    public void setMidRotational(double d) {
        this.midRot = d;
        this.midRotSq = d * d;
    }

    public double getMidRotational() {
        return this.midRot;
    }

    public void setHighLinear(double d) {
        this.highLinear = d;
        this.highLinearSq = d * d;
    }

    public double getHighLinear() {
        return this.highLinear;
    }

    public void setHighRotational(double d) {
        this.highRot = d;
        this.highRotSq = d * d;
    }

    public double getHighRotational() {
        return this.highRot;
    }

    public void setCoolingFactor(double d) {
        this.coolingFactor = d;
    }

    public double getCoolingFactor() {
        return this.coolingFactor;
    }

    public void setSlowCoolingFactor(double d) {
        this.slowCoolingFactor = d;
    }

    public double getSlowCoolingFactor() {
        return this.slowCoolingFactor;
    }

    public void setHeatingFactor(double d) {
        this.heatingFactor = d;
    }

    public double getHeatingFactor() {
        return this.heatingFactor;
    }

    public void setMinimumTemperature(double d) {
        this.minTemperature = d;
    }

    public double getMinimumTemperature() {
        return this.minTemperature;
    }

    public void setWakingTemperature(double d) {
        this.wakingTemperature = d;
    }

    @Override
    public double getWakingTemperature() {
        return this.wakingTemperature;
    }

    @Override
    public boolean isCold(double temperature) {
        return temperature < this.minTemperature;
    }

    @Override
    public double calculateTemperature(double temperature, Vec3d linearVel, Vec3d rotVel, Vec3d linearAccel, Vec3d lastLinearVel, Vec3d lastRotVel, double time) {
        double linVelSq = linearVel.lengthSq();
        double rotVelSq = rotVel.lengthSq();
        if (linVelSq < this.minLinearSq && rotVelSq < this.minRotSq) {
            temperature *= this.coolingFactor;
        } else if (linVelSq < this.midLinearSq && rotVelSq < this.midRotSq) {
            temperature *= this.slowCoolingFactor;
        } else if (linVelSq > this.highLinearSq && rotVelSq > this.highRotSq && (temperature *= this.heatingFactor) > 1.0) {
            temperature = 1.0;
        }
        return temperature;
    }
}

