/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.action.ActionContext;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeRegistry<A, T>
implements Iterable<ObjectType<A, T>> {
    static Logger log = LoggerFactory.getLogger(ObjectTypeRegistry.class);
    private Map<String, ObjectType<A, T>> typeIndex = new HashMap<String, ObjectType<A, T>>();
    private Function<T, String> typeNameResolver;
    private LoadingCache<T, ActionContext<A, T>> contextCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<T, ActionContext<A, T>>(){

        public ActionContext<A, T> load(T target) {
            return ObjectTypeRegistry.this.createContext(target);
        }
    });

    protected LoadingCache<T, ActionContext<A, T>> getContextCache() {
        return this.contextCache;
    }

    @Override
    public Iterator<ObjectType<A, T>> iterator() {
        return Collections.unmodifiableCollection(this.typeIndex.values()).iterator();
    }

    public ObjectTypeRegistry<A, T> typeNameResolver(Function<T, String> typeNameResolver) {
        this.typeNameResolver = typeNameResolver;
        return this;
    }

    public void setTypeNameResolver(Function<T, String> typeNameResolver) {
        this.typeNameResolver = typeNameResolver;
    }

    public Function<T, String> getTypeNameResolver() {
        return this.typeNameResolver;
    }

    public ObjectType<A, T> registerType(ObjectType<A, T> type) {
        String name = type.getName();
        if (this.typeIndex.containsKey(name)) {
            throw new IllegalArgumentException("Type already exists for:" + name);
        }
        this.typeIndex.put(name, type);
        return type;
    }

    public ObjectType<A, T> getType(String name) {
        return this.typeIndex.get(name);
    }

    public ActionEnvironment<A, T> createEnvironment(A activator) {
        return new ActionEnvironment(this, activator);
    }

    public ActionContext<A, T> createContext(T target) {
        if (this.typeNameResolver == null) {
            throw new IllegalStateException("No typeNameResolver configured");
        }
        String typeName = this.typeNameResolver.apply(target);
        if (typeName == null) {
            throw new IllegalArgumentException("No type name resolved for:" + target);
        }
        ObjectType<A, T> type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("No type:" + typeName + " found for:" + target);
        }
        return this.createContext(type, target);
    }

    public ActionContext<A, T> createContext(ObjectType<A, T> type, T target) {
        log.info("Creating action context for:" + type + ", " + target);
        return new ActionContext<A, T>(type, target);
    }

    public ActionContext<A, T> getContext(T target) {
        return (ActionContext)this.contextCache.getUnchecked(target);
    }
}

