/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.simsilica.es.EntityData;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksResourceShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(BlocksResourceShapeFactory.class);
    private EntityData ed;

    public BlocksResourceShapeFactory(EntityData ed) {
        this.ed = ed;
    }

    public MBlockShape createShape(ShapeInfo info, Mass mass) {
        CellArray cells;
        log.info("createShape(" + info.toString(this.ed) + ", " + mass + ")");
        String name = info.getShapeName(this.ed);
        double m = mass == null ? 0.0 : mass.getMass();
        try {
            log.info("loading:" + this.getClass().getResource(name));
            cells = BlocksFileFormat.loadCellArray((String)name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading block resource:" + name, e);
        }
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)info.getScale(), (double)m);
    }
}

