/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Sphere;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.debug.BodyDebugState;
import com.simsilica.ext.mphys.debug.DebugShapeFactory;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.RigidBody;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartDebugShapeFactory
implements DebugShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(PartDebugShapeFactory.class);
    private Mesh axesMesh;
    private Geometry axesTemplate;
    private Mesh cogMesh;
    private Mesh boundsSphere;
    private ColorRGBA groupBoundsColor = new ColorRGBA(0.1f, 0.1f, 0.1f, 0.2f);
    private ColorRGBA partBoundsColor = new ColorRGBA(0.0f, 1.0f, 1.0f, 0.25f);
    private ColorRGBA errorBoundsColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.8f);

    public void initialize(BodyDebugState<MBlockShape> parent) {
        float axesSize = 0.1f;
        this.axesMesh = new Mesh();
        this.axesMesh.setMode(Mesh.Mode.Lines);
        this.axesMesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, axesSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axesSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axesSize});
        this.axesMesh.setBuffer(VertexBuffer.Type.Color, 4, new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f});
        this.axesTemplate = new Geometry("axes", this.axesMesh);
        this.axesTemplate.setQueueBucket(RenderQueue.Bucket.Translucent);
        Material mat = GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f), false).getMaterial();
        mat.setBoolean("VertexColor", true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.axesTemplate.setMaterial(mat);
        float cogSize = axesSize * 0.1f;
        this.cogMesh = new WireBox(cogSize, cogSize, cogSize);
        this.boundsSphere = new Sphere(24, 24, 1.0f);
    }

    public void terminate(BodyDebugState<MBlockShape> parent) {
    }

    public void addDebugShape(RigidBody<EntityId, MBlockShape> body, Node view, ColorRGBA temperature) {
        log.info("body mass:" + ((MBlockShape)body.shape).getMass());
        PartDebugView debugView = new PartDebugView();
        view.attachChild((Spatial)debugView);
        this.updateDebugShape(((MBlockShape)body.shape).getPart(), body, debugView, null);
    }

    public void updateDebugShape(RigidBody<EntityId, MBlockShape> body, Node view, ColorRGBA temperature) {
        PartDebugView debugView = (PartDebugView)view.getChild("partDebugView");
        HashSet<Part> toRemove = new HashSet<Part>(debugView.axes.keySet());
        this.updateDebugShape(((MBlockShape)body.shape).getPart(), body, debugView, toRemove);
        debugView.removeParts(toRemove);
    }

    protected void updateDebugShape(Part part, RigidBody<EntityId, MBlockShape> body, PartDebugView view, Set<Part> toRemove) {
        view.updatePart(part, body);
        if (toRemove != null) {
            toRemove.remove(part);
        }
        if (part instanceof CellArrayPart) {
            this.updateDebugShape((CellArrayPart)part, body, view, toRemove);
        } else if (part instanceof Group) {
            this.updateDebugShape((Group)part, body, view, toRemove);
        }
    }

    protected void updateDebugShape(Group group, RigidBody<EntityId, MBlockShape> body, PartDebugView view, Set<Part> toRemove) {
        for (Part p : group.getChildren()) {
            this.updateDebugShape(p, body, view, toRemove);
        }
    }

    protected void updateDebugShape(CellArrayPart part, RigidBody<EntityId, MBlockShape> body, PartDebugView view, Set<Part> toRemove) {
    }

    private class PartDebugView
    extends Node {
        private Map<Part, Geometry> axes;
        private Map<Part, Geometry> spheres;

        public PartDebugView() {
            super("partDebugView");
            this.axes = new HashMap<Part, Geometry>();
            this.spheres = new HashMap<Part, Geometry>();
        }

        public void removeParts(Iterable<Part> parts) {
            for (Part p : parts) {
                Geometry geom = this.axes.remove(p);
                if (geom != null) {
                    geom.removeFromParent();
                }
                if ((geom = this.spheres.remove(p)) == null) continue;
                geom.removeFromParent();
            }
        }

        public void updatePart(Part part, RigidBody<EntityId, MBlockShape> body) {
            Vec3d cog = ((MBlockShape)body.shape).getMass().getCog();
            Vec3d partPos = part.getShapeRelativeCog().subtract(cog);
            Quatd rotation = part.getShapeRelativeOrientation();
            Geometry geom = this.axes.get(part);
            if (geom == null) {
                geom = PartDebugShapeFactory.this.axesTemplate.clone();
                this.attachChild((Spatial)geom);
                this.axes.put(part, geom);
            }
            geom.setLocalTranslation(partPos.toVector3f());
            geom.setLocalRotation(rotation.toQuaternion());
            double radius = part.getMass().getRadius();
            ColorRGBA boundsColor = part instanceof CellArrayPart ? PartDebugShapeFactory.this.partBoundsColor : (part instanceof Group ? PartDebugShapeFactory.this.groupBoundsColor : PartDebugShapeFactory.this.errorBoundsColor);
            geom = this.spheres.get(part);
            if (geom == null) {
                geom = new Geometry("boundingSphere", PartDebugShapeFactory.this.boundsSphere);
                Material mat = GuiGlobals.getInstance().createMaterial(boundsColor, false).getMaterial();
                mat.getAdditionalRenderState().setWireframe(true);
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                geom.setMaterial(mat);
                geom.setQueueBucket(RenderQueue.Bucket.Translucent);
                this.attachChild((Spatial)geom);
                this.spheres.put(part, geom);
            } else {
                geom.getMaterial().setColor("Color", boundsColor);
            }
            geom.setLocalScale((float)radius);
            geom.setLocalTranslation(partPos.toVector3f());
        }
    }
}

