/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertColumnProcessor
implements TileColumnProcessor {
    static Logger log = LoggerFactory.getLogger(InsertColumnProcessor.class);
    private static int LEAF_SIZE = 32;
    public static final int INSERT_BITS = CellGenType.Insert.apply(0);
    private Function<BlockDataId, BlockData> blocksFunction;
    private IntCombiner blockMerge;
    private IntCombiner fluidMerge;

    public InsertColumnProcessor(Function<BlockDataId, BlockData> blocksFunction) {
        this(blocksFunction, null, null);
    }

    public InsertColumnProcessor(Function<BlockDataId, BlockData> blocksFunction, IntCombiner blockMerge, IntCombiner fluidMerge) {
        this.blocksFunction = blocksFunction;
        this.blockMerge = blockMerge;
        this.fluidMerge = fluidMerge;
    }

    @Override
    public boolean apply(ColumnData colData, Tile tile) {
        ColumnId columnId = colData.getColumnId();
        InsertLayer insertLayer = tile.get(InsertLayer.class);
        if (insertLayer == null) {
            return false;
        }
        Vec3i origin = columnId.getWorld(null);
        LeafData[] leafs = colData.getLeafs();
        FluidData[] fluids = colData.getFluid();
        int yStop = leafs.length * LEAF_SIZE;
        boolean changed = false;
        for (BlockInsert insert : insertLayer.getInserts(columnId)) {
            BlockData blocks = this.blocksFunction.apply(insert.blockDataId);
            if (blocks == null) {
                log.warn("No block data found for:" + insert);
                continue;
            }
            int carveFlags = insert.carveFlags;
            boolean carveBelow = (carveFlags & 1) != 0;
            boolean carveInner = (carveFlags & 2) != 0;
            boolean carveAbove = (carveFlags & 4) != 0;
            boolean extendDown = (carveFlags & 8) != 0;
            boolean extendUp = (carveFlags & 0x10) != 0;
            CellArray cells = blocks.getCells();
            CellArray fluid = blocks.getFluid();
            int xMin = insert.world.x - origin.x;
            int yMin = insert.world.y;
            int zMin = insert.world.z - origin.z;
            int xMax = xMin + insert.xSize;
            int yMax = yMin + insert.ySize;
            int zMax = zMin + insert.zSize;
            int xSource = 0;
            int zSource = 0;
            if (xMin < 0) {
                xSource -= xMin;
                xMin = 0;
            }
            if (zMin < 0) {
                zSource -= zMin;
                zMin = 0;
            }
            xMax = Math.min(xMax, LEAF_SIZE);
            zMax = Math.min(zMax, LEAF_SIZE);
            int xSize = xMax - xMin;
            int ySize = yMax - yMin;
            int zSize = zMax - zMin;
            int minLayer = yMin / LEAF_SIZE;
            int maxLayer = (yMax - 1) / LEAF_SIZE;
            for (int i = 0; i < xSize; ++i) {
                for (int k = 0; k < zSize; ++k) {
                    int yBottom = -1;
                    int baseType = 0;
                    int topType = 0;
                    if (carveBelow || carveInner) {
                        for (int y = 0; y < ySize; ++y) {
                            int type = cells.getCell(xSource + i, y, zSource + k);
                            if (type == 0) continue;
                            yBottom = y;
                            break;
                        }
                        if (extendDown) {
                            int n = baseType = yBottom == -1 ? 0 : cells.getCell(xSource + i, 0, zSource + k);
                        }
                        if (extendUp) {
                            topType = yBottom == -1 ? 0 : cells.getCell(xSource + i, ySize - 1, zSource + k);
                        }
                    } else {
                        if (extendDown) {
                            baseType = cells.getCell(xSource + i, 0, zSource + k);
                        }
                        if (extendUp) {
                            topType = cells.getCell(xSource + i, ySize - 1, zSource + k);
                        }
                    }
                    if (yBottom == -1) continue;
                    int yTop = -1;
                    if ((carveInner || carveAbove) && yBottom >= 0 && yBottom < ySize) {
                        for (int y = ySize - 1; y >= 0; --y) {
                            int type = cells.getCell(xSource + i, y, zSource + k);
                            if (type == 0) continue;
                            yTop = y;
                            break;
                        }
                    }
                    boolean copyEmpty = carveBelow && yBottom > 0;
                    int emptyType = extendDown ? baseType : 0;
                    for (int layer = minLayer; layer <= maxLayer; ++layer) {
                        LeafData leafData = leafs[layer];
                        FluidData fluidData = null;
                        if (fluid != null) {
                            fluidData = fluids[layer];
                        }
                        int yLayer = layer * LEAF_SIZE;
                        int ySource = 0;
                        int yTarget = yMin - yLayer;
                        if (yTarget < 0) {
                            ySource -= yTarget;
                            yTarget = 0;
                        }
                        int localMax = Math.min(yMax - yLayer, LEAF_SIZE);
                        int yLocalSize = localMax - yTarget;
                        for (int j = 0; j < yLocalSize; ++j) {
                            int existing;
                            int fType;
                            int y = ySource + j;
                            int type = cells.getCell(xSource + i, y, zSource + k, 0);
                            int n = fType = fluid == null ? 0 : fluid.getCell(xSource + i, y, zSource + k, 0);
                            if (type == 0 && fType == 0 && !copyEmpty) continue;
                            if (y == yBottom) {
                                copyEmpty = carveInner;
                            } else if (y == yTop) {
                                copyEmpty = carveAbove;
                            }
                            if (type == 0) {
                                if (!copyEmpty) {
                                    continue;
                                }
                            } else {
                                type |= INSERT_BITS;
                            }
                            if (type != 0 && this.blockMerge != null) {
                                existing = leafData.getCell(xMin + i, yTarget + j, zMin + k, 0);
                                type = this.blockMerge.apply(existing, type);
                            }
                            leafData.setCell(xMin + i, yTarget + j, zMin + k, type);
                            if (fluid == null) continue;
                            existing = fluidData.getCell(xMin + i, yTarget + j, zMin + k, 0);
                            fluidData.setCell(xMin + i, yTarget + j, zMin + k, fType);
                        }
                    }
                }
            }
        }
        return changed;
    }
}

