/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.ColliderType;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.ColliderFactory;
import com.simsilica.mblock.phys.collision.CubeCollider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderFactories {
    static Logger log = LoggerFactory.getLogger(ColliderFactories.class);
    private Map<String, ColliderFactory> registry = new HashMap<String, ColliderFactory>();

    public ColliderFactories() {
        this(false);
    }

    public ColliderFactories(boolean initDefaults) {
        if (initDefaults) {
            this.initializeDefaults();
        }
    }

    public void initializeDefaults() {
        this.register("cube", new CubeColliderFactory());
        this.register("wedge", new CubeColliderFactory());
        this.register("wedge-corner", new CubeColliderFactory());
        this.register("angle", new CubeColliderFactory());
        this.register("vcyl", new CubeColliderFactory());
        this.register("hcyl", new CubeColliderFactory());
        this.register("shallow-corner", new CubeColliderFactory());
        this.register("hi-wedge-corner", new CubeColliderFactory());
    }

    public void register(String name, ColliderFactory factory) {
        this.registry.put(name, factory);
    }

    public Collider[] createColliders(BlockType[] types) {
        Collider[] result = new Collider[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createCollider(types[i]);
            BlockName name = types[i] != null ? types[i].getName() : null;
            log.info("types[" + i + "]=" + name + "   collider:" + result[i]);
        }
        return result;
    }

    public Collider createCollider(BlockType type) {
        if (type == null) {
            return null;
        }
        ColliderType colliderType = type.getColliderType();
        if (colliderType == null) {
            return null;
        }
        ColliderFactory factory = this.registry.get(colliderType.getName());
        if (factory == null) {
            throw new IllegalArgumentException("No factory found for:" + colliderType.getName());
        }
        Collider result = factory.createCollider(type);
        if (colliderType.getRotation() <= 0) {
            return result;
        }
        return result.rotate(colliderType.getRotation());
    }

    public static class CubeColliderFactory
    implements ColliderFactory {
        @Override
        public Collider createCollider(BlockType type) {
            return new CubeCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().toString());
        }
    }
}

