/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.HashMap;
import java.util.Map;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.ContainerView;
import mythruna.client.ui.ItemView;
import mythruna.client.view.AvatarState;
import mythruna.client.view.GameSessionState;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.ObjectVolume;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ContainerViewState.class);
    private GameSession gameSession;
    private EntityData ed;
    private Node containerRoot;
    private GeometryFactory geomFactory;
    private EntityId avatarId;
    private PlayerContainers playerContainers;
    private Map<EntityId, ItemView> itemViews = new HashMap<EntityId, ItemView>();
    private Container activePopup;

    public ContainerViewState() {
        this.setEnabled(false);
    }

    protected EntityData getEntityData() {
        return this.ed;
    }

    protected GeometryFactory getGeomFactory() {
        return this.geomFactory;
    }

    protected GameSession getGameSession() {
        return this.gameSession;
    }

    public ItemView getItemView(Entity entity) {
        ItemView result = this.itemViews.get(entity.getId());
        if (result != null) {
            return result;
        }
        result = new ItemView(this, entity);
        EntityId id = entity.getId();
        this.containerRoot.attachChild((Spatial)result);
        this.itemViews.put(id, result);
        return result;
    }

    public void showContextActions(final ItemView item) {
        if (this.activePopup != null) {
            this.closeActivePopup();
        }
        Vector2f pos = this.getApplication().getInputManager().getCursorPosition();
        this.activePopup = new Container();
        Action action = new Action("Equip"){

            public void execute(Button source) {
                log.info("Equip!!!");
                item.runAction("Equip", new Object[0]);
                ContainerViewState.this.closeActivePopup();
            }
        };
        this.activePopup.addChild((Node)new ActionButton(action), new Object[0]);
        this.activePopup.setLocalScale(1.5f);
        this.activePopup.setLocalTranslation(pos.x, pos.y, 0.0f);
        GuiGlobals.getInstance().getPopupState().clampToGui((Spatial)this.activePopup);
        GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.activePopup);
    }

    protected void closeActivePopup() {
        if (this.activePopup != null) {
            this.activePopup.removeFromParent();
            this.activePopup = null;
        }
    }

    protected int[] sortAxes(Vec3d size) {
        int[] result = new int[3];
        if (size.x > size.y) {
            if (size.x > size.z) {
                result[0] = 0;
                if (size.y > size.z) {
                    result[1] = 1;
                    result[2] = 2;
                } else {
                    result[1] = 2;
                    result[2] = 1;
                }
            } else {
                result[0] = 2;
                result[1] = 0;
                result[2] = 1;
            }
        } else if (size.y > size.z) {
            result[0] = 1;
            if (size.x > size.z) {
                result[1] = 0;
                result[2] = 2;
            } else {
                result[1] = 2;
                result[2] = 0;
            }
        } else {
            result[0] = 2;
            result[1] = 1;
            result[2] = 0;
        }
        return result;
    }

    protected void initialize(Application app) {
        this.gameSession = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        this.ed = ((GameSessionState)this.getState(GameSessionState.class, true)).getEntityData();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.avatarId = ((AvatarState)this.getState(AvatarState.class, true)).getAvatarId();
        this.containerRoot = new Node("containerRoot");
        this.containerRoot.setLocalScale(5.0f);
        this.playerContainers = new PlayerContainers(this.ed, this.avatarId);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.playerContainers.start();
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getRoot().attachChild((Spatial)this.containerRoot);
    }

    protected void onDisable() {
        this.playerContainers.stop();
        this.containerRoot.removeFromParent();
        this.closeActivePopup();
    }

    public void update(float tpf) {
        this.playerContainers.update();
    }

    private class PlayerContainers
    extends EntityContainer<ContainerView> {
        public PlayerContainers(EntityData ed, EntityId player) {
            super(ed, new Class[]{ContainedIn.class, ObjectVolume.class, ContainerVolume.class});
            this.setFilter(Filters.fieldEquals(ContainedIn.class, (String)"container", (Object)player));
        }

        protected ContainerView addObject(Entity e) {
            log.info("add container:" + e);
            ContainerView view = new ContainerView(ContainerViewState.this, ContainerViewState.this.ed, e);
            this.updateObject(view, e);
            view.setPosition(10.0f, view.getItemSize().y + 10.0f);
            return view;
        }

        protected void updateObject(ContainerView object, Entity e) {
            log.info("update container:" + (Object)((Object)object));
        }

        protected void removeObject(ContainerView object, Entity e) {
            log.info("remove container:" + (Object)((Object)object));
            object.release();
        }
    }
}

