/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.Axis;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import java.util.Objects;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.TimeState;
import mythruna.client.view.BlockTypeSelectionState;
import mythruna.client.view.DiggerManipulator;
import mythruna.client.view.GameSessionState;
import mythruna.client.view.ManipulatorType;
import mythruna.es.Holding;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationInputState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ActivationInputState.class);
    public static final String GROUP_ACTIVATION = "Activation";
    public static final FunctionId F_PRIMARY = new FunctionId("Activation", "Primary");
    public static final FunctionId F_PRIMARY_ALT = new FunctionId("Activation", "Primary Alt");
    public static final FunctionId F_SECONDARY = new FunctionId("Activation", "Secondary");
    public static final FunctionId F_SECONDARY_ALT = new FunctionId("Activation", "Secondary Alt");
    public static final FunctionId F_PRIMARY_SELECTOR = new FunctionId("Activation", "Primary Sel.");
    public static final FunctionId F_SECONDARY_SELECTOR = new FunctionId("Activation", "Secondary Sel.");
    private EntityData ed;
    private EntityId avatarId;
    private GameSession session;
    private ActivationHandler activationHandler = new ActivationHandler();
    private SessionObserver sessionObserver = new SessionObserver();
    private TimeState time;
    private Node cursor;
    private Geometry cursorGeom;
    private int size = 24;
    private ColorRGBA cursorColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private WatchedEntity mainHand;
    private Holding mainHolding;
    private ManipulatorType mainManipulator;

    protected Node getGuiNode() {
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    protected void initialize(Application app) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.time = (TimeState)this.getState(TimeState.class, true);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        GuiGlobals globals = GuiGlobals.getInstance();
        InputMapper inputMapper = globals.getInputMapper();
        inputMapper.map(F_PRIMARY, Button.MOUSE_BUTTON1, new Object[0]);
        inputMapper.map(F_PRIMARY_ALT, Button.MOUSE_BUTTON2, new Object[0]);
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{29});
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{157});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{29});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{157});
        inputMapper.map(F_PRIMARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[0]);
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{29});
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{157});
        float quadSize = (float)this.size * 4.0f / 3.0f;
        Quad quad = new Quad(quadSize, quadSize);
        Texture texture = globals.loadTexture("Interface/glass-orb-dark-48.png", false, false);
        this.cursorGeom = new Geometry("cursor", (Mesh)quad);
        Material mat = globals.createMaterial(texture, false).getMaterial();
        mat.setColor("Color", this.cursorColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.cursorGeom.setMaterial(mat);
        this.cursor = new Node("cursor");
        this.cursorGeom.center();
        this.cursor.attachChild((Spatial)this.cursorGeom);
        float scale = (float)app.getCamera().getHeight() / 900.0f;
        this.cursor.setLocalScale(scale);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.resetCursorPosition();
        this.getGuiNode().attachChild((Spatial)this.cursor);
        log.info("cursor size:" + this.cursor.getWorldBound() + "  cursor scale:" + this.cursor.getWorldScale());
        this.mainHand = this.ed.watchEntity(this.avatarId, new Class[]{Holding.class});
        this.setMainManipulator((Holding)this.mainHand.get(Holding.class));
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(GROUP_ACTIVATION);
        inputMapper.addDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary", true);
        inputMapper.addDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt", true);
        inputMapper.addDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary", true);
        inputMapper.addDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt", true);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
    }

    public void update(float tpf) {
        if (this.mainHand.applyChanges()) {
            this.setMainManipulator((Holding)this.mainHand.get(Holding.class));
        }
    }

    protected void onDisable() {
        this.cursor.removeFromParent();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(GROUP_ACTIVATION);
        inputMapper.removeDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary");
        inputMapper.removeDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt");
        inputMapper.removeDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary");
        inputMapper.removeDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt");
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
    }

    protected void setMainManipulator(Holding holding) {
        if (Objects.equals(this.mainHolding, holding)) {
            return;
        }
        if (holding != null) {
            log.info("setMainManipulator(" + holding.toString(this.ed) + ")");
        }
        if (this.mainManipulator != null) {
            this.mainManipulator.setTarget(null);
        }
        this.mainHolding = holding;
        if (this.mainHolding == null) {
            this.mainManipulator = null;
        } else {
            this.mainManipulator = new DiggerManipulator(this.session){

                @Override
                public void change(int delta) {
                    ((BlockTypeSelectionState)ActivationInputState.this.getState(BlockTypeSelectionState.class)).adjustRotation(delta);
                    super.change(delta);
                }
            };
            this.mainManipulator.setTarget(holding.getTarget());
        }
    }

    protected void resetCursorPosition() {
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        this.cursor.setLocalTranslation((float)width * 0.5f, (float)height * 0.5f, 0.0f);
    }

    public class ActivationHandler
    implements AnalogFunctionListener {
        public void setPrimary(InputState state) {
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.activate(pressed);
        }

        public void setPrimaryAlt(InputState state) {
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.altActivate(pressed);
        }

        public void setSecondary(InputState state) {
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondary", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void setSecondaryAlt(InputState state) {
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondaryAlt", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == F_PRIMARY_SELECTOR) {
                ActivationInputState.this.mainManipulator.change((int)value);
            }
        }
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver() {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }
    }
}

