/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.action.AbstractObjectAction;
import com.simsilica.action.ActionContext;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.net.BodyVisibility;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameSystemManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.GameConstants;
import mythruna.cmd.Command;
import mythruna.cmd.CommandSystem;
import mythruna.cmd.Context;
import mythruna.es.AttachedTo;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.Holding;
import mythruna.es.MovementInput;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.ObjectVolume;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellService;
import mythruna.sim.PathRecorderSystem;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(GameSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = GameSessionHostedService.class.getName();
    private GameSystemManager gameSystems;
    private EntityData ed;
    private CommandSystem<GameSessionImpl, EntityId> cmdProc;
    private RmiHostedService rmiService;
    private List<GameSessionImpl> players = new CopyOnWriteArrayList<GameSessionImpl>();
    private ObjectTypeRegistry<ActivatorImpl, EntityId> objectTypes;
    private ObjectType<ActivatorImpl, EntityId> wandType;

    public GameSessionHostedService(final GameSystemManager gameSystems) {
        this.gameSystems = gameSystems;
        this.setAutoHost(false);
        this.objectTypes = new ObjectTypeRegistry().typeNameResolver(id -> {
            ObjectTypeInfo typeInfo = (ObjectTypeInfo)this.ed.getComponent(id, ObjectTypeInfo.class);
            return typeInfo == null ? null : typeInfo.getTypeName(this.ed);
        });
        AbstractObjectAction<ActivatorImpl, EntityId> equip = new AbstractObjectAction<ActivatorImpl, EntityId>("Equip", new Class[0]){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId actor = ((ActivatorImpl)env.getActivator()).getId();
                ContainedIn in = (ContainedIn)GameSessionHostedService.this.ed.getComponent((EntityId)context.getTarget(), ContainedIn.class);
                log.info("  root:" + in.getRoot() + "  activator:" + actor);
                if (!Objects.equals(in.getRoot(), actor)) {
                    return false;
                }
                Holding holding = (Holding)GameSessionHostedService.this.ed.getComponent(actor, Holding.class);
                EntityId existing = holding == null ? null : holding.getTarget();
                GameSessionHostedService.this.ed.setComponents(actor, new EntityComponent[]{Holding.create((EntityId)context.getTarget(), "Digger", GameSessionHostedService.this.ed)});
                if (existing != null) {
                    GameSessionHostedService.this.ed.removeComponent(existing, AttachedTo.class);
                }
                Quatd rot = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0);
                double itemScale = ((ShapeInfo)GameSessionHostedService.this.ed.getComponent((EntityId)context.getTarget(), ShapeInfo.class)).getScale();
                ObjectType type = context.getType();
                Vec3d handle = (Vec3d)type.getTypeVar("handleLocation", (Object)new Vec3d());
                Quatd handleRot = (Quatd)type.getTypeVar("handleRotation", (Object)new Quatd());
                rot = rot.mult(handleRot);
                handle = handle.mult(-itemScale);
                rot.mult(handle, handle);
                GameSessionHostedService.this.ed.setComponents((EntityId)context.getTarget(), new EntityComponent[]{AttachedTo.create(actor, "hand.right", handle, rot, GameSessionHostedService.this.ed)});
                return true;
            }
        };
        ArrayList<AbstractObjectAction> actions = new ArrayList<AbstractObjectAction>();
        actions.add(equip);
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("startDigging", new Class[0]){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("stopDigging", new Class[0]){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                Iterator<BlockIterator.Intersection> it = ((ActivatorImpl)env.getActivator()).pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    ((World)gameSystems.get(World.class)).setWorldCell(intersect.getBlock().toVec3d(), 0);
                }
                return true;
            }
        });
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("startFilling", new Class[0]){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("stopFilling", new Class[0]){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                Iterator<BlockIterator.Intersection> it;
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                Integer selected = (Integer)((ActivatorImpl)env.getActivator()).vars.get("selectedType");
                if (selected == null) {
                    selected = 1;
                }
                if ((it = ((ActivatorImpl)env.getActivator()).pick()).hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    Vec3d pos = intersect.getBlock().toVec3d();
                    pos.addLocal(intersect.getNormal());
                    ((World)gameSystems.get(World.class)).setWorldCell(pos, selected.intValue());
                }
                return true;
            }
        });
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("rotate", new Class[]{Integer.class}){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        this.wandType = this.objectTypes.registerType(new ObjectType("BuildWand", actions));
        this.wandType.setTypeVar("handleLocation", (Object)new Vec3d(1.5, 1.5, 3.0));
        actions = new ArrayList();
        actions.add(equip);
        this.objectTypes.registerType(new ObjectType("BaseItem", actions));
        ObjectType type = this.objectTypes.registerType(new ObjectType("Axe", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(6.0, 0.0, 5.0));
        type = this.objectTypes.registerType(new ObjectType("Sword", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(3.0, 0.0, 4.0));
        type = this.objectTypes.registerType(new ObjectType("ObjectTool", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(0.0, 3.0, 0.0));
        type.setTypeVar("handleRotation", (Object)new Quatd().fromAngles(1.5707963267948966, 0.0, 0.0));
        type = this.objectTypes.registerType(new ObjectType("Book", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(0.0, 4.0, 1.0));
        type.setTypeVar("handleRotation", (Object)new Quatd().fromAngles(1.5707963267948966, Math.PI, 0.0));
        actions = new ArrayList();
        actions.add(new AbstractObjectAction<ActivatorImpl, EntityId>("drop", new Class[]{EntityId.class, Integer.class, Integer.class}){

            public boolean run(ActionEnvironment<ActivatorImpl, EntityId> env, ActionContext<ActivatorImpl, EntityId> context, Object ... args) {
                EntityId item = (EntityId)args[0];
                int xSlot = (Integer)args[1];
                int ySlot = (Integer)args[2];
                log.info(context.getTarget() + ".drop(" + item + ", " + xSlot + ", " + ySlot + ")");
                ContainedIn in = (ContainedIn)GameSessionHostedService.this.ed.getComponent((EntityId)context.getTarget(), ContainedIn.class);
                GameSessionHostedService.this.ed.setComponent(item, (EntityComponent)new ContainedIn(in.getRoot(), (EntityId)context.getTarget(), xSlot, ySlot));
                return true;
            }
        });
        this.objectTypes.registerType(new ObjectType("Backpack", actions));
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionHostedService requires an RMI service.");
        }
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
    }

    public void start() {
        super.start();
        EntityDataHostedService eds = (EntityDataHostedService)this.getService(EntityDataHostedService.class);
        if (eds == null) {
            throw new RuntimeException("AccountHostedService requires an EntityDataHostedService");
        }
        this.ed = eds.getEntityData();
        this.cmdProc = (CommandSystem)((Object)this.gameSystems.get(CommandSystem.class));
        this.cmdProc.registerCommand("record", new RecordCommand(), new Class[0]);
        this.cmdProc.registerCommand("play", new PlayCommand(), new Class[0]);
        this.cmdProc.registerCommand("stop", new StopCommand(), new Class[0]);
        this.cmdProc.registerCommand("selectType", new SelectTypeCommand(), new Class[0]);
        ActivateCommand activate = new ActivateCommand();
        this.cmdProc.registerCommand("activatePrimary", activate, new Class[0]);
        this.cmdProc.registerCommand("activatePrimaryAlt", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondary", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondaryAlt", activate, new Class[0]);
        for (String s : this.cmdProc.getCommandNames()) {
            this.ed.getStrings().getStringId(s, true);
        }
        for (ObjectType type : this.objectTypes) {
            for (String s : type.getActionNames()) {
                this.ed.getStrings().getStringId(s, true);
            }
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void startHostingOnConnection(HostedConnection conn, EntityId character) {
        log.debug("startHostingOnConnection(" + conn + ", " + character + ")");
        GameSessionImpl session = new GameSessionImpl(conn, character);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)session, GameSession.class);
        this.players.add(session);
        session.initialize();
        ((ChatHostedService)this.getService(ChatHostedService.class)).startHostingOnConnection(conn, session.getPlayerName());
    }

    protected GameSessionImpl getGameSession(HostedConnection conn) {
        return (GameSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        GameSessionImpl session = this.getGameSession(conn);
        if (session != null) {
            session.close();
            this.players.remove(session);
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected EntityId createBuildWand(EntityId target) {
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)"Build Wand");
        EntityId existing = this.ed.findEntity(filter, new Class[]{Name.class});
        if (existing != null) {
            log.info("Test entity already exists:" + existing);
            log.info("Removing it");
            this.ed.removeEntity(existing);
        }
        double itemScale = 0.0625;
        itemScale *= 0.5;
        Quatd rot = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0);
        Vec3d handle = new Vec3d(1.5, 1.5, 3.0);
        handle.multLocal(-(itemScale *= 0.5));
        rot.mult(handle, handle);
        EntityId item = this.ed.createEntity();
        this.ed.setComponents(item, new EntityComponent[]{new Name("Build Wand"), new Mass(0.01), new ObjectVolume(new Vec3d(3.0, 3.0, 13.0).multLocal(itemScale)), ShapeInfo.create((String)"/Models/items/wand1.blocks", (double)itemScale, (EntityData)this.ed), AttachedTo.create(target, "hand.right", handle, rot, this.ed), ObjectTypeInfo.create("BuildWand", this.ed)});
        log.info("Created test entity:" + item);
        return item;
    }

    protected EntityId createBackpack(EntityId target) {
        CellArray cells;
        ComponentFilter filter = Filters.fieldEquals(ContainedIn.class, (String)"container", (Object)target);
        EntityId result = this.ed.findEntity(filter, new Class[]{ContainedIn.class});
        if (result != null) {
            log.info("Backpack already exists:" + result);
        } else {
            result = this.ed.createEntity();
        }
        double itemScale = 0.0625;
        itemScale *= 0.5;
        Quatd rot = new Quatd().fromAngles(0.0, 0.0, 0.0);
        try {
            cells = BlocksFileFormat.loadCellArray((String)"/Models/items/backpack2.blocks");
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading:/Models/items/backpack2.blocks", e);
        }
        log.info("backpack cells size:" + cells.getSize() + "  itemScale:" + itemScale);
        Vec3d blockSize = cells.getSize().toVec3d();
        blockSize.x = 8.0;
        blockSize.z = 5.0;
        Vec3d innerBlockSize = new Vec3d(7.0, 9.0, 3.5);
        Vec3d size = blockSize.mult(itemScale);
        log.info("backpack physical size:" + size);
        Vec3d innerSize = innerBlockSize.mult(itemScale);
        Vec3d offset = size.subtract(innerSize).mult(0.5);
        offset.y = itemScale;
        this.ed.setComponents(result, new EntityComponent[]{ShapeInfo.create((String)"/Models/items/backpack2.blocks", (double)itemScale, (EntityData)this.ed), AttachedTo.create(target, "back", new Vec3d(-4.0 * itemScale, -5.0 * itemScale, 0.0), rot, this.ed), ObjectTypeInfo.create("Backpack", this.ed), new Mass(0.01), new ObjectVolume(size), new ContainerVolume(innerSize, offset), new ContainedIn(target, target, 0, 0)});
        EntityId item = this.createItem("Sword", "Sword", "/Models/items/sword1.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 2, 0)});
        item = this.createItem("Axe", "Axe", "/Models/items/axe1.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 6, 0)});
        item = this.createItem("Book", "Book", "/Models/items/book.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 10, 0)});
        item = this.createItem("Object Tool", "ObjectTool", "/Models/items/etcher.blocks", itemScale * 0.5);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 16, 0)});
        return result;
    }

    protected EntityId createItem(String name, String type, String shape, double scale) {
        CellArray cells;
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)name);
        EntityId result = this.ed.findEntity(filter, new Class[]{Name.class});
        if (result != null) {
            log.info(name + " already exists:" + result);
            log.info(name + ":");
            log.info("     :" + this.ed.getComponent(result, ContainedIn.class));
            log.info("     :" + this.ed.getComponent(result, ObjectVolume.class));
            log.info("     :" + this.ed.getComponent(result, ShapeInfo.class));
            log.info("     :" + this.ed.getComponent(result, AttachedTo.class));
            for (EntityId id : this.ed.findEntities(filter, new Class[]{Name.class})) {
                log.info(id + ":");
                log.info("     :" + this.ed.getComponent(id, ContainedIn.class));
                log.info("     :" + this.ed.getComponent(id, ObjectVolume.class));
                log.info("     :" + this.ed.getComponent(id, ShapeInfo.class));
                log.info("     :" + this.ed.getComponent(id, AttachedTo.class));
            }
        } else {
            result = this.ed.createEntity();
            log.info("Created " + name + " as:" + result);
        }
        try {
            cells = BlocksFileFormat.loadCellArray((String)shape);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading:" + shape, e);
        }
        Vec3d size = cells.getSize().toVec3d();
        if ("/Models/items/sword1.blocks".equals(shape)) {
            size.x = 3.0;
        }
        size.multLocal(scale);
        this.ed.setComponents(result, new EntityComponent[]{new Name(name), new Mass(0.01), ShapeInfo.create((String)shape, (double)scale, (EntityData)this.ed), ObjectTypeInfo.create(type, this.ed), new ObjectVolume(size)});
        log.info("After update:" + name + ":");
        log.info("     :" + this.ed.getComponent(result, ContainedIn.class));
        log.info("     :" + this.ed.getComponent(result, ObjectVolume.class));
        log.info("     :" + this.ed.getComponent(result, ShapeInfo.class));
        log.info("     :" + this.ed.getComponent(result, AttachedTo.class));
        return result;
    }

    private class RecordCommand
    implements Command<GameSessionImpl, EntityId> {
        private RecordCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).record(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class PlayCommand
    implements Command<GameSessionImpl, EntityId> {
        private PlayCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).play(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class StopCommand
    implements Command<GameSessionImpl, EntityId> {
        private StopCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                long duration = ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).stop(subject);
                context.getSource().echo(String.format("%.02f", (double)duration / 1.0E9));
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class SelectTypeCommand
    implements Command<GameSessionImpl, EntityId> {
        private SelectTypeCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info("selectType(" + cmd + ", " + Arrays.asList(parms) + ")");
            context.getSource().vars.put("selectedType", parms[0]);
        }
    }

    private class ActivateCommand
    implements Command<GameSessionImpl, EntityId> {
        private ActivateCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info(this.getClass().getSimpleName() + "(" + cmd + ", " + Arrays.asList(parms) + ")");
            log.info("parms[0] class:" + parms[0].getClass());
            boolean pressed = Boolean.TRUE.equals(parms[0]);
            if ("activatePrimary".equals(cmd)) {
                throw new UnsupportedOperationException();
            }
            if ("activatePrimaryAlt".equals(cmd)) {
                log.info("**** activatePrimaryAlt ***");
                throw new UnsupportedOperationException();
            }
            if ("activateSecondary".equals(cmd)) {
                if (!pressed) {
                    return;
                }
                Iterator<BlockIterator.Intersection> it = context.getSource().activator.pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    DefaultWorld world = (DefaultWorld)GameSessionHostedService.this.gameSystems.get(World.class);
                    ColumnId colId = ColumnId.fromWorld((Vec3d)intersect.getPoint());
                    long start = System.nanoTime();
                    world.recalculateLighting(colId);
                    long end = System.nanoTime();
                    context.getSource().echo(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
                    Vec3d point = intersect.getPoint();
                    int existing = world.getWorldCell(point);
                    world.setWorldCell(point, 1);
                    world.setWorldCell(point, existing);
                }
            } else {
                context.getSource().echo("Unknown command:" + cmd);
            }
        }
    }

    private class GameSessionImpl
    implements GameSession {
        private HostedConnection conn;
        private GameSessionListener callback;
        private EntityId characterEntity;
        private EntityId avatarEntity;
        private CommandShell shell;
        private Vec3d spawnLoc;
        private Quatd spawnRot;
        private Context<GameSessionImpl> commandContext;
        private Map<String, Object> vars = new HashMap<String, Object>();
        private ActivatorImpl activator;
        private ActionContext<ActivatorImpl, EntityId> backpack;
        private ActionEnvironment<ActivatorImpl, EntityId> actionEnv;
        private ActionContext<ActivatorImpl, EntityId> buildWand;

        public GameSessionImpl(HostedConnection conn, EntityId characterEntity) {
            this.conn = conn;
            this.characterEntity = characterEntity;
            this.avatarEntity = characterEntity;
            this.shell = ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).createChildShell(this.avatarEntity);
            this.shell.setVariables(this.vars);
            this.shell.setOutput(line -> this.callback.newConsoleMessage((String)line));
            this.shell.put("avatar", this.avatarEntity);
            this.commandContext = new Context<GameSessionImpl>(this);
            this.activator = new ActivatorImpl(this.avatarEntity, this.vars);
            WorldManager world = (WorldManager)GameSessionHostedService.this.gameSystems.get(WorldManager.class, true);
            SpawnPosition pos = (SpawnPosition)GameSessionHostedService.this.ed.getComponent(characterEntity, SpawnPosition.class);
            if (pos == null) {
                log.info("Player has no previous spawn position, getting it from the world...");
                this.spawnLoc = world.getInfo().getSpawnPoint();
                log.info("spawnLoc:" + this.spawnLoc);
                this.spawnLoc.y += 20.0;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, new Quatd());
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            this.spawnLoc = pos.getLocation();
            this.spawnRot = pos.getOrientation();
            if (Math.floor(this.spawnLoc.x) == this.spawnLoc.x && Math.floor(this.spawnLoc.z) == this.spawnLoc.z) {
                log.info("Adjusting spawn loc to block center");
                this.spawnLoc.x += 0.5;
                this.spawnLoc.z += 0.5;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
            GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            int elevation = world.getElevation((int)this.spawnLoc.x, (int)this.spawnLoc.z);
            log.info("spawn loc:" + this.spawnLoc + "  real elevation:" + elevation);
            ShapeInfo femaleShape = ShapeInfo.create((String)"human/female/human-female.rig", (double)1.0, (EntityData)GameSessionHostedService.this.ed);
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{new Mass(60.0), femaleShape});
            log.info("Adding animation config to:" + this.avatarEntity);
            EntityId anim = GameSessionHostedService.this.ed.createEntity();
            GameSessionHostedService.this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.avatarEntity, new LayerConfig[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Jog"})})});
            this.backpack = GameSessionHostedService.this.objectTypes.getContext((Object)GameSessionHostedService.this.createBackpack(this.avatarEntity));
            EntityId test = GameSessionHostedService.this.createBuildWand(this.avatarEntity);
            GameSessionHostedService.this.ed.setComponents(test, new EntityComponent[]{new ContainedIn(this.avatarEntity, (EntityId)this.backpack.getTarget(), 0, 0)});
            this.actionEnv = GameSessionHostedService.this.objectTypes.createEnvironment((Object)this.activator);
            this.buildWand = GameSessionHostedService.this.objectTypes.getContext((Object)test);
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{Holding.create(test, "Digger", GameSessionHostedService.this.ed)});
        }

        public String getPlayerName() {
            Name name = (Name)GameSessionHostedService.this.ed.getComponent(this.characterEntity, Name.class);
            return name.getName();
        }

        public void initialize() {
            log.info("GameSessionImpl.initialize()");
            if (this.getCallback(false) != null) {
                this.getCallback(true).setAvatar(this.avatarEntity);
            } else {
                log.warn("No game session callback registered so can't send avatar entity.");
            }
            log.info("Spawning user at:" + this.spawnLoc);
            EtherealHost ethereal = (EtherealHost)GameSessionHostedService.this.getService(EtherealHost.class);
            ethereal.startHostingOnConnection(this.conn);
            ethereal.setConnectionObject(this.conn, Long.valueOf(this.characterEntity.getId()), this.spawnLoc);
            EntityDataHostedService eds = (EntityDataHostedService)GameSessionHostedService.this.getService(EntityDataHostedService.class);
            HostedEntityData hed = eds.getHostedEntityData(this.conn);
            if (hed == null) {
                throw new RuntimeException("Can't get hosted entity data for:" + this.conn);
            }
            hed.registerComponentVisibility((ComponentVisibility)new BodyVisibility(ethereal.getStateListener(this.conn)));
            log.info("GameSessionImpl.initialized()");
        }

        public void close() {
            log.debug("Closing game session for:" + this.conn);
            ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).removeShell(this.avatarEntity);
        }

        @Override
        public EntityId getCharacter() {
            return this.characterEntity;
        }

        @Override
        public EntityId getAvatar() {
            return this.avatarEntity;
        }

        @Override
        public void setMovementInput(MovementInput input) {
            GameSessionHostedService.this.ed.setComponent(this.avatarEntity, (EntityComponent)input);
        }

        @Override
        public void executeShell(String cmd) {
            this.shell.execute(cmd);
        }

        @Override
        public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(cmdId);
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        @Override
        public void executeCommand(String cmd, EntityId subject, Object ... parms) {
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        @Override
        public void runAction(EntityId target, int actionId, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(actionId);
            this.runAction(target, cmd, parms);
        }

        @Override
        public void runAction(EntityId target, String actionName, Object ... parms) {
            ActionContext context = GameSessionHostedService.this.objectTypes.getContext((Object)target);
            context.run(this.actionEnv, actionName, parms);
        }

        protected void echo(String val) {
            this.shell.getOutput().accept(val);
        }

        protected GameSessionListener getCallback(boolean failFast) {
            if (this.callback == null) {
                RmiRegistry rmi = GameSessionHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (GameSessionListener)rmi.getRemoteObject(GameSessionListener.class);
                if (this.callback == null) {
                    if (failFast) {
                        throw new RuntimeException("Unable to locate client callback for GameSessionListener");
                    }
                    log.warn("Unable to locate client callback for GameSessionListener");
                }
            }
            return this.callback;
        }
    }

    private class ActivatorImpl {
        private EntityId entity;
        private BodyPosition bPos;
        private MBlockCollisionSystem collisionSystem;
        private Map<String, Object> vars;

        public ActivatorImpl(EntityId entity, Map<String, Object> vars) {
            this.entity = entity;
            this.vars = vars;
            this.collisionSystem = (MBlockCollisionSystem)((MPhysSystem)GameSessionHostedService.this.gameSystems.get(MPhysSystem.class, true)).getCollisionSystem();
        }

        public EntityId getId() {
            return this.entity;
        }

        private BodyPosition getBodyPosition() {
            if (this.bPos == null) {
                this.bPos = this.getAt(BodyPosition.class);
            }
            return this.bPos;
        }

        public Vec3d getEyePos() {
            Vec3d pos = this.getPos();
            return pos.add(0.0, 1.5, 0.0);
        }

        public Vec3d getPos() {
            return this.getBodyPosition().getLastLocation();
        }

        public Vec3d getLookDir() {
            return this.getLookOrientation().mult(Vec3d.UNIT_Z);
        }

        public Vec3d getDir() {
            return this.getOrientation().mult(Vec3d.UNIT_Z);
        }

        public Quatd getLookOrientation() {
            MovementInput mi = this.getAt(MovementInput.class);
            if (mi == null) {
                return null;
            }
            return mi.getFacing();
        }

        public Quatd getOrientation() {
            return this.getBodyPosition().getLastOrientation();
        }

        public Iterator<BlockIterator.Intersection> pick() {
            Rayd ray = new Rayd(this.getEyePos(), this.getLookDir());
            return this.collisionSystem.rayIterator(ray, 10.0);
        }

        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(GameSessionHostedService.this.ed.getComponent(this.entity, type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }
    }
}

