/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.TileManager;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseColumnProcessor
implements TileColumnProcessor {
    static Logger log = LoggerFactory.getLogger(BaseColumnProcessor.class);
    public static final int TERRAIN_BITS = CellGenType.Terrain.apply(0);
    private WorldFractal fractal;
    private TileManager tileManager;
    private int sandType;
    private int dirtType;
    private int grassType;
    private int stoneType;
    private int snowType;
    private int badType;
    private int waterType;
    private int seaLevel = 128;
    private int treeLine = 500;

    public BaseColumnProcessor(WorldFractal fractal, TileManager tileManager) {
        this.fractal = fractal;
        this.tileManager = tileManager;
        this.badType = BlockTypeIndex.getBadTypeIndex();
        this.sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1) | TERRAIN_BITS;
        this.dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1) | TERRAIN_BITS;
        this.grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1) | TERRAIN_BITS;
        this.stoneType = BlockTypeIndex.findType((BlockName)new BlockName("stone", "cube"), (int)1) | TERRAIN_BITS;
        this.snowType = BlockTypeIndex.findType((BlockName)new BlockName("snow", "cube"), (int)1) | TERRAIN_BITS;
        this.waterType = FluidTypeIndex.findType((FluidName)new FluidName("water"), (int)1);
    }

    public boolean apply(ColumnData col, Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluidLevels = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        ColumnId columnId = col.getColumnId();
        Vec3i local = columnId.getTileLocal(null);
        int size = 32;
        int leafCount = col.getLeafs().length;
        for (int i = 0; i < size; ++i) {
            block5: for (int k = 0; k < size; ++k) {
                int topBlock;
                int xp = local.x + i;
                int zp = local.z + k;
                int elevation = terrain.getElevation(xp, zp);
                byte type = terrain.getType(xp, zp);
                int baseType = TerrainTypes.getBaseType(type);
                int foliage = TerrainTypes.getFoliageLevel(type);
                boolean frozen = TerrainTypes.isFrozen(type);
                short fluidLevel = fluidLevels.getElevation(xp, zp);
                byte fluidType = fluidLevels.getType(xp, zp);
                int fillBlock = this.stoneType;
                boolean grassy = foliage > 0 && elevation >= fluidLevel;
                switch (baseType) {
                    case 0: {
                        topBlock = this.sandType;
                        break;
                    }
                    case 1: {
                        topBlock = this.dirtType;
                        break;
                    }
                    default: {
                        topBlock = this.stoneType;
                    }
                }
                int y = 0;
                for (int layer = 0; layer < leafCount; ++layer) {
                    LeafData leaf = col.getLeafData(y);
                    FluidData fluid = col.getFluidData(y);
                    int j = 0;
                    while (j < 32) {
                        if (y == 0) {
                            leaf.setCell(i, j, k, this.dirtType);
                        } else if (y >= elevation) {
                            if (y < fluidLevel - 1) {
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)8));
                            } else {
                                if (y != fluidLevel - 1) break;
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)6));
                            }
                        } else if (y == elevation - 1) {
                            if (frozen) {
                                leaf.setCell(i, j, k, this.snowType);
                            } else if (grassy) {
                                leaf.setCell(i, j, k, this.grassType);
                            } else {
                                leaf.setCell(i, j, k, topBlock);
                            }
                        } else if (y == elevation - 2) {
                            if (frozen) {
                                if (grassy) {
                                    leaf.setCell(i, j, k, this.grassType);
                                } else {
                                    leaf.setCell(i, j, k, topBlock);
                                }
                            } else {
                                leaf.setCell(i, j, k, fillBlock);
                            }
                        } else if (y == elevation - 3) {
                            if (frozen && grassy) {
                                leaf.setCell(i, j, k, this.dirtType);
                            } else {
                                leaf.setCell(i, j, k, fillBlock);
                            }
                        } else {
                            leaf.setCell(i, j, k, fillBlock);
                        }
                        ++j;
                        ++y;
                    }
                    if (y > elevation && y > fluidLevel) continue block5;
                }
            }
        }
        return true;
    }
}

